/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.spnego.KerberosConfig;
import io.airlift.http.client.spnego.SpnegoAuthentication;
import io.airlift.http.client.spnego.SpnegoAuthenticationStore;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class SpnegoHttpClient
extends HttpClient {
    private final AuthenticationStore authenticationStore;
    private final SpnegoAuthentication spnego;

    public SpnegoHttpClient(KerberosConfig kerberosConfig, HttpClientConfig config, HttpClientTransport transport, SslContextFactory sslContextFactory) {
        super(transport, sslContextFactory);
        this.spnego = new SpnegoAuthentication(kerberosConfig.getKeytab(), kerberosConfig.getConfig(), kerberosConfig.getCredentialCache(), config.getKerberosPrincipal(), config.getKerberosRemoteServiceName(), kerberosConfig.isUseCanonicalHostname());
        this.authenticationStore = new SpnegoAuthenticationStore(this.spnego);
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    protected void doStop() throws Exception {
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
    }
}

