/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FileBodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.jetty.AuthorizationPreservingHttpClient;
import io.airlift.http.client.jetty.BodyGeneratorContentProvider;
import io.airlift.http.client.jetty.BufferingResponseListener;
import io.airlift.http.client.jetty.CachedDistribution;
import io.airlift.http.client.jetty.ConcurrentScheduler;
import io.airlift.http.client.jetty.ConnectionPoolDistribution;
import io.airlift.http.client.jetty.ConnectionStats;
import io.airlift.http.client.jetty.DefaultHttpClientLogger;
import io.airlift.http.client.jetty.DestinationDistribution;
import io.airlift.http.client.jetty.HttpClientLogger;
import io.airlift.http.client.jetty.HttpClientLoggingListener;
import io.airlift.http.client.jetty.JettyAsyncSocketAddressResolver;
import io.airlift.http.client.jetty.JettyClientDiagnostics;
import io.airlift.http.client.jetty.JettyLogging;
import io.airlift.http.client.jetty.JettyRequestListener;
import io.airlift.http.client.jetty.JettyResponse;
import io.airlift.http.client.jetty.JettyResponseFuture;
import io.airlift.http.client.jetty.NoopLogger;
import io.airlift.http.client.jetty.QueuedThreadPoolMBean;
import io.airlift.http.client.jetty.RequestDistribution;
import io.airlift.http.client.spnego.KerberosConfig;
import io.airlift.http.client.spnego.SpnegoAuthentication;
import io.airlift.http.client.spnego.SpnegoAuthenticationProtocolHandler;
import io.airlift.http.client.spnego.SpnegoAuthenticationStore;
import io.airlift.security.pem.PemReader;
import io.airlift.units.Duration;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.PoolingHttpDestination;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JettyHttpClient
implements HttpClient {
    private static final String STATS_KEY = "airlift_stats";
    private static final long SWEEP_PERIOD_MILLIS = 5000L;
    private static final AtomicLong NAME_COUNTER;
    private final org.eclipse.jetty.client.HttpClient httpClient;
    private final long maxContentLength;
    private final long requestTimeoutMillis;
    private final long idleTimeoutMillis;
    private final boolean recordRequestComplete;
    private final boolean logEnabled;
    private final QueuedThreadPoolMBean queuedThreadPoolMBean;
    private final ConnectionStats connectionStats;
    private final RequestStats stats = new RequestStats();
    private final CachedDistribution queuedRequestsPerDestination;
    private final CachedDistribution activeConnectionsPerDestination;
    private final CachedDistribution idleConnectionsPerDestination;
    private final CachedDistribution currentQueuedTime;
    private final CachedDistribution currentRequestTime;
    private final CachedDistribution currentRequestSendTime;
    private final CachedDistribution currentResponseWaitTime;
    private final CachedDistribution currentResponseProcessTime;
    private final List<HttpRequestFilter> requestFilters;
    private final Exception creationLocation = new Exception();
    private final String name;
    private final HttpClientLogger requestLogger;
    private final JettyClientDiagnostics clientDiagnostics;

    public JettyHttpClient() {
        this(new HttpClientConfig());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(JettyHttpClient.uniqueName(), config);
    }

    public JettyHttpClient(String name, HttpClientConfig config) {
        this(name, config, new KerberosConfig(), (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(String name, HttpClientConfig config, KerberosConfig kerberosConfig, Iterable<? extends HttpRequestFilter> requestFilters) {
        HttpClientTransportOverHTTP transport;
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(requestFilters, "requestFilters is null");
        this.maxContentLength = config.getMaxContentLength().toBytes();
        this.requestTimeoutMillis = config.getRequestTimeout().toMillis();
        this.idleTimeoutMillis = config.getIdleTimeout().toMillis();
        this.recordRequestComplete = config.getRecordRequestComplete();
        this.creationLocation.fillInStackTrace();
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        if (config.getKeyStorePath() != null) {
            Optional<KeyStore> pemKeyStore = JettyHttpClient.tryLoadPemKeyStore(config);
            if (pemKeyStore.isPresent()) {
                sslContextFactory.setKeyStore(pemKeyStore.get());
                sslContextFactory.setKeyStorePassword("");
            } else {
                sslContextFactory.setKeyStorePath(config.getKeyStorePath());
                sslContextFactory.setKeyStorePassword(config.getKeyStorePassword());
            }
        }
        if (config.getTrustStorePath() != null) {
            Optional<KeyStore> pemTrustStore = JettyHttpClient.tryLoadPemTrustStore(config);
            if (pemTrustStore.isPresent()) {
                sslContextFactory.setTrustStore(pemTrustStore.get());
                sslContextFactory.setTrustStorePassword("");
            } else {
                sslContextFactory.setTrustStorePath(config.getTrustStorePath());
                sslContextFactory.setTrustStorePassword(config.getTrustStorePassword());
            }
        }
        sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
        List<String> includedCipherSuites = config.getHttpsIncludedCipherSuites();
        List<String> excludedCipherSuites = config.getHttpsExcludedCipherSuites();
        sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
        sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
        if (config.isHttp2Enabled()) {
            HTTP2Client client = new HTTP2Client();
            client.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            client.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            client.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            client.setSelectors(config.getSelectorCount());
            transport = new HttpClientTransportOverHTTP2(client);
        } else {
            transport = new HttpClientTransportOverHTTP(config.getSelectorCount());
        }
        this.httpClient = new AuthorizationPreservingHttpClient((HttpClientTransport)transport, (SslContextFactory)sslContextFactory);
        this.httpClient.setRequestBufferSize(Math.toIntExact(config.getRequestBufferSize().toBytes()));
        this.httpClient.setResponseBufferSize(Math.toIntExact(config.getResponseBufferSize().toBytes()));
        if (config.getAuthenticationEnabled()) {
            SpnegoAuthenticationStore store = new SpnegoAuthenticationStore(new SpnegoAuthentication(kerberosConfig.getKeytab(), kerberosConfig.getConfig(), kerberosConfig.getCredentialCache(), config.getKerberosServicePrincipalPattern(), config.getKerberosPrincipal(), config.getKerberosRemoteServiceName(), config.getKerberosNameType(), kerberosConfig.isUseCanonicalHostname()));
            this.httpClient.setAuthenticationStore((AuthenticationStore)store);
            this.httpClient.getProtocolHandlers().remove("www-authenticate");
            this.httpClient.getProtocolHandlers().put((ProtocolHandler)new SpnegoAuthenticationProtocolHandler(this.httpClient));
        }
        this.httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        this.httpClient.setMaxRequestsQueuedPerDestination(config.getMaxRequestsQueuedPerDestination());
        this.httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        this.httpClient.setUserAgentField(null);
        this.httpClient.setIdleTimeout(this.idleTimeoutMillis);
        this.httpClient.setConnectTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setAddressResolutionTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setConnectBlocking(config.isConnectBlocking());
        HostAndPort socksProxy = config.getSocksProxy();
        if (socksProxy != null) {
            this.httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(socksProxy.getHost(), socksProxy.getPortOrDefault(1080)));
        }
        this.httpClient.setByteBufferPool((ByteBufferPool)new MappedByteBufferPool());
        QueuedThreadPool queuedThreadPool = JettyHttpClient.createExecutor(name, config.getMinThreads(), config.getMaxThreads());
        this.httpClient.setExecutor((Executor)queuedThreadPool);
        this.httpClient.addBean((Object)queuedThreadPool, true);
        this.httpClient.setScheduler(JettyHttpClient.createScheduler(name, config.getTimeoutConcurrency(), config.getTimeoutThreads()));
        this.httpClient.setSocketAddressResolver((SocketAddressResolver)new JettyAsyncSocketAddressResolver(this.httpClient.getExecutor(), this.httpClient.getScheduler(), config.getConnectTimeout().toMillis()));
        this.httpClient.addBean((Object)new Sweeper(this.httpClient.getScheduler(), 5000L), true);
        ConnectionStatistics connectionStats = new ConnectionStatistics();
        this.httpClient.addBean((Object)connectionStats);
        this.connectionStats = new ConnectionStats(connectionStats);
        this.logEnabled = config.isLogEnabled();
        if (this.logEnabled) {
            String logFilePath = Paths.get(config.getLogPath(), String.format("%s-http-client.log", name)).toAbsolutePath().toString();
            this.requestLogger = new DefaultHttpClientLogger(logFilePath, config.getLogHistory(), config.getLogQueueSize(), config.getLogBufferSize(), config.getLogFlushInterval(), config.getLogMaxFileSize().toBytes(), config.isLogCompressionEnabled());
        } else {
            this.requestLogger = new NoopLogger();
        }
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.clientDiagnostics = new JettyClientDiagnostics();
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        this.queuedThreadPoolMBean = new QueuedThreadPoolMBean((QueuedThreadPool)this.httpClient.getExecutor());
        this.activeConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getActiveConnections().size()));
        this.idleConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getIdleConnections().size()));
        this.queuedRequestsPerDestination = new DestinationDistribution(this.httpClient, (distribution, destination) -> distribution.add((long)destination.getHttpExchanges().size()));
        this.currentQueuedTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                started = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(started - listener.getCreated()));
        });
        this.currentRequestTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - started));
        });
        this.currentRequestSendTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                requestSent = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(requestSent - started));
        });
        this.currentResponseWaitTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                return;
            }
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                responseStarted = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(responseStarted - requestSent));
        });
        this.currentResponseProcessTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - responseStarted));
        });
    }

    private static Optional<KeyStore> tryLoadPemKeyStore(HttpClientConfig config) {
        File keyStoreFile = new File(config.getKeyStorePath());
        try {
            if (!PemReader.isPem((File)keyStoreFile)) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading key store file: " + keyStoreFile, e);
        }
        try {
            return Optional.of(PemReader.loadKeyStore((File)keyStoreFile, (File)keyStoreFile, Optional.ofNullable(config.getKeyStorePassword())));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM key store: " + keyStoreFile, e);
        }
    }

    private static Optional<KeyStore> tryLoadPemTrustStore(HttpClientConfig config) {
        File trustStoreFile = new File(config.getTrustStorePath());
        try {
            if (!PemReader.isPem((File)trustStoreFile)) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading trust store file: " + trustStoreFile, e);
        }
        try {
            if (PemReader.readCertificateChain((File)trustStoreFile).isEmpty()) {
                throw new IllegalArgumentException("PEM trust store file does not contain any certificates: " + trustStoreFile);
            }
            return Optional.of(PemReader.loadTrustStore((File)trustStoreFile));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM trust store: " + trustStoreFile, e);
        }
    }

    private static QueuedThreadPool createExecutor(String name, int minThreads, int maxThreads) {
        try {
            QueuedThreadPool pool = new QueuedThreadPool(maxThreads, minThreads, 60000, null);
            pool.setName("http-client-" + name);
            pool.setDaemon(true);
            pool.start();
            pool.setStopTimeout(2000L);
            pool.setDetailedDump(true);
            return pool;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Scheduler createScheduler(String name, int timeoutConcurrency, int timeoutThreads) {
        Object scheduler;
        String threadName = "http-client-" + name + "-scheduler";
        if (timeoutConcurrency == 1 && timeoutThreads == 1) {
            scheduler = new ScheduledExecutorScheduler(threadName, true);
        } else {
            Preconditions.checkArgument((timeoutConcurrency >= 1 ? 1 : 0) != 0, (Object)"timeoutConcurrency must be at least one");
            int threads = Math.max(1, timeoutThreads / timeoutConcurrency);
            scheduler = new ConcurrentScheduler(timeoutConcurrency, threads, threadName);
        }
        try {
            scheduler.start();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        T value;
        Response response;
        long requestStart = System.nanoTime();
        request = this.applyRequestFilters(request);
        JettyRequestListener requestListener = new JettyRequestListener(request.getUri());
        HttpRequest jettyRequest = this.buildJettyRequest(request, requestListener);
        InputStreamResponseListener listener = new InputStreamResponseListener(){

            public void onContent(Response response, ByteBuffer content) {
                if (content.remaining() == 0) {
                    return;
                }
                super.onContent(response, content);
            }
        };
        long requestTimestamp = System.currentTimeMillis();
        HttpClientLogger.RequestInfo requestInfo = HttpClientLogger.RequestInfo.from((org.eclipse.jetty.client.api.Request)jettyRequest, requestTimestamp);
        if (this.logEnabled) {
            this.addLoggingListener(jettyRequest, requestTimestamp);
        }
        jettyRequest.send((Response.CompleteListener)listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(requestInfo, HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            jettyRequest.abort((Throwable)e);
            Thread.currentThread().interrupt();
            return responseHandler.handleException(request, e);
        }
        catch (TimeoutException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(requestInfo, HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            jettyRequest.abort((Throwable)e);
            return responseHandler.handleException(request, e);
        }
        catch (ExecutionException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(requestInfo, HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return responseHandler.handleException(request, (Exception)cause);
            }
            if (cause instanceof NoClassDefFoundError && cause.getMessage().endsWith("ALPNClientConnection")) {
                return responseHandler.handleException(request, new RuntimeException("HTTPS cannot be used when HTTP/2 is enabled", cause));
            }
            return responseHandler.handleException(request, new RuntimeException(cause));
        }
        long responseStart = System.nanoTime();
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, listener.getInputStream());
            value = responseHandler.handle(request, jettyResponse);
        }
        finally {
            if (this.recordRequestComplete) {
                JettyHttpClient.recordRequestComplete(this.stats, request, requestStart, jettyResponse, responseStart);
            }
        }
        return value;
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(responseHandler, "responseHandler is null");
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request, new JettyRequestListener(request.getUri()));
        JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(request, (org.eclipse.jetty.client.api.Request)jettyRequest, responseHandler, this.stats, this.recordRequestComplete);
        BufferingResponseListener listener = new BufferingResponseListener(future, Ints.saturatedCast((long)this.maxContentLength));
        long requestTimestamp = System.currentTimeMillis();
        if (this.logEnabled) {
            this.addLoggingListener(jettyRequest, requestTimestamp);
        }
        try {
            jettyRequest.send((Response.CompleteListener)listener);
        }
        catch (RuntimeException e2) {
            RejectedExecutionException e2;
            if (!(e2 instanceof RejectedExecutionException)) {
                e2 = new RejectedExecutionException(e2);
            }
            future.failed(e2);
            this.requestLogger.log(HttpClientLogger.RequestInfo.from((org.eclipse.jetty.client.api.Request)jettyRequest, requestTimestamp), HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e2)));
        }
        return future;
    }

    private void addLoggingListener(HttpRequest jettyRequest, long requestTimestamp) {
        HttpClientLoggingListener loggingListener = new HttpClientLoggingListener(jettyRequest, requestTimestamp, this.requestLogger);
        jettyRequest.listener((Request.Listener)loggingListener);
        jettyRequest.onResponseBegin((Response.BeginListener)loggingListener);
        jettyRequest.onComplete((Response.CompleteListener)loggingListener);
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private HttpRequest buildJettyRequest(Request finalRequest, JettyRequestListener listener) {
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        jettyRequest.onRequestBegin(request -> listener.onRequestBegin());
        jettyRequest.onRequestSuccess(request -> listener.onRequestEnd());
        jettyRequest.onResponseBegin(response -> listener.onResponseBegin());
        jettyRequest.onComplete(result -> listener.onFinish());
        jettyRequest.onComplete(result -> {
            if (result.isFailed() && result.getFailure() instanceof TimeoutException) {
                this.clientDiagnostics.logDiagnosticsInfo(this.httpClient);
            }
        });
        jettyRequest.attribute(STATS_KEY, (Object)listener);
        jettyRequest.method(finalRequest.getMethod());
        for (Map.Entry entry : finalRequest.getHeaders().entries()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        BodyGenerator bodyGenerator = finalRequest.getBodyGenerator();
        if (bodyGenerator != null) {
            if (bodyGenerator instanceof StaticBodyGenerator) {
                StaticBodyGenerator staticBodyGenerator = (StaticBodyGenerator)bodyGenerator;
                jettyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{staticBodyGenerator.getBody()}));
            } else if (bodyGenerator instanceof FileBodyGenerator) {
                Path path = ((FileBodyGenerator)bodyGenerator).getPath();
                jettyRequest.content(JettyHttpClient.fileContentProvider(path));
            } else {
                jettyRequest.content((ContentProvider)new BodyGeneratorContentProvider(bodyGenerator, this.httpClient.getExecutor()));
            }
        }
        jettyRequest.followRedirects(finalRequest.isFollowRedirects());
        AuthorizationPreservingHttpClient.setPreserveAuthorization((org.eclipse.jetty.client.api.Request)jettyRequest, finalRequest.isPreserveAuthorizationOnRedirect());
        jettyRequest.timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        jettyRequest.idleTimeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        return jettyRequest;
    }

    private static ContentProvider fileContentProvider(Path path) {
        try {
            PathContentProvider provider = new PathContentProvider(null, path);
            provider.setByteBufferPool(new ByteBufferPool(){

                public ByteBuffer acquire(int size, boolean direct) {
                    return ByteBuffer.allocate(size);
                }

                public void release(ByteBuffer buffer) {
                }
            });
            return provider;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Override
    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    @Managed
    @Nested
    public QueuedThreadPoolMBean getThreadPool() {
        return this.queuedThreadPoolMBean;
    }

    @Managed
    @Nested
    public ConnectionStats getConnectionStats() {
        return this.connectionStats;
    }

    @Managed
    @Nested
    public CachedDistribution getActiveConnectionsPerDestination() {
        return this.activeConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getIdleConnectionsPerDestination() {
        return this.idleConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getQueuedRequestsPerDestination() {
        return this.queuedRequestsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentQueuedTime() {
        return this.currentQueuedTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestTime() {
        return this.currentRequestTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestSendTime() {
        return this.currentRequestSendTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseWaitTime() {
        return this.currentResponseWaitTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseProcessTime() {
        return this.currentResponseProcessTime;
    }

    @Managed
    public String dump() {
        return this.httpClient.dump();
    }

    @Managed
    public void dumpStdErr() {
        this.httpClient.dumpStdErr();
    }

    @Managed
    public String dumpAllDestinations() {
        return String.format("%s\t%s\t%s\t%s\t%s\n", "URI", "queued", "request", "wait", "response") + this.httpClient.getDestinations().stream().map(JettyHttpClient::dumpDestination).collect(Collectors.joining("\n"));
    }

    @Managed
    public int getLoggerQueueSize() {
        return this.requestLogger.getQueueSize();
    }

    public String dumpDestination(URI uri) {
        Destination destination = this.httpClient.getDestination(uri.getScheme(), uri.getHost(), uri.getPort());
        if (destination == null) {
            return null;
        }
        return JettyHttpClient.dumpDestination(destination);
    }

    private static String dumpDestination(Destination destination) {
        long now = System.nanoTime();
        return JettyHttpClient.getRequestListenersForDestination(destination).stream().map(listener -> JettyHttpClient.dumpRequest(now, listener)).sorted().collect(Collectors.joining("\n"));
    }

    static List<JettyRequestListener> getRequestListenersForDestination(Destination destination) {
        return JettyHttpClient.getRequestForDestination(destination).stream().map(request -> request.getAttributes().get(STATS_KEY)).map(JettyRequestListener.class::cast).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<org.eclipse.jetty.client.api.Request> getRequestForDestination(Destination destination) {
        PoolingHttpDestination poolingHttpDestination = (PoolingHttpDestination)destination;
        Queue httpExchanges = poolingHttpDestination.getHttpExchanges();
        List requests = httpExchanges.stream().map(HttpExchange::getRequest).collect(Collectors.toList());
        ((DuplexConnectionPool)poolingHttpDestination.getConnectionPool()).getActiveConnections().stream().filter(HttpConnectionOverHTTP.class::isInstance).map(HttpConnectionOverHTTP.class::cast).map(connection -> connection.getHttpChannel().getHttpExchange()).filter(Objects::nonNull).forEach(exchange -> requests.add(exchange.getRequest()));
        return (List)requests.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private static String dumpRequest(long now, JettyRequestListener listener) {
        long finished;
        long responseStarted;
        long requestFinished;
        long created = listener.getCreated();
        long requestStarted = listener.getRequestStarted();
        if (requestStarted == 0L) {
            requestStarted = now;
        }
        if ((requestFinished = listener.getRequestFinished()) == 0L) {
            requestFinished = now;
        }
        if ((responseStarted = listener.getResponseStarted()) == 0L) {
            responseStarted = now;
        }
        if ((finished = listener.getResponseFinished()) == 0L) {
            finished = now;
        }
        return String.format("%s\t%.1f\t%.1f\t%.1f\t%.1f", listener.getUri(), JettyHttpClient.nanosToMillis(requestStarted - created), JettyHttpClient.nanosToMillis(requestFinished - requestStarted), JettyHttpClient.nanosToMillis(responseStarted - requestFinished), JettyHttpClient.nanosToMillis(finished - responseStarted));
    }

    private static double nanosToMillis(long nanos) {
        return new Duration((double)nanos, TimeUnit.NANOSECONDS).getValue(TimeUnit.MILLISECONDS);
    }

    @Override
    @PreDestroy
    public void close() {
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient);
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getExecutor());
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getScheduler());
        this.requestLogger.close();
    }

    @Override
    public boolean isClosed() {
        return !this.httpClient.isRunning();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    public StackTraceElement[] getCreationLocation() {
        return this.creationLocation.getStackTrace();
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String uniqueName() {
        return "anonymous" + NAME_COUNTER.incrementAndGet();
    }

    static void recordRequestComplete(RequestStats requestStats, Request request, long requestStart, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
        Duration requestProcessingTime = new Duration((double)(responseStart - requestStart), TimeUnit.NANOSECONDS);
        requestStats.recordResponseReceived(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    static {
        JettyLogging.setup();
        NAME_COUNTER = new AtomicLong();
    }
}

