/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Ints;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FileBodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.jetty.AuthorizationPreservingHttpClient;
import io.airlift.http.client.jetty.BodyGeneratorContentProvider;
import io.airlift.http.client.jetty.BufferingResponseListener;
import io.airlift.http.client.jetty.CachedDistribution;
import io.airlift.http.client.jetty.ConcurrentScheduler;
import io.airlift.http.client.jetty.ConnectionPoolDistribution;
import io.airlift.http.client.jetty.ConnectionStats;
import io.airlift.http.client.jetty.DefaultHttpClientLogger;
import io.airlift.http.client.jetty.DestinationDistribution;
import io.airlift.http.client.jetty.HttpClientLogger;
import io.airlift.http.client.jetty.HttpClientLoggingListener;
import io.airlift.http.client.jetty.JettyAsyncSocketAddressResolver;
import io.airlift.http.client.jetty.JettyClientDiagnostics;
import io.airlift.http.client.jetty.JettyLogging;
import io.airlift.http.client.jetty.JettyRequestListener;
import io.airlift.http.client.jetty.JettyResponse;
import io.airlift.http.client.jetty.JettyResponseFuture;
import io.airlift.http.client.jetty.NoopLogger;
import io.airlift.http.client.jetty.QueuedThreadPoolMBean;
import io.airlift.http.client.jetty.RequestDistribution;
import io.airlift.security.cert.CertificateBuilder;
import io.airlift.security.pem.PemReader;
import io.airlift.units.Duration;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.security.auth.x500.X500Principal;
import org.eclipse.jetty.client.DuplexConnectionPool;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.PoolingHttpDestination;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Destination;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.PathContentProvider;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.Sweeper;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JettyHttpClient
implements HttpClient {
    private static final String STATS_KEY = "airlift_stats";
    private static final long SWEEP_PERIOD_MILLIS = 5000L;
    private static final AtomicLong NAME_COUNTER;
    private final org.eclipse.jetty.client.HttpClient httpClient;
    private final long maxContentLength;
    private final long requestTimeoutMillis;
    private final long idleTimeoutMillis;
    private final boolean recordRequestComplete;
    private final boolean logEnabled;
    private final QueuedThreadPoolMBean queuedThreadPoolMBean;
    private final ConnectionStats connectionStats;
    private final RequestStats stats = new RequestStats();
    private final CachedDistribution queuedRequestsPerDestination;
    private final CachedDistribution activeConnectionsPerDestination;
    private final CachedDistribution idleConnectionsPerDestination;
    private final CachedDistribution currentQueuedTime;
    private final CachedDistribution currentRequestTime;
    private final CachedDistribution currentRequestSendTime;
    private final CachedDistribution currentResponseWaitTime;
    private final CachedDistribution currentResponseProcessTime;
    private final List<HttpRequestFilter> requestFilters;
    private final Exception creationLocation = new Exception();
    private final String name;
    private final HttpClientLogger requestLogger;
    private final JettyClientDiagnostics clientDiagnostics;

    public JettyHttpClient() {
        this(new HttpClientConfig());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(JettyHttpClient.uniqueName(), config);
    }

    public JettyHttpClient(String name, HttpClientConfig config) {
        this(name, config, (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters) {
        this(name, config, requestFilters, Optional.empty(), Optional.empty());
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters, Optional<String> environment, Optional<SslContextFactory.Client> maybeSslContextFactory) {
        HttpClientTransportOverHTTP transport;
        this.name = Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(requestFilters, "requestFilters is null");
        this.maxContentLength = config.getMaxContentLength().toBytes();
        this.requestTimeoutMillis = config.getRequestTimeout().toMillis();
        this.idleTimeoutMillis = config.getIdleTimeout().toMillis();
        this.recordRequestComplete = config.getRecordRequestComplete();
        this.creationLocation.fillInStackTrace();
        SslContextFactory.Client sslContextFactory = maybeSslContextFactory.orElseGet(() -> JettyHttpClient.getSslContextFactory(config, environment));
        if (config.isHttp2Enabled()) {
            HTTP2Client client = new HTTP2Client();
            client.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            client.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            client.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            client.setSelectors(config.getSelectorCount());
            transport = new HttpClientTransportOverHTTP2(client);
        } else {
            transport = new HttpClientTransportOverHTTP(config.getSelectorCount());
        }
        this.httpClient = new AuthorizationPreservingHttpClient((HttpClientTransport)transport, (SslContextFactory)sslContextFactory);
        this.httpClient.setRequestBufferSize(Math.toIntExact(config.getRequestBufferSize().toBytes()));
        this.httpClient.setResponseBufferSize(Math.toIntExact(config.getResponseBufferSize().toBytes()));
        this.httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        this.httpClient.setMaxRequestsQueuedPerDestination(config.getMaxRequestsQueuedPerDestination());
        this.httpClient.setCookieStore((CookieStore)new HttpCookieStore.Empty());
        this.httpClient.setUserAgentField(null);
        this.httpClient.setIdleTimeout(this.idleTimeoutMillis);
        this.httpClient.setConnectTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setAddressResolutionTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setConnectBlocking(config.isConnectBlocking());
        HostAndPort socksProxy = config.getSocksProxy();
        if (socksProxy != null) {
            this.httpClient.getProxyConfiguration().getProxies().add(new Socks4Proxy(socksProxy.getHost(), socksProxy.getPortOrDefault(1080)));
        }
        this.httpClient.setByteBufferPool((ByteBufferPool)new MappedByteBufferPool());
        QueuedThreadPool queuedThreadPool = JettyHttpClient.createExecutor(name, config.getMinThreads(), config.getMaxThreads());
        this.httpClient.setExecutor((Executor)queuedThreadPool);
        this.httpClient.addBean((Object)queuedThreadPool, true);
        this.httpClient.setScheduler(JettyHttpClient.createScheduler(name, config.getTimeoutConcurrency(), config.getTimeoutThreads()));
        this.httpClient.setSocketAddressResolver((SocketAddressResolver)new JettyAsyncSocketAddressResolver(this.httpClient.getExecutor(), this.httpClient.getScheduler(), config.getConnectTimeout().toMillis()));
        this.httpClient.addBean((Object)new Sweeper(this.httpClient.getScheduler(), 5000L), true);
        ConnectionStatistics connectionStats = new ConnectionStatistics();
        this.httpClient.addBean((Object)connectionStats);
        this.connectionStats = new ConnectionStats(connectionStats);
        this.logEnabled = config.isLogEnabled();
        if (this.logEnabled) {
            String logFilePath = Paths.get(config.getLogPath(), String.format("%s-http-client.log", name)).toAbsolutePath().toString();
            this.requestLogger = new DefaultHttpClientLogger(logFilePath, config.getLogHistory(), config.getLogQueueSize(), config.getLogBufferSize(), config.getLogFlushInterval(), config.getLogMaxFileSize().toBytes(), config.isLogCompressionEnabled());
        } else {
            this.requestLogger = new NoopLogger();
        }
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.clientDiagnostics = new JettyClientDiagnostics();
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        this.queuedThreadPoolMBean = new QueuedThreadPoolMBean((QueuedThreadPool)this.httpClient.getExecutor());
        this.activeConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getActiveConnections().size()));
        this.idleConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getIdleConnections().size()));
        this.queuedRequestsPerDestination = new DestinationDistribution(this.httpClient, (distribution, destination) -> distribution.add((long)destination.getHttpExchanges().size()));
        this.currentQueuedTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                started = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(started - listener.getCreated()));
        });
        this.currentRequestTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - started));
        });
        this.currentRequestSendTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                requestSent = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(requestSent - started));
        });
        this.currentResponseWaitTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                return;
            }
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                responseStarted = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(responseStarted - requestSent));
        });
        this.currentResponseProcessTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - responseStarted));
        });
    }

    private static SslContextFactory.Client getSslContextFactory(HttpClientConfig config, Optional<String> environment) {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setSNIProvider(SslContextFactory.Client.SniProvider.NON_DOMAIN_SNI_PROVIDER);
        sslContextFactory.setEndpointIdentificationAlgorithm(config.isVerifyHostname() ? "HTTPS" : null);
        String keyStorePassword = (String)MoreObjects.firstNonNull((Object)config.getKeyStorePassword(), (Object)"");
        KeyStore keyStore = null;
        if (config.getKeyStorePath() != null) {
            keyStore = JettyHttpClient.loadKeyStore(config.getKeyStorePath(), config.getKeyStorePassword());
            sslContextFactory.setKeyStore(keyStore);
            sslContextFactory.setKeyStorePassword(keyStorePassword);
        }
        if (config.getTrustStorePath() != null || config.getAutomaticHttpsSharedSecret() != null) {
            KeyStore trustStore = JettyHttpClient.loadTrustStore(config.getTrustStorePath(), config.getTrustStorePassword());
            if (config.getAutomaticHttpsSharedSecret() != null) {
                JettyHttpClient.addAutomaticTrust(config.getAutomaticHttpsSharedSecret(), trustStore, environment.orElseThrow(() -> new IllegalArgumentException("Environment must be provided when automatic HTTPS is enabled")));
            }
            sslContextFactory.setTrustStore(trustStore);
            sslContextFactory.setTrustStorePassword("");
        } else if (keyStore != null) {
            sslContextFactory.setTrustStore(keyStore);
            sslContextFactory.setTrustStorePassword(keyStorePassword);
        }
        sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
        List<String> includedCipherSuites = config.getHttpsIncludedCipherSuites();
        List<String> excludedCipherSuites = config.getHttpsExcludedCipherSuites();
        sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
        sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
        return sslContextFactory;
    }

    private static KeyStore loadKeyStore(String keystorePath, String keystorePassword) {
        KeyStore keyStore;
        Objects.requireNonNull(keystorePath, "keystorePath is null");
        try {
            File keyStoreFile = new File(keystorePath);
            if (PemReader.isPem((File)keyStoreFile)) {
                return PemReader.loadKeyStore((File)keyStoreFile, (File)keyStoreFile, Optional.ofNullable(keystorePassword), (boolean)true);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM key store: " + keystorePath, e);
        }
        FileInputStream in = new FileInputStream(keystorePath);
        try {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(in, keystorePassword.toCharArray());
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Error loading Java key store: " + keystorePath, e);
            }
        }
        ((InputStream)in).close();
        return keyStore;
    }

    private static KeyStore loadTrustStore(String truststorePath, String truststorePassword) {
        KeyStore keyStore;
        if (truststorePath == null) {
            try {
                KeyStore keyStore2 = KeyStore.getInstance("JKS");
                keyStore2.load(null, new char[0]);
                return keyStore2;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            File keyStoreFile = new File(truststorePath);
            if (PemReader.isPem((File)keyStoreFile)) {
                return PemReader.loadTrustStore((File)keyStoreFile);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM trust store: " + truststorePath, e);
        }
        FileInputStream in = new FileInputStream(truststorePath);
        try {
            KeyStore keyStore3 = KeyStore.getInstance("JKS");
            keyStore3.load(in, truststorePassword == null ? null : truststorePassword.toCharArray());
            keyStore = keyStore3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Error loading Java trust store: " + truststorePath, e);
            }
        }
        ((InputStream)in).close();
        return keyStore;
    }

    private static void addAutomaticTrust(String sharedSecret, KeyStore keyStore, String commonName) {
        try {
            byte[] seed = sharedSecret.getBytes(StandardCharsets.UTF_8);
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(seed);
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048, secureRandom);
            KeyPair keyPair = generator.generateKeyPair();
            X500Principal subject = new X500Principal("CN=" + commonName);
            LocalDate notBefore = LocalDate.now();
            LocalDate notAfter = notBefore.plus(10L, ChronoUnit.YEARS);
            X509Certificate certificateServer = CertificateBuilder.certificateBuilder().setKeyPair(keyPair).setSerialNumber(System.currentTimeMillis()).setIssuer(subject).setNotBefore(notBefore).setNotAfter(notAfter).setSubject(subject).buildSelfSigned();
            keyStore.setCertificateEntry(commonName, certificateServer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static QueuedThreadPool createExecutor(String name, int minThreads, int maxThreads) {
        try {
            QueuedThreadPool pool = new QueuedThreadPool(maxThreads, minThreads, 60000, null);
            pool.setName("http-client-" + name);
            pool.setDaemon(true);
            pool.start();
            pool.setStopTimeout(2000L);
            pool.setDetailedDump(true);
            return pool;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Scheduler createScheduler(String name, int timeoutConcurrency, int timeoutThreads) {
        Object scheduler;
        String threadName = "http-client-" + name + "-scheduler";
        if (timeoutConcurrency == 1 && timeoutThreads == 1) {
            scheduler = new ScheduledExecutorScheduler(threadName, true);
        } else {
            Preconditions.checkArgument((timeoutConcurrency >= 1 ? 1 : 0) != 0, (Object)"timeoutConcurrency must be at least one");
            int threads = Math.max(1, timeoutThreads / timeoutConcurrency);
            scheduler = new ConcurrentScheduler(timeoutConcurrency, threads, threadName);
        }
        try {
            scheduler.start();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        T value;
        Response response;
        long requestStart = System.nanoTime();
        request = this.applyRequestFilters(request);
        JettyRequestListener requestListener = new JettyRequestListener(request.getUri());
        HttpRequest jettyRequest = this.buildJettyRequest(request, requestListener);
        InputStreamResponseListener listener = new InputStreamResponseListener(){

            public void onContent(Response response, ByteBuffer content) {
                if (content.remaining() == 0) {
                    return;
                }
                super.onContent(response, content);
            }
        };
        long requestTimestamp = System.currentTimeMillis();
        HttpClientLogger.RequestInfo requestInfo = HttpClientLogger.RequestInfo.from((org.eclipse.jetty.client.api.Request)jettyRequest, requestTimestamp);
        if (this.logEnabled) {
            this.addLoggingListener(jettyRequest, requestTimestamp);
        }
        jettyRequest.send((Response.CompleteListener)listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(requestInfo, HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            jettyRequest.abort((Throwable)e);
            Thread.currentThread().interrupt();
            return responseHandler.handleException(request, e);
        }
        catch (TimeoutException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(requestInfo, HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            jettyRequest.abort((Throwable)e);
            return responseHandler.handleException(request, e);
        }
        catch (ExecutionException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(requestInfo, HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return responseHandler.handleException(request, (Exception)cause);
            }
            if (cause instanceof NoClassDefFoundError && cause.getMessage().endsWith("ALPNClientConnection")) {
                return responseHandler.handleException(request, new RuntimeException("HTTPS cannot be used when HTTP/2 is enabled", cause));
            }
            return responseHandler.handleException(request, new RuntimeException(cause));
        }
        long responseStart = System.nanoTime();
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, listener.getInputStream());
            value = responseHandler.handle(request, jettyResponse);
        }
        finally {
            if (jettyResponse != null) {
                try {
                    jettyResponse.getInputStream().close();
                }
                catch (IOException iOException) {}
            }
            if (this.recordRequestComplete) {
                JettyHttpClient.recordRequestComplete(this.stats, request, requestStart, jettyResponse, responseStart);
            }
        }
        return value;
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(responseHandler, "responseHandler is null");
        request = this.applyRequestFilters(request);
        HttpRequest jettyRequest = this.buildJettyRequest(request, new JettyRequestListener(request.getUri()));
        JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(request, (org.eclipse.jetty.client.api.Request)jettyRequest, responseHandler, this.stats, this.recordRequestComplete);
        BufferingResponseListener listener = new BufferingResponseListener(future, Ints.saturatedCast((long)this.maxContentLength));
        long requestTimestamp = System.currentTimeMillis();
        if (this.logEnabled) {
            this.addLoggingListener(jettyRequest, requestTimestamp);
        }
        try {
            jettyRequest.send((Response.CompleteListener)listener);
        }
        catch (RuntimeException e2) {
            RejectedExecutionException e2;
            if (!(e2 instanceof RejectedExecutionException)) {
                e2 = new RejectedExecutionException(e2);
            }
            future.failed(e2);
            this.requestLogger.log(HttpClientLogger.RequestInfo.from((org.eclipse.jetty.client.api.Request)jettyRequest, requestTimestamp), HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e2)));
        }
        return future;
    }

    private void addLoggingListener(HttpRequest jettyRequest, long requestTimestamp) {
        HttpClientLoggingListener loggingListener = new HttpClientLoggingListener(jettyRequest, requestTimestamp, this.requestLogger);
        jettyRequest.listener((Request.Listener)loggingListener);
        jettyRequest.onResponseBegin((Response.BeginListener)loggingListener);
        jettyRequest.onComplete((Response.CompleteListener)loggingListener);
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private HttpRequest buildJettyRequest(Request finalRequest, JettyRequestListener listener) {
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        jettyRequest.onRequestBegin(request -> listener.onRequestBegin());
        jettyRequest.onRequestSuccess(request -> listener.onRequestEnd());
        jettyRequest.onResponseBegin(response -> listener.onResponseBegin());
        jettyRequest.onComplete(result -> listener.onFinish());
        jettyRequest.onComplete(result -> {
            if (result.isFailed() && result.getFailure() instanceof TimeoutException) {
                this.clientDiagnostics.logDiagnosticsInfo(this.httpClient);
            }
        });
        jettyRequest.attribute(STATS_KEY, (Object)listener);
        jettyRequest.method(finalRequest.getMethod());
        for (Map.Entry entry : finalRequest.getHeaders().entries()) {
            jettyRequest.header((String)entry.getKey(), (String)entry.getValue());
        }
        BodyGenerator bodyGenerator = finalRequest.getBodyGenerator();
        if (bodyGenerator != null) {
            if (bodyGenerator instanceof StaticBodyGenerator) {
                StaticBodyGenerator staticBodyGenerator = (StaticBodyGenerator)bodyGenerator;
                jettyRequest.content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{staticBodyGenerator.getBody()}));
            } else if (bodyGenerator instanceof FileBodyGenerator) {
                Path path = ((FileBodyGenerator)bodyGenerator).getPath();
                jettyRequest.content(JettyHttpClient.fileContentProvider(path));
            } else {
                jettyRequest.content((ContentProvider)new BodyGeneratorContentProvider(bodyGenerator, this.httpClient.getExecutor()));
            }
        }
        jettyRequest.followRedirects(finalRequest.isFollowRedirects());
        AuthorizationPreservingHttpClient.setPreserveAuthorization((org.eclipse.jetty.client.api.Request)jettyRequest, finalRequest.isPreserveAuthorizationOnRedirect());
        jettyRequest.timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        jettyRequest.idleTimeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        return jettyRequest;
    }

    private static ContentProvider fileContentProvider(Path path) {
        try {
            PathContentProvider provider = new PathContentProvider(null, path);
            provider.setByteBufferPool(new ByteBufferPool(){

                public ByteBuffer acquire(int size, boolean direct) {
                    return ByteBuffer.allocate(size);
                }

                public void release(ByteBuffer buffer) {
                }
            });
            return provider;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Override
    public long getMaxContentLength() {
        return this.maxContentLength;
    }

    @Managed
    @Nested
    public QueuedThreadPoolMBean getThreadPool() {
        return this.queuedThreadPoolMBean;
    }

    @Managed
    @Nested
    public ConnectionStats getConnectionStats() {
        return this.connectionStats;
    }

    @Managed
    @Nested
    public CachedDistribution getActiveConnectionsPerDestination() {
        return this.activeConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getIdleConnectionsPerDestination() {
        return this.idleConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getQueuedRequestsPerDestination() {
        return this.queuedRequestsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentQueuedTime() {
        return this.currentQueuedTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestTime() {
        return this.currentRequestTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestSendTime() {
        return this.currentRequestSendTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseWaitTime() {
        return this.currentResponseWaitTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseProcessTime() {
        return this.currentResponseProcessTime;
    }

    @Managed
    public String dump() {
        return this.httpClient.dump();
    }

    @Managed
    public void dumpStdErr() {
        this.httpClient.dumpStdErr();
    }

    @Managed
    public String dumpAllDestinations() {
        return String.format("%s\t%s\t%s\t%s\t%s\n", "URI", "queued", "request", "wait", "response") + this.httpClient.getDestinations().stream().map(JettyHttpClient::dumpDestination).collect(Collectors.joining("\n"));
    }

    @Managed
    public int getLoggerQueueSize() {
        return this.requestLogger.getQueueSize();
    }

    public String dumpDestination(URI uri) {
        Destination destination = this.httpClient.getDestination(uri.getScheme(), uri.getHost(), uri.getPort());
        if (destination == null) {
            return null;
        }
        return JettyHttpClient.dumpDestination(destination);
    }

    private static String dumpDestination(Destination destination) {
        long now = System.nanoTime();
        return JettyHttpClient.getRequestListenersForDestination(destination).stream().map(listener -> JettyHttpClient.dumpRequest(now, listener)).sorted().collect(Collectors.joining("\n"));
    }

    static List<JettyRequestListener> getRequestListenersForDestination(Destination destination) {
        return JettyHttpClient.getRequestForDestination(destination).stream().map(request -> request.getAttributes().get(STATS_KEY)).map(JettyRequestListener.class::cast).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<org.eclipse.jetty.client.api.Request> getRequestForDestination(Destination destination) {
        PoolingHttpDestination poolingHttpDestination = (PoolingHttpDestination)destination;
        Queue httpExchanges = poolingHttpDestination.getHttpExchanges();
        List requests = httpExchanges.stream().map(HttpExchange::getRequest).collect(Collectors.toList());
        ((DuplexConnectionPool)poolingHttpDestination.getConnectionPool()).getActiveConnections().stream().filter(HttpConnectionOverHTTP.class::isInstance).map(HttpConnectionOverHTTP.class::cast).map(connection -> connection.getHttpChannel().getHttpExchange()).filter(Objects::nonNull).forEach(exchange -> requests.add(exchange.getRequest()));
        return (List)requests.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private static String dumpRequest(long now, JettyRequestListener listener) {
        long finished;
        long responseStarted;
        long requestFinished;
        long created = listener.getCreated();
        long requestStarted = listener.getRequestStarted();
        if (requestStarted == 0L) {
            requestStarted = now;
        }
        if ((requestFinished = listener.getRequestFinished()) == 0L) {
            requestFinished = now;
        }
        if ((responseStarted = listener.getResponseStarted()) == 0L) {
            responseStarted = now;
        }
        if ((finished = listener.getResponseFinished()) == 0L) {
            finished = now;
        }
        return String.format("%s\t%.1f\t%.1f\t%.1f\t%.1f", listener.getUri(), JettyHttpClient.nanosToMillis(requestStarted - created), JettyHttpClient.nanosToMillis(requestFinished - requestStarted), JettyHttpClient.nanosToMillis(responseStarted - requestFinished), JettyHttpClient.nanosToMillis(finished - responseStarted));
    }

    private static double nanosToMillis(long nanos) {
        return new Duration((double)nanos, TimeUnit.NANOSECONDS).getValue(TimeUnit.MILLISECONDS);
    }

    @Override
    @PreDestroy
    public void close() {
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient);
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getExecutor());
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getScheduler());
        this.requestLogger.close();
    }

    @Override
    public boolean isClosed() {
        return !this.httpClient.isRunning();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    public StackTraceElement[] getCreationLocation() {
        return this.creationLocation.getStackTrace();
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String uniqueName() {
        return "anonymous" + NAME_COUNTER.incrementAndGet();
    }

    static void recordRequestComplete(RequestStats requestStats, Request request, long requestStart, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
        Duration requestProcessingTime = new Duration((double)(responseStart - requestStart), TimeUnit.NANOSECONDS);
        requestStats.recordResponseReceived(request.getMethod(), response.getStatusCode(), response.getBytesRead(), response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    static {
        JettyLogging.setup();
        NAME_COUNTER = new AtomicLong();
    }
}

