/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.http.client.BodyGenerator;
import io.opentelemetry.api.trace.SpanBuilder;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Request {
    private final URI uri;
    private final String method;
    private final ListMultimap<String, String> headers;
    private final BodyGenerator bodyGenerator;
    private final Optional<SpanBuilder> spanBuilder;
    private final boolean followRedirects;
    private final boolean preserveAuthorizationOnRedirect;

    @Deprecated
    public Request(URI uri, String method, ListMultimap<String, String> headers, BodyGenerator bodyGenerator) {
        this(uri, method, headers, bodyGenerator, Optional.empty(), true, false);
    }

    private Request(URI uri, String method, ListMultimap<String, String> headers, BodyGenerator bodyGenerator, Optional<SpanBuilder> spanBuilder, boolean followRedirects, boolean preserveAuthorizationOnRedirect) {
        Objects.requireNonNull(uri, "uri is null");
        Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"uri does not have a host: %s", (Object)uri);
        Preconditions.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (String)"uri does not have a scheme: %s", (Object)uri);
        String scheme = uri.getScheme().toLowerCase();
        Preconditions.checkArgument(("http".equals(scheme) || "https".equals(scheme) ? 1 : 0) != 0, (String)"uri scheme must be http or https: %s", (Object)uri);
        Objects.requireNonNull(method, "method is null");
        this.uri = Request.validateUri(uri);
        this.method = method;
        this.headers = ImmutableListMultimap.copyOf(headers);
        this.bodyGenerator = bodyGenerator;
        this.spanBuilder = Objects.requireNonNull(spanBuilder, "spanBuilder is null");
        this.followRedirects = followRedirects;
        this.preserveAuthorizationOnRedirect = preserveAuthorizationOnRedirect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeader(String name) {
        List values = this.headers.get((Object)name);
        if (values != null && !values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    public BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    public Optional<SpanBuilder> getSpanBuilder() {
        return this.spanBuilder;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isPreserveAuthorizationOnRedirect() {
        return this.preserveAuthorizationOnRedirect;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uri", (Object)this.uri).add("method", (Object)this.method).add("headers", this.headers).add("bodyGenerator", (Object)this.bodyGenerator).add("spanBuilder", (Object)(this.spanBuilder.isPresent() ? "present" : "empty")).add("followRedirects", this.followRedirects).add("preserveAuthorizationOnRedirect", this.preserveAuthorizationOnRedirect).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request r = (Request)o;
        return Objects.equals(this.uri, r.uri) && Objects.equals(this.method, r.method) && Objects.equals(this.headers, r.headers) && Objects.equals(this.bodyGenerator, r.bodyGenerator) && Objects.equals(this.spanBuilder, r.spanBuilder) && Objects.equals(this.followRedirects, r.followRedirects) && Objects.equals(this.preserveAuthorizationOnRedirect, r.preserveAuthorizationOnRedirect);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.method, this.headers, this.bodyGenerator, this.spanBuilder, this.followRedirects, this.preserveAuthorizationOnRedirect);
    }

    private static URI validateUri(URI uri) {
        Preconditions.checkArgument((uri.getPort() != 0 ? 1 : 0) != 0, (Object)"Cannot make requests to HTTP port 0");
        return uri;
    }

    public static final class Builder {
        private URI uri;
        private String method;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private BodyGenerator bodyGenerator;
        private SpanBuilder spanBuilder;
        private boolean followRedirects = true;
        private boolean preserveAuthorizationOnRedirect;

        public static Builder prepareHead() {
            return new Builder().setMethod("HEAD");
        }

        public static Builder prepareGet() {
            return new Builder().setMethod("GET");
        }

        public static Builder preparePost() {
            return new Builder().setMethod("POST");
        }

        public static Builder preparePut() {
            return new Builder().setMethod("PUT");
        }

        public static Builder prepareDelete() {
            return new Builder().setMethod("DELETE");
        }

        public static Builder preparePatch() {
            return new Builder().setMethod("PATCH");
        }

        public static Builder fromRequest(Request request) {
            return new Builder().setUri(request.getUri()).setMethod(request.getMethod()).addHeaders((Multimap<String, String>)request.getHeaders()).setBodyGenerator(request.getBodyGenerator()).setSpanBuilder(request.getSpanBuilder().orElse(null)).setFollowRedirects(request.isFollowRedirects()).setPreserveAuthorizationOnRedirect(request.isPreserveAuthorizationOnRedirect());
        }

        public Builder setUri(URI uri) {
            this.uri = Request.validateUri(uri);
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headers.removeAll((Object)name);
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeaders(Multimap<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder setBodyGenerator(BodyGenerator bodyGenerator) {
            this.bodyGenerator = bodyGenerator;
            return this;
        }

        public Builder setSpanBuilder(SpanBuilder spanBuilder) {
            this.spanBuilder = spanBuilder;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setPreserveAuthorizationOnRedirect(boolean preserveAuthorizationOnRedirect) {
            this.preserveAuthorizationOnRedirect = preserveAuthorizationOnRedirect;
            return this;
        }

        public Request build() {
            return new Request(this.uri, this.method, this.headers, this.bodyGenerator, Optional.ofNullable(this.spanBuilder), this.followRedirects, this.preserveAuthorizationOnRedirect);
        }
    }
}

