/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.HttpVersion;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.trace.SpanBuilder;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class Request {
    private final Optional<HttpVersion> httpVersion;
    private final URI uri;
    private final String method;
    private final ListMultimap<String, String> headers;
    private final Optional<Duration> requestTimeout;
    private final Optional<Duration> idleTimeout;
    private final BodyGenerator bodyGenerator;
    private final Optional<DataSize> maxContentLength;
    private final Optional<SpanBuilder> spanBuilder;
    private final boolean followRedirects;
    private final boolean preserveAuthorizationOnRedirect;

    private Request(Optional<HttpVersion> httpVersion, URI uri, String method, ListMultimap<String, String> headers, Optional<Duration> requestTimeout, Optional<Duration> idleTimeout, BodyGenerator bodyGenerator, Optional<DataSize> maxContentLength, Optional<SpanBuilder> spanBuilder, boolean followRedirects, boolean preserveAuthorizationOnRedirect) {
        Objects.requireNonNull(uri, "uri is null");
        Preconditions.checkArgument((uri.getHost() != null ? 1 : 0) != 0, (String)"uri does not have a host: %s", (Object)uri);
        Preconditions.checkArgument((uri.getScheme() != null ? 1 : 0) != 0, (String)"uri does not have a scheme: %s", (Object)uri);
        String scheme = uri.getScheme().toLowerCase();
        Preconditions.checkArgument(("http".equals(scheme) || "https".equals(scheme) ? 1 : 0) != 0, (String)"uri scheme must be http or https: %s", (Object)uri);
        Objects.requireNonNull(method, "method is null");
        this.httpVersion = Objects.requireNonNull(httpVersion, "httpVersion is null");
        this.uri = Request.validateUri(uri);
        this.method = method;
        this.headers = ImmutableListMultimap.copyOf(headers);
        this.requestTimeout = Objects.requireNonNull(requestTimeout, "requestTimeout is null");
        this.idleTimeout = Objects.requireNonNull(idleTimeout, "idleTimeout is null");
        this.bodyGenerator = bodyGenerator;
        this.maxContentLength = Objects.requireNonNull(maxContentLength, "maxContentLength is null");
        this.spanBuilder = Objects.requireNonNull(spanBuilder, "spanBuilder is null");
        this.followRedirects = followRedirects;
        this.preserveAuthorizationOnRedirect = preserveAuthorizationOnRedirect;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<HttpVersion> getHttpVersion() {
        return this.httpVersion;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getMethod() {
        return this.method;
    }

    public String getHeader(String name) {
        List values = this.headers.get((Object)name);
        if (values != null && !values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    public ListMultimap<String, String> getHeaders() {
        return this.headers;
    }

    public Optional<Duration> getRequestTimeout() {
        return this.requestTimeout;
    }

    public Optional<Duration> getIdleTimeout() {
        return this.idleTimeout;
    }

    public Optional<DataSize> getMaxContentLength() {
        return this.maxContentLength;
    }

    public BodyGenerator getBodyGenerator() {
        return this.bodyGenerator;
    }

    public Optional<SpanBuilder> getSpanBuilder() {
        return this.spanBuilder;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public boolean isPreserveAuthorizationOnRedirect() {
        return this.preserveAuthorizationOnRedirect;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", (Object)this.httpVersion.map(Enum::name).orElse("unspecified")).add("uri", (Object)this.uri).add("method", (Object)this.method).add("headers", this.headers).add("timeout", this.requestTimeout.orElse(null)).add("idleTimeout", this.idleTimeout.orElse(null)).add("maxContentLength", this.maxContentLength).add("bodyGenerator", (Object)this.bodyGenerator).add("spanBuilder", (Object)(this.spanBuilder.isPresent() ? "present" : "empty")).add("followRedirects", this.followRedirects).add("preserveAuthorizationOnRedirect", this.preserveAuthorizationOnRedirect).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof Request)) {
            return false;
        }
        Request r = (Request)o;
        return Objects.equals(this.httpVersion, r.httpVersion) && Objects.equals(this.uri, r.uri) && Objects.equals(this.method, r.method) && Objects.equals(this.headers, r.headers) && Objects.equals(this.requestTimeout, r.requestTimeout) && Objects.equals(this.idleTimeout, r.idleTimeout) && Objects.equals(this.maxContentLength, r.maxContentLength) && Objects.equals(this.bodyGenerator, r.bodyGenerator) && Objects.equals(this.spanBuilder, r.spanBuilder) && Objects.equals(this.followRedirects, r.followRedirects) && Objects.equals(this.preserveAuthorizationOnRedirect, r.preserveAuthorizationOnRedirect);
    }

    public int hashCode() {
        return Objects.hash(this.httpVersion, this.uri, this.method, this.headers, this.requestTimeout, this.idleTimeout, this.maxContentLength, this.bodyGenerator, this.spanBuilder, this.followRedirects, this.preserveAuthorizationOnRedirect);
    }

    private static URI validateUri(URI uri) {
        Preconditions.checkArgument((uri.getPort() != 0 ? 1 : 0) != 0, (Object)"Cannot make requests to HTTP port 0");
        return uri;
    }

    public static final class Builder {
        private URI uri;
        private String method;
        private final ListMultimap<String, String> headers = ArrayListMultimap.create();
        private BodyGenerator bodyGenerator;
        private SpanBuilder spanBuilder;
        private Optional<HttpVersion> version = Optional.empty();
        private boolean followRedirects = true;
        private boolean preserveAuthorizationOnRedirect;
        private Optional<Duration> requestTimeout = Optional.empty();
        private Optional<Duration> idleTimeout = Optional.empty();
        private Optional<DataSize> maxContentLength = Optional.empty();

        public static Builder prepareHead() {
            return new Builder().setMethod("HEAD");
        }

        public static Builder prepareGet() {
            return new Builder().setMethod("GET");
        }

        public static Builder preparePost() {
            return new Builder().setMethod("POST");
        }

        public static Builder preparePut() {
            return new Builder().setMethod("PUT");
        }

        public static Builder prepareDelete() {
            return new Builder().setMethod("DELETE");
        }

        public static Builder preparePatch() {
            return new Builder().setMethod("PATCH");
        }

        public static Builder fromRequest(Request request) {
            Builder builder = new Builder().setUri(request.getUri()).setMethod(request.getMethod()).addHeaders((Multimap<String, String>)request.getHeaders()).setBodyGenerator(request.getBodyGenerator()).setSpanBuilder(request.getSpanBuilder().orElse(null)).setFollowRedirects(request.isFollowRedirects()).setVersion(request.getHttpVersion().orElse(null)).setPreserveAuthorizationOnRedirect(request.isPreserveAuthorizationOnRedirect());
            request.getRequestTimeout().ifPresent(builder::setRequestTimeout);
            request.getIdleTimeout().ifPresent(builder::setIdleTimeout);
            request.getMaxContentLength().ifPresent(builder::setMaxContentLength);
            return builder;
        }

        public Builder setUri(URI uri) {
            this.uri = Request.validateUri(uri);
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setHeader(String name, String value) {
            this.headers.removeAll((Object)name);
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put((Object)name, (Object)value);
            return this;
        }

        public Builder addHeaders(Multimap<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder setBodyGenerator(BodyGenerator bodyGenerator) {
            this.bodyGenerator = bodyGenerator;
            return this;
        }

        public Builder setSpanBuilder(SpanBuilder spanBuilder) {
            this.spanBuilder = spanBuilder;
            return this;
        }

        public Builder setFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder setVersion(HttpVersion version) {
            this.version = Optional.ofNullable(version);
            return this;
        }

        public Builder setRequestTimeout(Duration timeout) {
            this.requestTimeout = Optional.ofNullable(timeout);
            return this;
        }

        public Builder setIdleTimeout(Duration timeout) {
            this.idleTimeout = Optional.ofNullable(timeout);
            return this;
        }

        public Builder setMaxContentLength(DataSize maxContentLength) {
            this.maxContentLength = Optional.ofNullable(maxContentLength);
            return this;
        }

        public Builder setPreserveAuthorizationOnRedirect(boolean preserveAuthorizationOnRedirect) {
            this.preserveAuthorizationOnRedirect = preserveAuthorizationOnRedirect;
            return this;
        }

        public Request build() {
            return new Request(this.version, this.uri, this.method, this.headers, this.requestTimeout, this.idleTimeout, this.bodyGenerator, this.maxContentLength, Optional.ofNullable(this.spanBuilder), this.followRedirects, this.preserveAuthorizationOnRedirect);
        }
    }
}

