/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import jakarta.annotation.PostConstruct;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"http-client.authentication.enabled", "http-client.authentication.krb5.name-type", "http-client.authentication.krb5.principal", "http-client.authentication.krb5.remote-service-name", "http-client.authentication.krb5.service-principal-pattern", "http-client.keep-alive-interval", "http-client.max-connections", "http.authentication.krb5.config", "http.authentication.krb5.credential-cache", "http.authentication.krb5.keytab", "http.authentication.krb5.use-canonical-hostname", "http-client.buffer-pool-type"})
public class HttpClientConfig {
    public static final String JAVAX_NET_SSL_KEY_STORE = "javax.net.ssl.keyStore";
    public static final String JAVAX_NET_SSL_KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String JAVAX_NET_SSL_TRUST_STORE = "javax.net.ssl.trustStore";
    public static final String JAVAX_NET_SSL_TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    private Duration connectTimeout = new Duration(5.0, TimeUnit.SECONDS);
    private Duration requestTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private Duration idleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration destinationIdleTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private int maxConnectionsPerServer = 20;
    private int maxRequestsQueuedPerDestination = 1024;
    private DataSize maxContentLength = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize requestBufferSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize responseBufferSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize maxRequestHeaderSize = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private DataSize maxResponseHeaderSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private Optional<DataSize> maxHeapMemory = Optional.empty();
    private Optional<DataSize> maxDirectMemory = Optional.empty();
    private HostAndPort socksProxy;
    private HostAndPort httpProxy;
    private boolean secureProxy;
    private String keyStorePath = System.getProperty("javax.net.ssl.keyStore");
    private String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
    private String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
    private String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
    private String secureRandomAlgorithm;
    private List<String> includedCipherSuites = ImmutableList.of();
    private String automaticHttpsSharedSecret;
    private Optional<Duration> tcpKeepAliveIdleTime = Optional.empty();
    private boolean strictEventOrdering;
    private boolean useVirtualThreads;
    private List<String> excludedCipherSuites = ImmutableList.of((Object)"^.*_(MD5|SHA|SHA1)$", (Object)"^TLS_RSA_.*$", (Object)"^SSL_.*$", (Object)"^.*_NULL_.*$", (Object)"^.*_anon_.*$");
    private int selectorCount = 2;
    private boolean recordRequestComplete = true;
    private boolean connectBlocking;
    private int maxThreads = 200;
    private int minThreads = 8;
    private int timeoutThreads = 1;
    private int timeoutConcurrency = 1;
    private boolean http2Enabled;
    private DataSize http2InitialSessionReceiveWindowSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize http2InitialStreamReceiveWindowSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize http2InputBufferSize = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private String logPath = "var/log/";
    private boolean logEnabled;
    private int logHistory = 15;
    private int logQueueSize = 10000;
    private DataSize logMaxFileSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize logBufferSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private Duration logFlushInterval = new Duration(10.0, TimeUnit.SECONDS);
    private boolean logCompressionEnabled = true;
    private boolean verifyHostname = true;
    private Optional<String> httpProxyUser = Optional.empty();
    private Optional<String> httpProxyPassword = Optional.empty();
    private boolean trackMemoryAllocations;

    public boolean isVerifyHostname() {
        return this.verifyHostname;
    }

    @Config(value="http-client.https.hostname-verification")
    @ConfigDescription(value="Verify that server hostname matches the server certificate")
    public HttpClientConfig setVerifyHostname(boolean verifyHostname) {
        this.verifyHostname = verifyHostname;
        return this;
    }

    public boolean isHttp2Enabled() {
        return this.http2Enabled;
    }

    @Config(value="http-client.http2.enabled")
    @ConfigDescription(value="Enable the HTTP/2 transport")
    public HttpClientConfig setHttp2Enabled(boolean http2Enabled) {
        this.http2Enabled = http2Enabled;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="http-client.connect-timeout")
    public HttpClientConfig setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="http-client.request-timeout")
    public HttpClientConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NotNull
    @MinDuration(value="0ms")
    public @NotNull @MinDuration(value="0ms") Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Config(value="http-client.idle-timeout")
    @LegacyConfig(value={"http-client.read-timeout"})
    public HttpClientConfig setIdleTimeout(Duration idleTimeout) {
        this.idleTimeout = idleTimeout;
        return this;
    }

    @MinDuration(value="0ms")
    public @MinDuration(value="0ms") Duration getDestinationIdleTimeout() {
        return this.destinationIdleTimeout;
    }

    @Config(value="http-client.destination-idle-timeout")
    public HttpClientConfig setDestinationIdleTimeout(Duration destinationIdleTimeout) {
        this.destinationIdleTimeout = destinationIdleTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxConnectionsPerServer() {
        return this.maxConnectionsPerServer;
    }

    @Config(value="http-client.max-connections-per-server")
    public HttpClientConfig setMaxConnectionsPerServer(int maxConnectionsPerServer) {
        this.maxConnectionsPerServer = maxConnectionsPerServer;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    @Config(value="http-client.max-requests-queued-per-destination")
    public HttpClientConfig setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
        return this;
    }

    @NotNull
    public DataSize getMaxContentLength() {
        return this.maxContentLength;
    }

    @Config(value="http-client.max-content-length")
    public HttpClientConfig setMaxContentLength(DataSize maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public @NotNull @MaxDataSize(value="32MB") DataSize getRequestBufferSize() {
        return this.requestBufferSize;
    }

    @Config(value="http-client.request-buffer-size")
    public HttpClientConfig setRequestBufferSize(DataSize requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public @NotNull @MaxDataSize(value="32MB") DataSize getResponseBufferSize() {
        return this.responseBufferSize;
    }

    @Config(value="http-client.response-buffer-size")
    public HttpClientConfig setResponseBufferSize(DataSize responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public @NotNull @MaxDataSize(value="32MB") DataSize getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @Config(value="http-client.max-request-header-size")
    public HttpClientConfig setMaxRequestHeaderSize(DataSize maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        return this;
    }

    @NotNull
    @MaxDataSize(value="32MB")
    public @NotNull @MaxDataSize(value="32MB") DataSize getMaxResponseHeaderSize() {
        return this.maxResponseHeaderSize;
    }

    @Config(value="http-client.max-response-header-size")
    public HttpClientConfig setMaxResponseHeaderSize(DataSize maxResponseHeaderSize) {
        this.maxResponseHeaderSize = maxResponseHeaderSize;
        return this;
    }

    public Optional<@MinDataSize(value="8MB") DataSize> getMaxHeapMemory() {
        return this.maxHeapMemory;
    }

    @Config(value="http-client.max-heap-memory")
    public HttpClientConfig setMaxHeapMemory(DataSize maxHeapMemory) {
        this.maxHeapMemory = Optional.ofNullable(maxHeapMemory);
        return this;
    }

    public Optional<@MinDataSize(value="8MB") DataSize> getMaxDirectMemory() {
        return this.maxDirectMemory;
    }

    @Config(value="http-client.max-direct-memory")
    public HttpClientConfig setMaxDirectMemory(DataSize maxDirectMemory) {
        this.maxDirectMemory = Optional.ofNullable(maxDirectMemory);
        return this;
    }

    public HostAndPort getSocksProxy() {
        return this.socksProxy;
    }

    @Config(value="http-client.socks-proxy")
    public HttpClientConfig setSocksProxy(HostAndPort socksProxy) {
        this.socksProxy = socksProxy;
        return this;
    }

    public HostAndPort getHttpProxy() {
        return this.httpProxy;
    }

    @Config(value="http-client.http-proxy")
    public HttpClientConfig setHttpProxy(HostAndPort httpProxy) {
        this.httpProxy = httpProxy;
        return this;
    }

    public Optional<String> getHttpProxyUser() {
        return this.httpProxyUser;
    }

    @Config(value="http-client.http-proxy.user")
    public HttpClientConfig setHttpProxyUser(String httpProxyUser) {
        this.httpProxyUser = Optional.ofNullable(httpProxyUser);
        return this;
    }

    public Optional<String> getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    @Config(value="http-client.http-proxy.password")
    @ConfigSecuritySensitive
    public HttpClientConfig setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = Optional.ofNullable(httpProxyPassword);
        return this;
    }

    public boolean isSecureProxy() {
        return this.secureProxy;
    }

    @Config(value="http-client.http-proxy.secure")
    public HttpClientConfig setSecureProxy(boolean secureProxy) {
        this.secureProxy = secureProxy;
        return this;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @Config(value="http-client.key-store-path")
    public HttpClientConfig setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
        return this;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @Config(value="http-client.key-store-password")
    @ConfigSecuritySensitive
    public HttpClientConfig setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="http-client.trust-store-path")
    public HttpClientConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="http-client.trust-store-password")
    @ConfigSecuritySensitive
    public HttpClientConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    @Config(value="http-client.secure-random-algorithm")
    public HttpClientConfig setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
        return this;
    }

    public List<String> getHttpsIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    @Config(value="http-client.https.included-cipher")
    public HttpClientConfig setHttpsIncludedCipherSuites(String includedCipherSuites) {
        this.includedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(includedCipherSuites, "includedCipherSuites is null"));
        return this;
    }

    public List<String> getHttpsExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    @Config(value="http-client.https.excluded-cipher")
    @ConfigDescription(value="Setting this config property overwrites Jetty's default excluded cipher suites")
    public HttpClientConfig setHttpsExcludedCipherSuites(String excludedCipherSuites) {
        this.excludedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(excludedCipherSuites, "excludedCipherSuites is null"));
        return this;
    }

    public String getAutomaticHttpsSharedSecret() {
        return this.automaticHttpsSharedSecret;
    }

    @ConfigSecuritySensitive
    @Config(value="http-client.https.automatic-shared-secret")
    public HttpClientConfig setAutomaticHttpsSharedSecret(String automaticHttpsSharedSecret) {
        this.automaticHttpsSharedSecret = automaticHttpsSharedSecret;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public @NotNull @MinDataSize(value="1kB") @MaxDataSize(value="1GB") DataSize getHttp2InitialSessionReceiveWindowSize() {
        return this.http2InitialSessionReceiveWindowSize;
    }

    @Config(value="http-client.http2.session-receive-window-size")
    @ConfigDescription(value="Initial size of session's flow control receive window for HTTP/2")
    public HttpClientConfig setHttp2InitialSessionReceiveWindowSize(DataSize http2InitialSessionReceiveWindowSize) {
        this.http2InitialSessionReceiveWindowSize = http2InitialSessionReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public @NotNull @MinDataSize(value="1kB") @MaxDataSize(value="1GB") DataSize getHttp2InitialStreamReceiveWindowSize() {
        return this.http2InitialStreamReceiveWindowSize;
    }

    @Config(value="http-client.http2.stream-receive-window-size")
    @ConfigDescription(value="Initial size of stream's flow control receive window for HTTP/2")
    public HttpClientConfig setHttp2InitialStreamReceiveWindowSize(DataSize http2InitialStreamReceiveWindowSize) {
        this.http2InitialStreamReceiveWindowSize = http2InitialStreamReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="32MB")
    public @NotNull @MinDataSize(value="1kB") @MaxDataSize(value="32MB") DataSize getHttp2InputBufferSize() {
        return this.http2InputBufferSize;
    }

    @Config(value="http-client.http2.input-buffer-size")
    @ConfigDescription(value="Size of the buffer used to read from the network for HTTP/2")
    public HttpClientConfig setHttp2InputBufferSize(DataSize http2InputBufferSize) {
        this.http2InputBufferSize = http2InputBufferSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSelectorCount() {
        return this.selectorCount;
    }

    @Config(value="http-client.selector-count")
    public HttpClientConfig setSelectorCount(int selectorCount) {
        this.selectorCount = selectorCount;
        return this;
    }

    public boolean getRecordRequestComplete() {
        return this.recordRequestComplete;
    }

    @Config(value="http-client.record-request-complete")
    public HttpClientConfig setRecordRequestComplete(boolean recordRequestComplete) {
        this.recordRequestComplete = recordRequestComplete;
        return this;
    }

    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    @Config(value="http-client.use-blocking-connect")
    public HttpClientConfig setConnectBlocking(boolean connectBlocking) {
        this.connectBlocking = connectBlocking;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-client.max-threads")
    public HttpClientConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-client.min-threads")
    public HttpClientConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutThreads() {
        return this.timeoutThreads;
    }

    @Config(value="http-client.timeout-threads")
    @ConfigDescription(value="Total number of timeout threads")
    public HttpClientConfig setTimeoutThreads(int timeoutThreads) {
        this.timeoutThreads = timeoutThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getTimeoutConcurrency() {
        return this.timeoutConcurrency;
    }

    @Config(value="http-client.timeout-concurrency")
    @ConfigDescription(value="Number of concurrent locks for timeout")
    public HttpClientConfig setTimeoutConcurrency(int timeoutConcurrency) {
        this.timeoutConcurrency = timeoutConcurrency;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="http-client.log.path")
    @ConfigDescription(value="The name of the log file will be prefixed with the name of the HTTP client (<client_name>-http-client.log)")
    public HttpClientConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Config(value="http-client.log.enabled")
    public HttpClientConfig setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public DataSize getLogMaxFileSize() {
        return this.logMaxFileSize;
    }

    @Config(value="http-client.log.max-size")
    public HttpClientConfig setLogMaxFileSize(DataSize logMaxFileSize) {
        this.logMaxFileSize = logMaxFileSize;
        return this;
    }

    public int getLogHistory() {
        return this.logHistory;
    }

    @Config(value="http-client.log.max-history")
    public HttpClientConfig setLogHistory(int logHistory) {
        this.logHistory = logHistory;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getLogQueueSize() {
        return this.logQueueSize;
    }

    @Config(value="http-client.log.queue-size")
    public HttpClientConfig setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public @NotNull @MinDataSize(value="1MB") @MaxDataSize(value="1GB") DataSize getLogBufferSize() {
        return this.logBufferSize;
    }

    @Config(value="http-client.log.buffer-size")
    public HttpClientConfig setLogBufferSize(DataSize logBufferSize) {
        this.logBufferSize = logBufferSize;
        return this;
    }

    @NotNull
    public Duration getLogFlushInterval() {
        return this.logFlushInterval;
    }

    @Config(value="http-client.log.flush-interval")
    public HttpClientConfig setLogFlushInterval(Duration logFlushInterval) {
        this.logFlushInterval = logFlushInterval;
        return this;
    }

    public boolean isLogCompressionEnabled() {
        return this.logCompressionEnabled;
    }

    @Config(value="http-client.log.compression.enabled")
    public HttpClientConfig setLogCompressionEnabled(boolean logCompressionEnabled) {
        this.logCompressionEnabled = logCompressionEnabled;
        return this;
    }

    @NotNull
    public Optional<Duration> getTcpKeepAliveIdleTime() {
        return this.tcpKeepAliveIdleTime;
    }

    @Config(value="http-client.tcp-keep-alive-idle-time")
    public HttpClientConfig setTcpKeepAliveIdleTime(Duration tcpKeepAliveIdleTime) {
        this.tcpKeepAliveIdleTime = Optional.ofNullable(tcpKeepAliveIdleTime);
        return this;
    }

    public boolean isStrictEventOrdering() {
        return this.strictEventOrdering;
    }

    @ConfigHidden
    @Config(value="http-client.strict-event-ordering")
    public HttpClientConfig setStrictEventOrdering(boolean strictEventOrdering) {
        this.strictEventOrdering = strictEventOrdering;
        return this;
    }

    public boolean isUseVirtualThreads() {
        return this.useVirtualThreads;
    }

    @ConfigHidden
    @Config(value="http-client.use-virtual-threads")
    public HttpClientConfig setUseVirtualThreads(boolean useVirtualThreads) {
        this.useVirtualThreads = useVirtualThreads;
        return this;
    }

    public boolean isTrackMemoryAllocations() {
        return this.trackMemoryAllocations;
    }

    @Config(value="http-client.track-memory-allocations")
    @ConfigDescription(value="Enables tracking of memory allocations to detect potential leaks")
    @ConfigHidden
    public HttpClientConfig setTrackMemoryAllocations(boolean trackMemoryAllocations) {
        this.trackMemoryAllocations = trackMemoryAllocations;
        return this;
    }

    @AssertTrue(message="either both http-client.max-heap-memory and http-client.max-direct-memory are set or none of them")
    public @AssertTrue(message="either both http-client.max-heap-memory and http-client.max-direct-memory are set or none of them") boolean eitherBothMemorySettingsAreSetOrNone() {
        return this.maxHeapMemory.isPresent() == this.maxDirectMemory.isPresent();
    }

    @PostConstruct
    public void validate() {
        if (this.socksProxy != null && this.httpProxy != null) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("Only one proxy can be configured for HttpClient")));
        }
        if (this.secureProxy && this.httpProxy == null) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("http-client.http-proxy.secure can be enabled only when http-client.http-proxy is set")));
        }
    }
}

