/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.net.MediaType;
import io.airlift.http.client.BodyGenerator;
import java.io.InputStream;
import java.util.Objects;

public final class StreamingBodyGenerator
implements BodyGenerator {
    private final InputStream source;
    private final String contentType;

    public static StreamingBodyGenerator streamingBodyGenerator(InputStream source) {
        return new StreamingBodyGenerator(MediaType.APPLICATION_BINARY, source);
    }

    public static StreamingBodyGenerator streamingBodyGenerator(MediaType contentType, InputStream source) {
        return new StreamingBodyGenerator(contentType, source);
    }

    public InputStream source() {
        return this.source;
    }

    public String contentType() {
        return this.contentType;
    }

    private StreamingBodyGenerator(MediaType contentType, InputStream source) {
        this.contentType = Objects.requireNonNull(contentType, "contentType is null").toString();
        this.source = Objects.requireNonNull(source, "source is null");
    }
}

