/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.SocketAddressResolver;
import org.eclipse.jetty.util.thread.Scheduler;

class JettyAsyncSocketAddressResolver
extends SocketAddressResolver.Async {
    public JettyAsyncSocketAddressResolver(Executor executor, Scheduler scheduler, long timeout) {
        super(executor, scheduler, timeout);
    }

    public void resolve(String host, int port, Map<String, Object> context, Promise<List<InetSocketAddress>> promise) {
        Optional<InetAddress> address = JettyAsyncSocketAddressResolver.resolve(host);
        if (address.isPresent()) {
            promise.succeeded((Object)ImmutableList.of((Object)new InetSocketAddress(address.get(), port)));
            return;
        }
        super.resolve(host, port, context, promise);
    }

    private static Optional<InetAddress> resolve(String host) {
        try {
            return Optional.of(InetAddresses.forString((String)host));
        }
        catch (IllegalArgumentException ignored) {
            return Optional.empty();
        }
    }
}

