/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.net.HostAndPort;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.ByteBufferBodyGenerator;
import io.airlift.http.client.FileBodyGenerator;
import io.airlift.http.client.HeaderName;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpClientConfig;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.HttpStatusListener;
import io.airlift.http.client.HttpVersion;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StreamingBodyGenerator;
import io.airlift.http.client.StreamingResponse;
import io.airlift.http.client.jetty.CachedDistribution;
import io.airlift.http.client.jetty.ConcurrentScheduler;
import io.airlift.http.client.jetty.ConnectionPoolDistribution;
import io.airlift.http.client.jetty.ConnectionStats;
import io.airlift.http.client.jetty.DefaultHttpClientLogger;
import io.airlift.http.client.jetty.DestinationDistribution;
import io.airlift.http.client.jetty.FailedHttpResponseFuture;
import io.airlift.http.client.jetty.HttpClientLogger;
import io.airlift.http.client.jetty.HttpClientLoggingListener;
import io.airlift.http.client.jetty.JettyAsyncSocketAddressResolver;
import io.airlift.http.client.jetty.JettyClientDiagnostics;
import io.airlift.http.client.jetty.JettyRequestListener;
import io.airlift.http.client.jetty.JettyResponse;
import io.airlift.http.client.jetty.JettyResponseFuture;
import io.airlift.http.client.jetty.JettyResponseListener;
import io.airlift.http.client.jetty.MonitoredQueuedThreadPoolMBean;
import io.airlift.http.client.jetty.NoopLogger;
import io.airlift.http.client.jetty.RequestDistribution;
import io.airlift.node.AddressToHostname;
import io.airlift.security.mtls.AutomaticMtls;
import io.airlift.security.pem.PemReader;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.NetworkAttributes;
import io.opentelemetry.semconv.ServerAttributes;
import io.opentelemetry.semconv.UrlAttributes;
import io.opentelemetry.semconv.incubating.HttpIncubatingAttributes;
import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.StandardSocketOptions;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectableChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import jdk.net.ExtendedSocketOptions;
import org.eclipse.jetty.client.AbstractConnectionPool;
import org.eclipse.jetty.client.Authentication;
import org.eclipse.jetty.client.BasicAuthentication;
import org.eclipse.jetty.client.ByteBufferRequestContent;
import org.eclipse.jetty.client.BytesRequestContent;
import org.eclipse.jetty.client.ConnectionPoolAccessor;
import org.eclipse.jetty.client.Destination;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpProxy;
import org.eclipse.jetty.client.InputStreamRequestContent;
import org.eclipse.jetty.client.InputStreamResponseListener;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.PathRequestContent;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.Socks4Proxy;
import org.eclipse.jetty.client.transport.HttpClientConnectionFactory;
import org.eclipse.jetty.client.transport.HttpClientTransportDynamic;
import org.eclipse.jetty.client.transport.HttpDestination;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.internal.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpCookieStore;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.transport.ClientConnectionFactoryOverHTTP2;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.MonitoredQueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.VirtualThreadPool;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class JettyHttpClient
implements HttpClient {
    static final AttributeKey<Boolean> EXCEPTION_ESCAPED = AttributeKey.booleanKey((String)"exception.escaped");
    private static final String STATS_KEY = "airlift_stats";
    private static final AtomicLong NAME_COUNTER = new AtomicLong();
    private static final OpenTelemetry NOOP_OPEN_TELEMETRY = OpenTelemetry.noop();
    private static final Tracer NOOP_TRACER = TracerProvider.noop().get("noop");
    private static final AttributeKey<String> CLIENT_NAME = AttributeKey.stringKey((String)"airlift.http.client_name");
    private final org.eclipse.jetty.client.HttpClient httpClient;
    private final DataSize maxContentLength;
    private final Duration requestTimeout;
    private final Duration idleTimeout;
    private final boolean recordRequestComplete;
    private final boolean logEnabled;
    private final MonitoredQueuedThreadPoolMBean monitoredQueuedThreadPoolMBean;
    private final ConnectionStats connectionStats;
    private final RequestStats stats = new RequestStats();
    private final CachedDistribution queuedRequestsPerDestination;
    private final CachedDistribution activeConnectionsPerDestination;
    private final CachedDistribution idleConnectionsPerDestination;
    private final CachedDistribution currentQueuedTime;
    private final CachedDistribution currentRequestTime;
    private final CachedDistribution currentRequestSendTime;
    private final CachedDistribution currentResponseWaitTime;
    private final CachedDistribution currentResponseProcessTime;
    private final List<HttpRequestFilter> requestFilters;
    private final HttpStatusListeners httpStatusListeners;
    private final String name;
    private final TextMapPropagator propagator;
    private final Tracer tracer;
    private final HttpClientLogger requestLogger;
    private final JettyClientDiagnostics clientDiagnostics;

    public JettyHttpClient() {
        this(new HttpClientConfig());
    }

    public JettyHttpClient(HttpClientConfig config) {
        this(JettyHttpClient.uniqueName(), config);
    }

    public JettyHttpClient(String name, HttpClientConfig config) {
        this(name, config, (Iterable<? extends HttpRequestFilter>)ImmutableList.of());
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters) {
        this(name, config, requestFilters, Optional.empty(), Optional.empty());
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters, Iterable<? extends HttpStatusListener> httpStatusListeners) {
        this(name, config, requestFilters, NOOP_OPEN_TELEMETRY, NOOP_TRACER, Optional.empty(), Optional.empty(), httpStatusListeners);
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters, Optional<String> environment, Optional<SslContextFactory.Client> maybeSslContextFactory) {
        this(name, config, requestFilters, NOOP_OPEN_TELEMETRY, NOOP_TRACER, environment, maybeSslContextFactory);
    }

    public JettyHttpClient(String name, HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters, OpenTelemetry openTelemetry, Tracer tracer, Optional<String> environment, Optional<SslContextFactory.Client> maybeSslContextFactory) {
        this(name, config, requestFilters, openTelemetry, tracer, environment, maybeSslContextFactory, (Iterable<? extends HttpStatusListener>)ImmutableList.of());
    }

    public JettyHttpClient(String name, final HttpClientConfig config, Iterable<? extends HttpRequestFilter> requestFilters, OpenTelemetry openTelemetry, Tracer tracer, Optional<String> environment, Optional<SslContextFactory.Client> maybeSslContextFactory, Iterable<? extends HttpStatusListener> httpStatusListeners) {
        HostAndPort httpProxy;
        this.name = Objects.requireNonNull(name, "name is null");
        this.propagator = openTelemetry.getPropagators().getTextMapPropagator();
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(requestFilters, "requestFilters is null");
        Objects.requireNonNull(httpStatusListeners, "httpStatusListeners is null");
        this.maxContentLength = config.getMaxContentLength();
        this.requestTimeout = config.getRequestTimeout();
        this.idleTimeout = config.getIdleTimeout();
        this.recordRequestComplete = config.getRecordRequestComplete();
        SslContextFactory.Client sslContextFactory = maybeSslContextFactory.orElseGet(() -> JettyHttpClient.getSslContextFactory(config, environment));
        ClientConnector connector = new ClientConnector(this){

            protected void configure(SelectableChannel selectable) throws IOException {
                super.configure(selectable);
                if (config.getTcpKeepAliveIdleTime().isPresent()) {
                    JettyHttpClient.setKeepAlive(selectable, config.getTcpKeepAliveIdleTime().get());
                }
            }
        };
        connector.setSelectors(config.getSelectorCount());
        connector.setSslContextFactory(sslContextFactory);
        this.httpClient = new org.eclipse.jetty.client.HttpClient(this.getClientTransport(connector, config));
        this.httpClient.setName("http-client-" + name);
        this.httpClient.setRequestBufferSize(Math.toIntExact(config.getRequestBufferSize().toBytes()));
        this.httpClient.setResponseBufferSize(Math.toIntExact(config.getResponseBufferSize().toBytes()));
        this.httpClient.setMaxRequestHeadersSize(Math.toIntExact(config.getMaxRequestHeaderSize().toBytes()));
        this.httpClient.setMaxResponseHeadersSize(Math.toIntExact(config.getMaxResponseHeaderSize().toBytes()));
        this.httpClient.setMaxConnectionsPerDestination(config.getMaxConnectionsPerServer());
        this.httpClient.setMaxRequestsQueuedPerDestination(config.getMaxRequestsQueuedPerDestination());
        this.httpClient.setDestinationIdleTimeout(config.getDestinationIdleTimeout().toMillis());
        this.httpClient.setHttpCookieStore((HttpCookieStore)new HttpCookieStore.Empty());
        this.httpClient.setUserAgentField(null);
        this.httpClient.setIdleTimeout(this.idleTimeout.toMillis());
        this.httpClient.setConnectTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setAddressResolutionTimeout(config.getConnectTimeout().toMillis());
        this.httpClient.setConnectBlocking(config.isConnectBlocking());
        HostAndPort socksProxy = config.getSocksProxy();
        if (socksProxy != null) {
            this.httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)new Socks4Proxy(socksProxy.getHost(), socksProxy.getPortOrDefault(1080)));
        }
        if ((httpProxy = config.getHttpProxy()) != null) {
            Origin.Address proxyAddress = new Origin.Address(httpProxy.getHost(), httpProxy.getPortOrDefault(8080));
            HttpProxy proxy = new HttpProxy(proxyAddress, config.isSecureProxy());
            this.httpClient.getProxyConfiguration().addProxy((ProxyConfiguration.Proxy)proxy);
            if (config.getHttpProxyUser().isPresent() && config.getHttpProxyPassword().isPresent()) {
                this.httpClient.getAuthenticationStore().addAuthenticationResult((Authentication.Result)new BasicAuthentication.BasicResult(proxy.getURI(), HttpHeader.PROXY_AUTHORIZATION, config.getHttpProxyUser().get(), config.getHttpProxyPassword().get()));
            }
        }
        int maxBufferSize = Math.toIntExact(Math.max(Math.max(config.getMaxContentLength().toBytes(), config.getRequestBufferSize().toBytes()), config.getResponseBufferSize().toBytes()));
        this.httpClient.setByteBufferPool(this.createByteBufferPool(maxBufferSize, config));
        this.httpClient.setExecutor((Executor)JettyHttpClient.createExecutor(name, config.getMinThreads(), config.getMaxThreads(), config.isUseVirtualThreads()));
        this.httpClient.setScheduler(JettyHttpClient.createScheduler(name, config.getTimeoutConcurrency(), config.getTimeoutThreads()));
        this.httpClient.setStrictEventOrdering(config.isStrictEventOrdering());
        JettyAsyncSocketAddressResolver resolver = new JettyAsyncSocketAddressResolver(this.httpClient.getExecutor(), this.httpClient.getScheduler(), config.getConnectTimeout().toMillis());
        this.httpClient.setSocketAddressResolver((host, port, context, promise) -> {
            Optional inetAddress = AddressToHostname.tryDecodeHostnameToAddress((String)host);
            if (inetAddress.isPresent()) {
                promise.succeeded((Object)ImmutableList.of((Object)new InetSocketAddress((InetAddress)inetAddress.get(), port)));
                return;
            }
            resolver.resolve(host, port, context, (Promise<List<InetSocketAddress>>)promise);
        });
        ConnectionStatistics connectionStats = new ConnectionStatistics();
        this.httpClient.addBean((Object)connectionStats);
        this.connectionStats = new ConnectionStats(connectionStats);
        this.logEnabled = config.isLogEnabled();
        if (this.logEnabled) {
            String logFilePath = Paths.get(config.getLogPath(), String.format("%s-http-client.log", name)).toAbsolutePath().toString();
            this.requestLogger = new DefaultHttpClientLogger(logFilePath, config.getLogHistory(), config.getLogQueueSize(), config.getLogBufferSize(), config.getLogFlushInterval(), config.getLogMaxFileSize().toBytes(), config.isLogCompressionEnabled());
        } else {
            this.requestLogger = new NoopLogger();
        }
        try {
            this.httpClient.start();
            this.httpClient.getContentDecoderFactories().clear();
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        this.clientDiagnostics = new JettyClientDiagnostics();
        this.requestFilters = ImmutableList.copyOf(requestFilters);
        this.httpStatusListeners = new HttpStatusListeners((List<HttpStatusListener>)ImmutableList.copyOf(httpStatusListeners));
        this.monitoredQueuedThreadPoolMBean = new MonitoredQueuedThreadPoolMBean((MonitoredQueuedThreadPool)this.httpClient.getExecutor());
        this.activeConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getActiveConnectionCount()));
        this.idleConnectionsPerDestination = new ConnectionPoolDistribution(this.httpClient, (distribution, connectionPool) -> distribution.add((long)connectionPool.getIdleConnectionCount()));
        this.queuedRequestsPerDestination = new DestinationDistribution(this.httpClient, (distribution, destination) -> distribution.add((long)destination.getHttpExchanges().size()));
        this.currentQueuedTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                started = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(started - listener.getCreated()));
        });
        this.currentRequestTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - started));
        });
        this.currentRequestSendTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long started = listener.getRequestStarted();
            if (started == 0L) {
                return;
            }
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                requestSent = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(requestSent - started));
        });
        this.currentResponseWaitTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long requestSent = listener.getRequestFinished();
            if (requestSent == 0L) {
                return;
            }
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                responseStarted = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(responseStarted - requestSent));
        });
        this.currentResponseProcessTime = new RequestDistribution(this.httpClient, (distribution, listener, now) -> {
            long responseStarted = listener.getResponseStarted();
            if (responseStarted == 0L) {
                return;
            }
            long finished = listener.getResponseFinished();
            if (finished == 0L) {
                finished = now;
            }
            distribution.add(TimeUnit.NANOSECONDS.toMillis(finished - responseStarted));
        });
    }

    private ByteBufferPool createByteBufferPool(int maxBufferSize, HttpClientConfig config) {
        long maxHeapMemory = config.getMaxHeapMemory().map(DataSize::toBytes).orElse(0L);
        long maxOffHeapMemory = config.getMaxDirectMemory().map(DataSize::toBytes).orElse(0L);
        ArrayByteBufferPool.Tracking pool = config.isTrackMemoryAllocations() ? new ArrayByteBufferPool.Tracking(0, maxBufferSize, Integer.MAX_VALUE, maxHeapMemory, maxOffHeapMemory) : new ArrayByteBufferPool.Quadratic(0, maxBufferSize, Integer.MAX_VALUE, maxHeapMemory, maxOffHeapMemory);
        pool.setStatisticsEnabled(true);
        return pool;
    }

    private HttpClientTransport getClientTransport(ClientConnector connector, HttpClientConfig config) {
        ImmutableList.Builder protocols = ImmutableList.builder();
        if (config.isHttp2Enabled()) {
            HTTP2Client client = new HTTP2Client(connector);
            client.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            client.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            client.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            client.setStreamIdleTimeout(this.idleTimeout.toMillis());
            client.setSelectors(config.getSelectorCount());
            protocols.add((Object)new ClientConnectionFactoryOverHTTP2.HTTP2(client));
        }
        protocols.add((Object)HttpClientConnectionFactory.HTTP11);
        return new HttpClientTransportDynamic(connector, (ClientConnectionFactory.Info[])protocols.build().toArray((Object[])new ClientConnectionFactory.Info[0]));
    }

    private static void setKeepAlive(SelectableChannel selectable, Duration tcpKeepAliveIdleTime) throws IOException {
        if (!(selectable instanceof NetworkChannel)) {
            throw new IOException("Not a NetworkChannel. Cannot enable keep alive for %s".formatted(selectable.getClass()));
        }
        NetworkChannel channel = (NetworkChannel)((Object)selectable);
        channel.setOption(StandardSocketOptions.SO_KEEPALIVE, true);
        channel.setOption(ExtendedSocketOptions.TCP_KEEPIDLE, Math.toIntExact(tcpKeepAliveIdleTime.roundTo(TimeUnit.SECONDS)));
    }

    private static SslContextFactory.Client getSslContextFactory(HttpClientConfig config, Optional<String> environment) {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.setSNIProvider(JettyHttpClient::getSniServerNames);
        sslContextFactory.setEndpointIdentificationAlgorithm(config.isVerifyHostname() ? "HTTPS" : null);
        String keyStorePassword = (String)MoreObjects.firstNonNull((Object)config.getKeyStorePassword(), (Object)"");
        KeyStore keyStore = null;
        if (config.getKeyStorePath() != null) {
            keyStore = JettyHttpClient.loadKeyStore(config.getKeyStorePath(), config.getKeyStorePassword());
            sslContextFactory.setKeyStore(keyStore);
            sslContextFactory.setKeyStorePassword(keyStorePassword);
        }
        if (config.getTrustStorePath() != null || config.getAutomaticHttpsSharedSecret() != null) {
            KeyStore trustStore = JettyHttpClient.loadTrustStore(config.getTrustStorePath(), config.getTrustStorePassword());
            if (config.getAutomaticHttpsSharedSecret() != null) {
                AutomaticMtls.addClientTrust((String)config.getAutomaticHttpsSharedSecret(), (KeyStore)trustStore, (String)environment.orElseThrow(() -> new IllegalArgumentException("Environment must be provided when automatic HTTPS is enabled")));
            }
            sslContextFactory.setTrustStore(trustStore);
            sslContextFactory.setTrustStorePassword("");
        } else if (keyStore != null) {
            sslContextFactory.setTrustStore(keyStore);
            sslContextFactory.setTrustStorePassword(keyStorePassword);
        }
        sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
        List<String> includedCipherSuites = config.getHttpsIncludedCipherSuites();
        List<String> excludedCipherSuites = config.getHttpsExcludedCipherSuites();
        sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
        sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
        return sslContextFactory;
    }

    private static List<SNIServerName> getSniServerNames(SSLEngine sslEngine, List<SNIServerName> serverNames) {
        String host;
        if (serverNames.isEmpty() && (host = sslEngine.getPeerHost()) != null && !InetAddresses.isInetAddress((String)host) && !host.contains(".")) {
            try {
                return List.of(new SNIHostName(host));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return serverNames;
    }

    private static KeyStore loadKeyStore(String keystorePath, String keystorePassword) {
        KeyStore keyStore;
        Objects.requireNonNull(keystorePath, "keystorePath is null");
        try {
            File keyStoreFile = new File(keystorePath);
            if (PemReader.isPem((File)keyStoreFile)) {
                return PemReader.loadKeyStore((File)keyStoreFile, (File)keyStoreFile, Optional.ofNullable(keystorePassword), (boolean)true);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM key store: " + keystorePath, e);
        }
        FileInputStream in = new FileInputStream(keystorePath);
        try {
            KeyStore keyStore2 = KeyStore.getInstance("JKS");
            keyStore2.load(in, keystorePassword.toCharArray());
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Error loading Java key store: " + keystorePath, e);
            }
        }
        ((InputStream)in).close();
        return keyStore;
    }

    private static KeyStore loadTrustStore(String truststorePath, String truststorePassword) {
        KeyStore keyStore;
        if (truststorePath == null) {
            try {
                KeyStore keyStore2 = KeyStore.getInstance("JKS");
                keyStore2.load(null, new char[0]);
                return keyStore2;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            File keyStoreFile = new File(truststorePath);
            if (PemReader.isPem((File)keyStoreFile)) {
                return PemReader.loadTrustStore((File)keyStoreFile);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM trust store: " + truststorePath, e);
        }
        FileInputStream in = new FileInputStream(truststorePath);
        try {
            KeyStore keyStore3 = KeyStore.getInstance("JKS");
            keyStore3.load(in, truststorePassword == null ? null : truststorePassword.toCharArray());
            keyStore = keyStore3;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | GeneralSecurityException e) {
                throw new IllegalArgumentException("Error loading Java trust store: " + truststorePath, e);
            }
        }
        ((InputStream)in).close();
        return keyStore;
    }

    private static MonitoredQueuedThreadPool createExecutor(String name, int minThreads, int maxThreads, boolean useVirtualThreads) {
        try {
            MonitoredQueuedThreadPool pool = new MonitoredQueuedThreadPool(maxThreads, minThreads, 60000, null);
            pool.setName("http-client-" + name);
            pool.setDaemon(true);
            pool.start();
            pool.setStopTimeout(2000L);
            pool.setDetailedDump(true);
            if (useVirtualThreads) {
                VirtualThreadPool virtualExecutor = new VirtualThreadPool();
                virtualExecutor.setMaxThreads(maxThreads);
                virtualExecutor.setName("http-client-" + name + "#v");
                virtualExecutor.setDetailedDump(true);
                pool.setVirtualThreadsExecutor((Executor)virtualExecutor);
            }
            return pool;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static Scheduler createScheduler(String name, int timeoutConcurrency, int timeoutThreads) {
        Object scheduler;
        String threadName = "http-client-" + name + "-scheduler";
        if (timeoutConcurrency == 1 && timeoutThreads == 1) {
            scheduler = new ScheduledExecutorScheduler(threadName, true);
        } else {
            Preconditions.checkArgument((timeoutConcurrency >= 1 ? 1 : 0) != 0, (Object)"timeoutConcurrency must be at least one");
            int threads = Math.max(1, timeoutThreads / timeoutConcurrency);
            scheduler = new ConcurrentScheduler(timeoutConcurrency, threads, threadName);
        }
        try {
            scheduler.start();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return scheduler;
    }

    @Override
    public <T, E extends Exception> T execute(Request request, ResponseHandler<T, E> responseHandler) throws E {
        request = this.applyRequestFilters(request);
        Span span = this.startSpan(request);
        request = this.injectTracing(request, span);
        try {
            T t = this.doExecute(request, responseHandler, span);
            return t;
        }
        catch (Throwable t) {
            span.setStatus(StatusCode.ERROR, t.getMessage());
            span.recordException(t, Attributes.of(EXCEPTION_ESCAPED, (Object)true));
            throw t;
        }
        finally {
            span.end();
        }
    }

    @Override
    public StreamingResponse executeStreaming(Request request) {
        request = this.applyRequestFilters(request);
        final Span span = this.startSpan(request);
        request = this.injectTracing(request, span);
        ExceptionHandler exceptionHandler = (r, exception) -> {
            try {
                span.setStatus(StatusCode.ERROR, exception.getMessage());
                span.recordException((Throwable)exception, Attributes.of(EXCEPTION_ESCAPED, (Object)true));
                throw ResponseHandlerUtils.propagate(r, exception);
            }
            catch (Throwable throwable) {
                span.end();
                throw throwable;
            }
        };
        InternalResponse<StreamingResponse> internalResponse = this.internalExecute(request, exceptionHandler, span);
        Objects.requireNonNull(internalResponse);
        InternalResponse<StreamingResponse> internalResponse2 = internalResponse;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InternalExceptionResponse.class, InternalStandardResponse.class}, internalResponse2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                InternalExceptionResponse response = (InternalExceptionResponse)internalResponse2;
                yield (StreamingResponse)response.exceptionResponse;
            }
            case 1 -> {
                final InternalStandardResponse response = (InternalStandardResponse)internalResponse2;
                yield new StreamingResponse(){

                    @Override
                    public HttpVersion getHttpVersion() {
                        return response.jettyResponse.getHttpVersion();
                    }

                    @Override
                    public int getStatusCode() {
                        return response.jettyResponse.getStatusCode();
                    }

                    @Override
                    public ListMultimap<HeaderName, String> getHeaders() {
                        return response.jettyResponse.getHeaders();
                    }

                    @Override
                    public long getBytesRead() {
                        return response.jettyResponse.getBytesRead();
                    }

                    @Override
                    public InputStream getInputStream() {
                        return response.jettyResponse.getInputStream();
                    }

                    @Override
                    public void close() {
                        try {
                            response.completionHandler.run();
                        }
                        finally {
                            span.end();
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T doExecute(Request request, ResponseHandler<T, E> responseHandler, Span span) throws E {
        Object t;
        InternalResponse<Object> internalResponse = this.internalExecute(request, responseHandler::handleException, span);
        Objects.requireNonNull(internalResponse);
        InternalResponse<Object> internalResponse2 = internalResponse;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{InternalExceptionResponse.class, InternalStandardResponse.class}, internalResponse2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object t2;
                InternalExceptionResponse response = (InternalExceptionResponse)internalResponse2;
                t = t2 = response.exceptionResponse;
                break;
            }
            case 1: {
                InternalStandardResponse response = (InternalStandardResponse)internalResponse2;
                try {
                    T t3 = responseHandler.handle(request, response.jettyResponse);
                    t = t3;
                    break;
                }
                finally {
                    response.completionHandler.run();
                }
            }
        }
        return t;
    }

    private <T, E extends Exception> InternalResponse<T> internalExecute(Request request, ExceptionHandler<T, E> exceptionHandler, Span span) throws E {
        Response response;
        long requestStart = System.nanoTime();
        RequestContext context = this.buildRequestContext(request);
        InputStreamResponseListener listener = new InputStreamResponseListener();
        context.request().send((Response.CompleteListener)listener);
        try {
            response = listener.get(this.httpClient.getIdleTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(context.info(), HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            context.request().abort((Throwable)e);
            IO.close((AutoCloseable)listener);
            Thread.currentThread().interrupt();
            return new InternalExceptionResponse<T>(exceptionHandler.handleException(request, e));
        }
        catch (TimeoutException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(context.info(), HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            context.request().abort((Throwable)e);
            IO.close((AutoCloseable)listener);
            return new InternalExceptionResponse<T>(exceptionHandler.handleException(request, e));
        }
        catch (ExecutionException e) {
            this.stats.recordRequestFailed();
            this.requestLogger.log(context.info(), HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e)));
            IO.close((AutoCloseable)listener);
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                return new InternalExceptionResponse<T>(exceptionHandler.handleException(request, (Exception)cause));
            }
            return new InternalExceptionResponse<T>(exceptionHandler.handleException(request, new RuntimeException(cause)));
        }
        span.setAttribute(HttpAttributes.HTTP_RESPONSE_STATUS_CODE, response.getStatus());
        span.setAttribute(NetworkAttributes.NETWORK_PROTOCOL_NAME, (Object)"HTTP");
        span.setAttribute(NetworkAttributes.NETWORK_PROTOCOL_VERSION, (Object)JettyHttpClient.getHttpVersion(response.getVersion()));
        if (request.getBodyGenerator() != null) {
            span.setAttribute(HttpIncubatingAttributes.HTTP_REQUEST_BODY_SIZE, (Object)context.sizeListener().getBytes());
        }
        long responseStart = System.nanoTime();
        try {
            JettyResponse jettyResponse = new JettyResponse(response, listener.getInputStream());
            Runnable completionHandler = this.buildCompletionHandler(request, listener, span, jettyResponse, context.sizeListener(), requestStart, responseStart);
            return new InternalStandardResponse(jettyResponse, completionHandler);
        }
        catch (Throwable e) {
            Runnable completionHandler = this.buildCompletionHandler(request, listener, span, null, context.sizeListener(), requestStart, responseStart);
            try {
                throw ResponseHandlerUtils.propagate(request, e);
            }
            catch (Throwable throwable) {
                completionHandler.run();
                throw throwable;
            }
        }
    }

    private Runnable buildCompletionHandler(Request request, InputStreamResponseListener listener, Span span, JettyResponse jettyResponse, RequestSizeListener requestSize, long requestStart, long responseStart) {
        return () -> {
            IO.close((AutoCloseable)listener);
            if (jettyResponse != null) {
                try {
                    jettyResponse.getInputStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                span.setAttribute(HttpIncubatingAttributes.HTTP_RESPONSE_BODY_SIZE, (Object)jettyResponse.getBytesRead());
            }
            if (this.recordRequestComplete) {
                JettyHttpClient.recordRequestComplete(this.stats, request, requestSize.getBytes(), requestStart, jettyResponse, responseStart);
            }
        };
    }

    static String getHttpVersion(org.eclipse.jetty.http.HttpVersion version) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case org.eclipse.jetty.http.HttpVersion.HTTP_0_9 -> "0.9";
            case org.eclipse.jetty.http.HttpVersion.HTTP_1_0 -> "1.0";
            case org.eclipse.jetty.http.HttpVersion.HTTP_1_1 -> "1.1";
            case org.eclipse.jetty.http.HttpVersion.HTTP_2 -> "2";
            case org.eclipse.jetty.http.HttpVersion.HTTP_3 -> "3";
        };
    }

    @Override
    public <T, E extends Exception> HttpClient.HttpResponseFuture<T> executeAsync(Request request, ResponseHandler<T, E> responseHandler) {
        Objects.requireNonNull(request, "request is null");
        Objects.requireNonNull(responseHandler, "responseHandler is null");
        try {
            request = this.applyRequestFilters(request);
        }
        catch (RuntimeException e) {
            this.startSpan(request).setStatus(StatusCode.ERROR, e.getMessage()).recordException((Throwable)e, Attributes.of(EXCEPTION_ESCAPED, (Object)true)).end();
            return new FailedHttpResponseFuture(e);
        }
        Span span = this.startSpan(request);
        request = this.injectTracing(request, span);
        RequestContext jettyRequest = this.buildRequestContext(request);
        request.getMaxContentLength().ifPresent(maxRequestContentLength -> Verify.verify((maxRequestContentLength.compareTo(this.maxContentLength) <= 0 ? 1 : 0) != 0, (String)"maxRequestContentLength must be less than or equal to maxContentLength", (Object[])new Object[0]));
        JettyResponseFuture<T, E> future = new JettyResponseFuture<T, E>(request, (org.eclipse.jetty.client.Request)jettyRequest.request(), jettyRequest.sizeListener()::getBytes, responseHandler, span, this.stats, this.recordRequestComplete);
        JettyResponseListener<T, E> listener = new JettyResponseListener<T, E>((org.eclipse.jetty.client.Request)jettyRequest.request(), future, Ints.saturatedCast((long)request.getMaxContentLength().orElse(this.maxContentLength).toBytes()));
        try {
            return listener.send();
        }
        catch (RuntimeException e2) {
            RejectedExecutionException e2;
            if (!(e2 instanceof RejectedExecutionException)) {
                e2 = new RejectedExecutionException(e2);
            }
            this.requestLogger.log(jettyRequest.info(), HttpClientLogger.ResponseInfo.failed(Optional.empty(), Optional.of(e2)));
            future.failed(e2);
            return future;
        }
    }

    private Request applyRequestFilters(Request request) {
        for (HttpRequestFilter requestFilter : this.requestFilters) {
            request = requestFilter.filterRequest(request);
        }
        return request;
    }

    private Span startSpan(Request request) {
        String method = request.getMethod().toUpperCase(Locale.ENGLISH);
        int port = org.eclipse.jetty.client.HttpClient.normalizePort((String)request.getUri().getScheme(), (int)request.getUri().getPort());
        return request.getSpanBuilder().orElseGet(() -> this.tracer.spanBuilder(this.name + " " + method)).setSpanKind(SpanKind.CLIENT).setAttribute(CLIENT_NAME, (Object)this.name).setAttribute(UrlAttributes.URL_FULL, (Object)request.getUri().toString()).setAttribute(HttpAttributes.HTTP_REQUEST_METHOD, (Object)method).setAttribute(ServerAttributes.SERVER_ADDRESS, (Object)request.getUri().getHost()).setAttribute(ServerAttributes.SERVER_PORT, (Object)port).startSpan();
    }

    private Request injectTracing(Request request, Span span) {
        Context context = Context.current().with((ImplicitContextKeyed)span);
        Request.Builder builder = Request.Builder.fromRequest(request);
        this.propagator.inject(context, (Object)builder, Request.Builder::addHeader);
        return builder.build();
    }

    private RequestContext buildRequestContext(Request finalRequest) {
        long requestTime = System.currentTimeMillis();
        HttpRequest jettyRequest = (HttpRequest)this.httpClient.newRequest(finalRequest.getUri());
        finalRequest.getHttpVersion().ifPresent(version -> {
            switch (version) {
                case HTTP_1: {
                    jettyRequest.version(org.eclipse.jetty.http.HttpVersion.HTTP_1_1);
                    break;
                }
                case HTTP_2: {
                    jettyRequest.version(org.eclipse.jetty.http.HttpVersion.HTTP_2);
                    break;
                }
                case HTTP_3: {
                    jettyRequest.version(org.eclipse.jetty.http.HttpVersion.HTTP_3);
                }
            }
        });
        jettyRequest.method(finalRequest.getMethod());
        jettyRequest.headers(headers -> finalRequest.getHeaders().forEach((arg_0, arg_1) -> ((HttpFields.Mutable)headers).add(arg_0, arg_1)));
        BodyGenerator bodyGenerator = finalRequest.getBodyGenerator();
        if (bodyGenerator != null) {
            BodyGenerator bodyGenerator2 = bodyGenerator;
            Objects.requireNonNull(bodyGenerator2);
            BodyGenerator bodyGenerator3 = bodyGenerator2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StaticBodyGenerator.class, ByteBufferBodyGenerator.class, FileBodyGenerator.class, StreamingBodyGenerator.class}, (Object)bodyGenerator3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    StaticBodyGenerator generator = (StaticBodyGenerator)bodyGenerator3;
                    jettyRequest.body((Request.Content)new BytesRequestContent((byte[][])new byte[][]{generator.getBody()}));
                    break;
                }
                case 1: {
                    ByteBufferBodyGenerator generator = (ByteBufferBodyGenerator)bodyGenerator3;
                    jettyRequest.body((Request.Content)new ByteBufferRequestContent(generator.getByteBuffers()));
                    break;
                }
                case 2: {
                    FileBodyGenerator generator = (FileBodyGenerator)bodyGenerator3;
                    jettyRequest.body((Request.Content)JettyHttpClient.fileContent(generator.getPath()));
                    break;
                }
                case 3: {
                    StreamingBodyGenerator generator = (StreamingBodyGenerator)bodyGenerator3;
                    jettyRequest.body((Request.Content)new InputStreamRequestContent(generator.contentType(), generator.source(), new ByteBufferPool.Sized(this.httpClient.getByteBufferPool())));
                }
            }
        }
        jettyRequest.followRedirects(finalRequest.isFollowRedirects());
        jettyRequest.timeout(finalRequest.getRequestTimeout().orElse(this.requestTimeout).toMillis(), TimeUnit.MILLISECONDS);
        jettyRequest.idleTimeout(finalRequest.getIdleTimeout().orElse(this.idleTimeout).toMillis(), TimeUnit.MILLISECONDS);
        JettyRequestListener requestListener = new JettyRequestListener(finalRequest.getUri());
        jettyRequest.onRequestListener((Request.Listener)requestListener);
        jettyRequest.onResponseListener((Response.Listener)requestListener);
        jettyRequest.attribute(STATS_KEY, (Object)requestListener);
        jettyRequest.onComplete((Response.CompleteListener)new DiagnosticListener());
        jettyRequest.onResponseBegin((Response.BeginListener)this.httpStatusListeners);
        if (this.logEnabled) {
            HttpClientLoggingListener httpClientLoggingListener = new HttpClientLoggingListener(jettyRequest, requestTime, this.requestLogger);
            jettyRequest.onRequestListener((Request.Listener)httpClientLoggingListener);
            jettyRequest.onResponseListener((Response.Listener)httpClientLoggingListener);
        }
        RequestSizeListener requestSizeListener = new RequestSizeListener();
        jettyRequest.onRequestContent((Request.ContentListener)requestSizeListener);
        return new RequestContext(jettyRequest, HttpClientLogger.RequestInfo.from((org.eclipse.jetty.client.Request)jettyRequest, requestTime), requestSizeListener, requestTime);
    }

    private boolean shouldBeDiagnosed(Result result) {
        return Throwables.getCausalChain((Throwable)result.getFailure()).stream().anyMatch(e -> e instanceof TimeoutException || e instanceof RejectedExecutionException || e instanceof InterruptedException || e instanceof IllegalArgumentException || e instanceof IllegalStateException);
    }

    private static PathRequestContent fileContent(Path path) {
        try {
            return new PathRequestContent(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<HttpRequestFilter> getRequestFilters() {
        return this.requestFilters;
    }

    public List<HttpStatusListener> getStatusListeners() {
        return this.httpStatusListeners.httpStatusListeners();
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeout.toMillis();
    }

    @Override
    @Managed
    @Flatten
    public RequestStats getStats() {
        return this.stats;
    }

    @Managed
    @Nested
    public MonitoredQueuedThreadPoolMBean getThreadPool() {
        return this.monitoredQueuedThreadPoolMBean;
    }

    @Managed
    @Nested
    public ConnectionStats getConnectionStats() {
        return this.connectionStats;
    }

    @Managed
    @Nested
    public CachedDistribution getActiveConnectionsPerDestination() {
        return this.activeConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getIdleConnectionsPerDestination() {
        return this.idleConnectionsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getQueuedRequestsPerDestination() {
        return this.queuedRequestsPerDestination;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentQueuedTime() {
        return this.currentQueuedTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestTime() {
        return this.currentRequestTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentRequestSendTime() {
        return this.currentRequestSendTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseWaitTime() {
        return this.currentResponseWaitTime;
    }

    @Managed
    @Nested
    public CachedDistribution getCurrentResponseProcessTime() {
        return this.currentResponseProcessTime;
    }

    @Managed
    public String dump() {
        return this.httpClient.dump();
    }

    @Managed
    public void dumpStdErr() {
        this.httpClient.dumpStdErr();
    }

    @Managed
    public String dumpAllDestinations() {
        return String.format("%s\t%s\t%s\t%s\t%s\n", "URI", "queued", "request", "wait", "response") + this.httpClient.getDestinations().stream().map(JettyHttpClient::dumpDestination).collect(Collectors.joining("\n"));
    }

    @Managed
    public int getLoggerQueueSize() {
        return this.requestLogger.getQueueSize();
    }

    public String dumpDestination(URI uri) {
        return this.httpClient.getDestinations().stream().filter(destination -> Objects.equals(destination.getOrigin().getScheme(), uri.getScheme())).filter(destination -> Objects.equals(destination.getOrigin().getAddress().getHost(), uri.getHost())).filter(destination -> destination.getOrigin().getAddress().getPort() == uri.getPort()).findFirst().map(JettyHttpClient::dumpDestination).orElse(null);
    }

    private static String dumpDestination(Destination destination) {
        long now = System.nanoTime();
        return JettyHttpClient.getRequestListenersForDestination(destination).stream().map(listener -> JettyHttpClient.dumpRequest(now, listener)).sorted().collect(Collectors.joining("\n"));
    }

    static List<JettyRequestListener> getRequestListenersForDestination(Destination destination) {
        return JettyHttpClient.getRequestForDestination(destination).stream().map(request -> request.getAttributes().get(STATS_KEY)).map(JettyRequestListener.class::cast).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<org.eclipse.jetty.client.Request> getRequestForDestination(Destination destination) {
        HttpDestination httpDestination = (HttpDestination)destination;
        Queue httpExchanges = httpDestination.getHttpExchanges();
        List requests = httpExchanges.stream().map(HttpExchange::getRequest).collect(Collectors.toList());
        ConnectionPoolAccessor.getActiveConnections((AbstractConnectionPool)httpDestination.getConnectionPool()).stream().filter(HttpConnectionOverHTTP.class::isInstance).map(HttpConnectionOverHTTP.class::cast).map(connection -> connection.getHttpChannel().getHttpExchange()).filter(Objects::nonNull).forEach(exchange -> requests.add(exchange.getRequest()));
        return (List)requests.stream().filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    private static String dumpRequest(long now, JettyRequestListener listener) {
        long finished;
        long responseStarted;
        long requestFinished;
        long created = listener.getCreated();
        long requestStarted = listener.getRequestStarted();
        if (requestStarted == 0L) {
            requestStarted = now;
        }
        if ((requestFinished = listener.getRequestFinished()) == 0L) {
            requestFinished = now;
        }
        if ((responseStarted = listener.getResponseStarted()) == 0L) {
            responseStarted = now;
        }
        if ((finished = listener.getResponseFinished()) == 0L) {
            finished = now;
        }
        return String.format("%s\t%.1f\t%.1f\t%.1f\t%.1f", listener.getUri(), JettyHttpClient.nanosToMillis(requestStarted - created), JettyHttpClient.nanosToMillis(requestFinished - requestStarted), JettyHttpClient.nanosToMillis(responseStarted - requestFinished), JettyHttpClient.nanosToMillis(finished - responseStarted));
    }

    private static double nanosToMillis(long nanos) {
        return new Duration((double)nanos, TimeUnit.NANOSECONDS).getValue(TimeUnit.MILLISECONDS);
    }

    @Override
    @PreDestroy
    public void close() {
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient);
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getExecutor());
        JettyHttpClient.closeQuietly((LifeCycle)this.httpClient.getScheduler());
        this.requestLogger.close();
    }

    @Override
    public boolean isClosed() {
        return !this.httpClient.isRunning();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    private static void closeQuietly(LifeCycle service) {
        try {
            if (service != null) {
                service.stop();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String uniqueName() {
        return "anonymous" + NAME_COUNTER.incrementAndGet();
    }

    static void recordRequestComplete(RequestStats requestStats, Request request, long requestBytes, long requestStart, JettyResponse response, long responseStart) {
        if (response == null) {
            return;
        }
        Duration responseProcessingTime = Duration.nanosSince((long)responseStart);
        Duration requestProcessingTime = new Duration((double)(responseStart - requestStart), TimeUnit.NANOSECONDS);
        requestStats.recordResponseReceived(request.getMethod(), response.getStatusCode(), requestBytes, response.getBytesRead(), requestProcessingTime, responseProcessingTime);
    }

    private record HttpStatusListeners(List<HttpStatusListener> httpStatusListeners) implements Response.BeginListener
    {
        private HttpStatusListeners(List<HttpStatusListener> httpStatusListeners) {
            this.httpStatusListeners = httpStatusListeners = ImmutableList.copyOf(httpStatusListeners);
        }

        public void onBegin(Response response) {
            this.httpStatusListeners.forEach(listener -> {
                try {
                    listener.statusReceived(response.getStatus());
                }
                catch (Exception e) {
                    response.abort((Throwable)e);
                }
            });
        }
    }

    @FunctionalInterface
    private static interface ExceptionHandler<T, E extends Exception> {
        public T handleException(Request var1, Exception var2) throws E;
    }

    private static sealed interface InternalResponse<T>
    permits InternalExceptionResponse, InternalStandardResponse {
    }

    private record InternalExceptionResponse<T>(T exceptionResponse) implements InternalResponse<T>
    {
        private InternalExceptionResponse {
            Objects.requireNonNull(exceptionResponse, "exceptionResponse is null");
        }
    }

    private record InternalStandardResponse<T>(JettyResponse jettyResponse, Runnable completionHandler) implements InternalResponse<T>
    {
        private InternalStandardResponse {
            Objects.requireNonNull(jettyResponse, "jettyResponse is null");
            Objects.requireNonNull(completionHandler, "completionHandler is null");
        }
    }

    private record RequestContext(HttpRequest request, HttpClientLogger.RequestInfo info, RequestSizeListener sizeListener, long timestamp) {
    }

    private static class RequestSizeListener
    implements Request.ContentListener {
        private long bytes;

        private RequestSizeListener() {
        }

        public void onContent(org.eclipse.jetty.client.Request request, ByteBuffer content) {
            this.bytes += (long)content.remaining();
        }

        public long getBytes() {
            return this.bytes;
        }
    }

    private class DiagnosticListener
    implements Response.CompleteListener {
        private DiagnosticListener() {
        }

        public void onComplete(Result result) {
            if (result.isFailed() && JettyHttpClient.this.shouldBeDiagnosed(result)) {
                JettyHttpClient.this.clientDiagnostics.logDiagnosticsInfo(JettyHttpClient.this.httpClient);
            }
        }
    }
}

