/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.CurrentTimeMillisProvider;
import io.airlift.http.server.HttpLogLayout;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.SystemCurrentTimeMillisProvider;
import io.airlift.log.Logger;
import io.airlift.tracetoken.TraceTokenManager;
import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

class DelimitedRequestLog
implements RequestLog {
    private static final Logger log = Logger.get(DelimitedRequestLog.class);
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private final TraceTokenManager traceTokenManager;
    private final EventClient eventClient;
    private final CurrentTimeMillisProvider currentTimeMillisProvider;
    private final RollingFileAppender<HttpRequestEvent> fileAppender;

    public DelimitedRequestLog(String filename, int maxHistory, long maxFileSizeInBytes, TraceTokenManager traceTokenManager, EventClient eventClient) throws IOException {
        this(filename, maxHistory, maxFileSizeInBytes, traceTokenManager, eventClient, new SystemCurrentTimeMillisProvider());
    }

    public DelimitedRequestLog(String filename, int maxHistory, long maxFileSizeInBytes, TraceTokenManager traceTokenManager, EventClient eventClient, CurrentTimeMillisProvider currentTimeMillisProvider) throws IOException {
        this.traceTokenManager = traceTokenManager;
        this.eventClient = eventClient;
        this.currentTimeMillisProvider = currentTimeMillisProvider;
        ContextBase context = new ContextBase();
        HttpLogLayout httpLogLayout = new HttpLogLayout();
        DelimitedRequestLog.recoverTempFiles(filename);
        this.fileAppender = new RollingFileAppender();
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setFileNamePattern(filename + "-%d{yyyy-MM-dd}.%i.log.gz");
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent(this.fileAppender);
        rollingPolicy.start();
        triggeringPolicy.setContext((Context)context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.setMaxFileSize(String.valueOf(maxFileSizeInBytes));
        triggeringPolicy.start();
        this.fileAppender.setContext((Context)context);
        this.fileAppender.setFile(filename);
        this.fileAppender.setAppend(true);
        this.fileAppender.setLayout((Layout)httpLogLayout);
        this.fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        this.fileAppender.start();
    }

    public void log(Request request, Response response) {
        long currentTime = this.currentTimeMillisProvider.getCurrentTimeMillis();
        HttpRequestEvent event = HttpRequestEvent.createHttpRequestEvent(request, response, this.traceTokenManager, currentTime);
        this.fileAppender.doAppend((Object)event);
        this.eventClient.post((Object[])new HttpRequestEvent[]{event});
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.fileAppender.stop();
    }

    public boolean isRunning() {
        return true;
    }

    public boolean isStarted() {
        return true;
    }

    public boolean isStarting() {
        return false;
    }

    public boolean isStopping() {
        return false;
    }

    public boolean isStopped() {
        return false;
    }

    public boolean isFailed() {
        return false;
    }

    public void addLifeCycleListener(LifeCycle.Listener listener) {
    }

    public void removeLifeCycleListener(LifeCycle.Listener listener) {
    }

    private static void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles((dir, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles != null) {
            for (File tempFile : tempFiles) {
                String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
                File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
                if (tempFile.renameTo(newFile)) {
                    log.info("Recovered temp file: %s", new Object[]{tempFile});
                    continue;
                }
                log.warn("Could not rename temp file [%s] to [%s]", new Object[]{tempFile, newFile});
            }
        }
    }
}

