/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.ClassPathResourceHandler;
import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.StatsRecordingHandler;
import io.airlift.http.server.TimingFilter;
import io.airlift.http.server.TraceTokenFilter;
import io.airlift.node.NodeInfo;
import io.airlift.tracetoken.TraceTokenManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.GzipFilter;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.weakref.jmx.Managed;

public class HttpServer {
    private final Server server;
    private final ServerConnector httpConnector;
    private final ServerConnector httpsConnector;
    private final ServerConnector adminConnector;
    private final Optional<ZonedDateTime> certificateExpiration;

    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Servlet theAdminServlet, Map<String, String> adminParameters, Set<Filter> adminFilters, MBeanServer mbeanServer, LoginService loginService, TraceTokenManager tokenManager, RequestStats stats, EventClient eventClient) throws IOException {
        Preconditions.checkNotNull((Object)httpServerInfo, (Object)"httpServerInfo is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)theServlet, (Object)"theServlet is null");
        QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads());
        threadPool.setMinThreads(config.getMinThreads());
        threadPool.setIdleTimeout(Ints.checkedCast((long)config.getThreadMaxIdleTime().toMillis()));
        threadPool.setName("http-worker");
        this.server = new Server((ThreadPool)threadPool);
        if (config.isShowStackTrace()) {
            this.server.addBean((Object)new ErrorHandler());
        }
        if (mbeanServer != null) {
            MBeanContainer mbeanContainer = new MBeanContainer(mbeanServer);
            this.server.addBean((Object)mbeanContainer);
        }
        if (config.isHttpEnabled()) {
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSendServerVersion(false);
            httpConfiguration.setSendXPoweredBy(false);
            if (config.getMaxRequestHeaderSize() != null) {
                httpConfiguration.setRequestHeaderSize(Ints.checkedCast((long)config.getMaxRequestHeaderSize().toBytes()));
            }
            if (config.isHttpsEnabled()) {
                httpConfiguration.setSecureScheme("https");
                httpConfiguration.setSecurePort(httpServerInfo.getHttpsUri().getPort());
            }
            Integer acceptors = config.getHttpAcceptorThreads();
            Integer selectors = config.getHttpSelectorThreads();
            this.httpConnector = new ServerConnector(this.server, null, null, null, acceptors == null ? -1 : acceptors, selectors == null ? -1 : selectors, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
            this.httpConnector.setName("http");
            this.httpConnector.setPort(httpServerInfo.getHttpUri().getPort());
            this.httpConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            this.httpConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            this.httpConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)this.httpConnector);
        } else {
            this.httpConnector = null;
        }
        if (config.isHttpsEnabled()) {
            HttpConfiguration httpsConfiguration = new HttpConfiguration();
            httpsConfiguration.setSendServerVersion(false);
            httpsConfiguration.setSendXPoweredBy(false);
            if (config.getMaxRequestHeaderSize() != null) {
                httpsConfiguration.setRequestHeaderSize(Ints.checkedCast((long)config.getMaxRequestHeaderSize().toBytes()));
            }
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory sslContextFactory = new SslContextFactory(config.getKeystorePath());
            sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
            Integer acceptors = config.getHttpsAcceptorThreads();
            Integer selectors = config.getHttpsSelectorThreads();
            this.httpsConnector = new ServerConnector(this.server, null, null, null, acceptors == null ? -1 : acceptors, selectors == null ? -1 : selectors, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpsConfiguration)});
            this.httpsConnector.setName("https");
            this.httpsConnector.setPort(httpServerInfo.getHttpsUri().getPort());
            this.httpsConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            this.httpsConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            this.httpsConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)this.httpsConnector);
        } else {
            this.httpsConnector = null;
        }
        if (theAdminServlet != null && config.isAdminEnabled()) {
            HttpConfiguration adminConfiguration = new HttpConfiguration();
            adminConfiguration.setSendServerVersion(false);
            adminConfiguration.setSendXPoweredBy(false);
            if (config.getMaxRequestHeaderSize() != null) {
                adminConfiguration.setRequestHeaderSize(Ints.checkedCast((long)config.getMaxRequestHeaderSize().toBytes()));
            }
            QueuedThreadPool adminThreadPool = new QueuedThreadPool(config.getAdminMaxThreads());
            adminThreadPool.setName("http-admin-worker");
            adminThreadPool.setMinThreads(config.getAdminMinThreads());
            adminThreadPool.setIdleTimeout(Ints.checkedCast((long)config.getThreadMaxIdleTime().toMillis()));
            if (config.isHttpsEnabled()) {
                adminConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslContextFactory sslContextFactory = new SslContextFactory(config.getKeystorePath());
                sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(sslContextFactory, "http/1.1");
                this.adminConnector = new ServerConnector(this.server, (Executor)adminThreadPool, null, null, 0, -1, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(adminConfiguration)});
            } else {
                this.adminConnector = new ServerConnector(this.server, (Executor)adminThreadPool, null, null, 0, -1, new ConnectionFactory[]{new HttpConnectionFactory(adminConfiguration)});
            }
            this.adminConnector.setName("admin");
            this.adminConnector.setPort(httpServerInfo.getAdminUri().getPort());
            this.adminConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            this.adminConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            this.adminConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)this.adminConnector);
        } else {
            this.adminConnector = null;
        }
        HandlerCollection handlers = new HandlerCollection();
        for (HttpServerBinder.HttpResourceBinding resource : resources) {
            handlers.addHandler((Handler)new ClassPathResourceHandler(resource.getBaseUri(), resource.getClassPathResourceBase(), resource.getWelcomeFiles()));
        }
        handlers.addHandler((Handler)HttpServer.createServletContext(theServlet, parameters, filters, tokenManager, loginService, "http", "https"));
        if (config.isLogEnabled()) {
            handlers.addHandler((Handler)HttpServer.createLogHandler(config, tokenManager, eventClient));
        }
        RequestLogHandler statsRecorder = new RequestLogHandler();
        statsRecorder.setRequestLog((RequestLog)new StatsRecordingHandler(stats));
        handlers.addHandler((Handler)statsRecorder);
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        HandlerList rootHandlers = new HandlerList();
        if (theAdminServlet != null && config.isAdminEnabled()) {
            rootHandlers.addHandler((Handler)HttpServer.createServletContext(theAdminServlet, adminParameters, adminFilters, tokenManager, loginService, "admin"));
        }
        rootHandlers.addHandler((Handler)statsHandler);
        this.server.setHandler((Handler)rootHandlers);
        this.certificateExpiration = HttpServer.loadAllX509Certificates(config).stream().map(X509Certificate::getNotAfter).min(Comparator.naturalOrder()).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneOffset.systemDefault()));
    }

    private static ServletContextHandler createServletContext(Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, TraceTokenManager tokenManager, LoginService loginService, String ... connectorNames) {
        ServletContextHandler context = new ServletContextHandler(0);
        context.addFilter(new FilterHolder((Filter)new TimingFilter()), "/*", null);
        if (tokenManager != null) {
            context.addFilter(new FilterHolder((Filter)new TraceTokenFilter(tokenManager)), "/*", null);
        }
        context.addFilter(GzipFilter.class, "/*", null);
        if (loginService != null) {
            SecurityHandler securityHandler = HttpServer.createSecurityHandler(loginService);
            context.setSecurityHandler(securityHandler);
        }
        for (Filter filter : filters) {
            context.addFilter(new FilterHolder(filter), "/*", null);
        }
        ServletHolder servletHolder = new ServletHolder(theServlet);
        servletHolder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
        context.addServlet(servletHolder, "/*");
        String[] virtualHosts = new String[connectorNames.length];
        for (int i = 0; i < connectorNames.length; ++i) {
            virtualHosts[i] = "@" + connectorNames[i];
        }
        context.setVirtualHosts(virtualHosts);
        return context;
    }

    private static SecurityHandler createSecurityHandler(LoginService loginService) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(false);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setConstraintMappings(Arrays.asList(constraintMapping));
        return securityHandler;
    }

    private static RequestLogHandler createLogHandler(HttpServerConfig config, TraceTokenManager tokenManager, EventClient eventClient) throws IOException {
        RequestLogHandler logHandler = new RequestLogHandler();
        File logFile = new File(config.getLogPath());
        if (logFile.exists() && !logFile.isFile()) {
            throw new IOException(String.format("Log path %s exists but is not a file", logFile.getAbsolutePath()));
        }
        File logPath = logFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            throw new IOException(String.format("Cannot create %s and path does not already exist", logPath.getAbsolutePath()));
        }
        DelimitedRequestLog requestLog = new DelimitedRequestLog(config.getLogPath(), config.getLogHistory(), config.getLogMaxFileSize().toBytes(), tokenManager, eventClient);
        logHandler.setRequestLog((RequestLog)requestLog);
        return logHandler;
    }

    @Managed
    public Long getDaysUntilCertificateExpiration() {
        return this.certificateExpiration.map(date -> ZonedDateTime.now().until((Temporal)date, ChronoUnit.DAYS)).orElse(null);
    }

    @PostConstruct
    public void start() throws Exception {
        this.server.start();
        Preconditions.checkState((boolean)this.server.isStarted(), (Object)"server is not started");
        HttpServer.checkSufficientThreads((Connector)this.httpConnector, "HTTP");
        HttpServer.checkSufficientThreads((Connector)this.httpsConnector, "HTTPS");
        HttpServer.checkSufficientThreads((Connector)this.adminConnector, "admin");
        Preconditions.checkState((!this.server.getThreadPool().isLowOnThreads() ? 1 : 0) != 0, (Object)"insufficient threads configured for server connector");
    }

    @PreDestroy
    public void stop() throws Exception {
        this.server.stop();
    }

    private static void checkSufficientThreads(Connector connector, String name) {
        if (connector == null) {
            return;
        }
        Executor executor = connector.getExecutor();
        if (executor instanceof ThreadPool) {
            ThreadPool queuedThreadPool = (ThreadPool)executor;
            Preconditions.checkState((!queuedThreadPool.isLowOnThreads() ? 1 : 0) != 0, (String)"insufficient threads configured for %s connector", (Object[])new Object[]{name});
        }
    }

    private static Set<X509Certificate> loadAllX509Certificates(HttpServerConfig config) {
        ImmutableSet.Builder certificates = ImmutableSet.builder();
        if (config.isHttpsEnabled()) {
            try (FileInputStream keystoreInputStream = new FileInputStream(config.getKeystorePath());){
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(keystoreInputStream, config.getKeystorePassword().toCharArray());
                for (String alias : Collections.list(keystore.aliases())) {
                    try {
                        Certificate certificate = keystore.getCertificate(alias);
                        if (!(certificate instanceof X509Certificate)) continue;
                        certificates.add((Object)((X509Certificate)certificate));
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return certificates.build();
    }
}

