/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.HttpServer;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.TheAdminServlet;
import io.airlift.http.server.TheServlet;
import io.airlift.node.NodeInfo;
import io.airlift.tracetoken.TraceTokenManager;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.LoginService;

public class HttpServerProvider
implements Provider<HttpServer> {
    private final HttpServerInfo httpServerInfo;
    private final NodeInfo nodeInfo;
    private final HttpServerConfig config;
    private final Servlet theServlet;
    private final Set<HttpServerBinder.HttpResourceBinding> resources;
    private Map<String, String> servletInitParameters = ImmutableMap.of();
    private Servlet theAdminServlet;
    private Map<String, String> adminServletInitParameters = ImmutableMap.of();
    private MBeanServer mbeanServer;
    private LoginService loginService;
    private final RequestStats stats;
    private final Set<Filter> filters;
    private final Set<Filter> adminFilters;
    private TraceTokenManager traceTokenManager;
    private final EventClient eventClient;

    @Inject
    public HttpServerProvider(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, @TheServlet Servlet theServlet, @TheServlet Set<Filter> filters, @TheServlet Set<HttpServerBinder.HttpResourceBinding> resources, @TheAdminServlet Set<Filter> adminFilters, RequestStats stats, EventClient eventClient) {
        Preconditions.checkNotNull((Object)httpServerInfo, (Object)"httpServerInfo is null");
        Preconditions.checkNotNull((Object)nodeInfo, (Object)"nodeInfo is null");
        Preconditions.checkNotNull((Object)config, (Object)"config is null");
        Preconditions.checkNotNull((Object)theServlet, (Object)"theServlet is null");
        Preconditions.checkNotNull(filters, (Object)"filters is null");
        Preconditions.checkNotNull(resources, (Object)"resources is null");
        Preconditions.checkNotNull(adminFilters, (Object)"adminFilters is null");
        Preconditions.checkNotNull((Object)stats, (Object)"stats is null");
        Preconditions.checkNotNull((Object)eventClient, (Object)"eventClient is null");
        this.httpServerInfo = httpServerInfo;
        this.nodeInfo = nodeInfo;
        this.config = config;
        this.theServlet = theServlet;
        this.filters = ImmutableSet.copyOf(filters);
        this.resources = ImmutableSet.copyOf(resources);
        this.adminFilters = ImmutableSet.copyOf(adminFilters);
        this.stats = stats;
        this.eventClient = eventClient;
    }

    @Inject(optional=true)
    public void setServletInitParameters(@TheServlet Map<String, String> parameters) {
        this.servletInitParameters = ImmutableMap.copyOf(parameters);
    }

    @Inject(optional=true)
    public void setTheAdminServlet(@TheAdminServlet Servlet theAdminServlet) {
        this.theAdminServlet = theAdminServlet;
    }

    @Inject(optional=true)
    public void setAdminServletInitParameters(@TheAdminServlet Map<String, String> parameters) {
        this.adminServletInitParameters = ImmutableMap.copyOf(parameters);
    }

    @Inject(optional=true)
    public void setMBeanServer(MBeanServer server) {
        this.mbeanServer = server;
    }

    @Inject(optional=true)
    public void setLoginService(@Nullable LoginService loginService) {
        this.loginService = loginService;
    }

    @Inject(optional=true)
    public void setTokenManager(@Nullable TraceTokenManager tokenManager) {
        this.traceTokenManager = tokenManager;
    }

    public HttpServer get() {
        try {
            HttpServer httpServer = new HttpServer(this.httpServerInfo, this.nodeInfo, this.config, this.theServlet, this.servletInitParameters, this.filters, this.resources, this.theAdminServlet, this.adminServletInitParameters, this.adminFilters, this.mbeanServer, this.loginService, this.traceTokenManager, this.stats, this.eventClient);
            httpServer.start();
            return httpServer;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

