/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.stats.CounterStat;
import io.airlift.stats.DistributionStat;
import io.airlift.stats.TimeStat;
import io.airlift.units.Duration;
import javax.inject.Inject;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class RequestStats {
    private final CounterStat request = new CounterStat();
    private final TimeStat requestTime = new TimeStat();
    private final DistributionStat readBytes = new DistributionStat();
    private final DistributionStat writtenBytes = new DistributionStat();

    @Inject
    public RequestStats() {
    }

    public void record(String method, int responseCode, long requestSizeInBytes, long responseSizeInBytes, Duration schedulingDelay, Duration requestProcessingTime) {
        this.request.update(1L);
        this.requestTime.add(requestProcessingTime);
        this.readBytes.add(requestSizeInBytes);
        this.writtenBytes.add(responseSizeInBytes);
    }

    @Managed
    @Flatten
    public CounterStat getRequest() {
        return this.request;
    }

    @Managed
    @Nested
    public TimeStat getRequestTime() {
        return this.requestTime;
    }

    @Managed
    @Nested
    public DistributionStat getReadBytes() {
        return this.readBytes;
    }

    @Managed
    @Nested
    public DistributionStat getWrittenBytes() {
        return this.writtenBytes;
    }
}

