/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.log.Logger;
import java.io.IOException;
import org.eclipse.jetty.security.HashLoginService;

public class HashLoginServiceProvider
implements Provider<HashLoginService> {
    private static final Logger log = Logger.get(HashLoginServiceProvider.class);
    private final HttpServerConfig config;

    @Inject
    public HashLoginServiceProvider(HttpServerConfig config) {
        this.config = config;
    }

    public HashLoginService get() {
        String authConfig = this.config.getUserAuthFile();
        try {
            if (!Strings.isNullOrEmpty((String)authConfig)) {
                HashLoginService service = new HashLoginService("Airlift", authConfig);
                service.loadUsers();
                return service;
            }
            return null;
        }
        catch (IOException e) {
            log.error((Throwable)e, "Error when loading user auth info from %s", new Object[]{authConfig});
            return null;
        }
    }
}

