/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class ClassPathResourceHandler
extends AbstractHandler {
    private static final MimeTypes MIME_TYPES = new MimeTypes();
    private final String baseUri;
    private final String classPathResourceBase;
    private final List<String> welcomeFiles;

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, String ... welcomeFiles) {
        this(baseUri, classPathResourceBase, (List<String>)ImmutableList.copyOf((Object[])welcomeFiles));
    }

    public ClassPathResourceHandler(String baseUri, String classPathResourceBase, List<String> welcomeFiles) {
        Objects.requireNonNull(baseUri, "baseUri is null");
        Objects.requireNonNull(classPathResourceBase, "classPathResourceBase is null");
        Objects.requireNonNull(welcomeFiles, "welcomeFiles is null");
        Preconditions.checkArgument((baseUri.equals("/") || !baseUri.endsWith("/") ? 1 : 0) != 0, (String)"baseUri should not end with a slash: %s", (Object)baseUri);
        baseUri = baseUri.startsWith("/") ? baseUri : '/' + baseUri;
        this.baseUri = baseUri = baseUri.equals("/") ? "" : baseUri;
        this.classPathResourceBase = classPathResourceBase;
        ImmutableList.Builder files = ImmutableList.builder();
        for (String welcomeFile : welcomeFiles) {
            if (!welcomeFile.startsWith("/")) {
                welcomeFile = "/" + welcomeFile;
            }
            files.add((Object)welcomeFile);
        }
        this.welcomeFiles = files.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (baseRequest.isHandled()) {
            return;
        }
        String resourcePath = this.getResourcePath(request);
        if (resourcePath == null) {
            return;
        }
        if (resourcePath.isEmpty()) {
            response.setStatus(307);
            response.setHeader("Location", response.encodeRedirectURL(this.baseUri + "/"));
            baseRequest.setHandled(true);
            return;
        }
        URL resource = this.getResource(resourcePath);
        if (resource == null) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        boolean skipContent = false;
        if (!HttpMethod.GET.is(method)) {
            if (HttpMethod.HEAD.is(method)) {
                skipContent = true;
            } else {
                response.sendError(405);
                return;
            }
        }
        InputStream resourceStream = null;
        try {
            resourceStream = resource.openStream();
            String contentType = MIME_TYPES.getMimeByExtension(resource.toString());
            response.setContentType(contentType);
            if (skipContent) {
                return;
            }
            ByteStreams.copy((InputStream)resourceStream, (OutputStream)response.getOutputStream());
        }
        finally {
            ClassPathResourceHandler.closeQuietly(resourceStream);
        }
    }

    @Nullable
    private String getResourcePath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || !pathInfo.startsWith(this.baseUri)) {
            return null;
        }
        if (!(pathInfo = pathInfo.substring(this.baseUri.length())).startsWith("/") && !pathInfo.isEmpty()) {
            return null;
        }
        return pathInfo;
    }

    private URL getResource(String resourcePath) {
        Preconditions.checkArgument((boolean)resourcePath.startsWith("/"), (String)"resourcePath does not start with a slash: %s", (Object)resourcePath);
        if (!"/".equals(resourcePath)) {
            return ((Object)((Object)this)).getClass().getClassLoader().getResource(this.classPathResourceBase + resourcePath);
        }
        for (String welcomeFile : this.welcomeFiles) {
            URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.classPathResourceBase + welcomeFile);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    private static void closeQuietly(@Nullable InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static {
        MIME_TYPES.addMimeMapping("json", "application/json");
    }
}

