/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.ClassPathResourceHandler;
import io.airlift.http.server.ConnectionStats;
import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerChannelListener;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.StatsRecordingHandler;
import io.airlift.http.server.TimingFilter;
import io.airlift.http.server.TraceTokenFilter;
import io.airlift.node.NodeInfo;
import io.airlift.security.pem.PemReader;
import io.airlift.tracetoken.TraceTokenManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.management.MBeanServer;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpServer {
    private final Server server;
    private final boolean registerErrorHandler;
    private final DelimitedRequestLog requestLog;
    private ConnectionStats httpConnectionStats;
    private ConnectionStats httpsConnectionStats;
    private final Optional<ZonedDateTime> certificateExpiration;

    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Servlet theAdminServlet, Map<String, String> adminParameters, Set<Filter> adminFilters, MBeanServer mbeanServer, LoginService loginService, TraceTokenManager tokenManager, RequestStats stats, EventClient eventClient) throws IOException {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(theServlet, "theServlet is null");
        QueuedThreadPool threadPool = new QueuedThreadPool(config.getMaxThreads());
        threadPool.setMinThreads(config.getMinThreads());
        threadPool.setIdleTimeout(Ints.checkedCast((long)config.getThreadMaxIdleTime().toMillis()));
        threadPool.setName("http-worker");
        threadPool.setDetailedDump(true);
        this.server = new Server((ThreadPool)threadPool);
        this.registerErrorHandler = config.isShowStackTrace();
        if (mbeanServer != null) {
            MBeanContainer mbeanContainer = new MBeanContainer(mbeanServer);
            this.server.addBean((Object)mbeanContainer);
        }
        HttpConfiguration baseHttpConfiguration = new HttpConfiguration();
        baseHttpConfiguration.setSendServerVersion(false);
        baseHttpConfiguration.setSendXPoweredBy(false);
        if (config.getMaxRequestHeaderSize() != null) {
            baseHttpConfiguration.setRequestHeaderSize(Math.toIntExact(config.getMaxRequestHeaderSize().toBytes()));
        }
        if (config.getMaxResponseHeaderSize() != null) {
            baseHttpConfiguration.setResponseHeaderSize(Math.toIntExact(config.getMaxResponseHeaderSize().toBytes()));
        }
        baseHttpConfiguration.setNotifyRemoteAsyncErrors(false);
        HttpServerChannelListener channelListener = null;
        if (config.isLogEnabled()) {
            this.requestLog = HttpServer.createDelimitedRequestLog(config, tokenManager, eventClient);
            channelListener = new HttpServerChannelListener(this.requestLog);
        } else {
            this.requestLog = null;
        }
        if (config.isHttpEnabled()) {
            HttpConfiguration httpConfiguration = new HttpConfiguration(baseHttpConfiguration);
            if (config.isHttpsEnabled()) {
                httpConfiguration.setSecureScheme("https");
                httpConfiguration.setSecurePort(httpServerInfo.getHttpsUri().getPort());
            }
            Integer acceptors = config.getHttpAcceptorThreads();
            Integer selectors = config.getHttpSelectorThreads();
            HttpConnectionFactory http1 = new HttpConnectionFactory(httpConfiguration);
            HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
            http2c.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            http2c.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
            http2c.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            http2c.setStreamIdleTimeout(config.getHttp2StreamIdleTimeout().toMillis());
            ServerConnector httpConnector = HttpServer.createServerConnector(httpServerInfo.getHttpChannel(), this.server, null, (Integer)MoreObjects.firstNonNull((Object)acceptors, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)selectors, (Object)-1), new ConnectionFactory[]{http1, http2c});
            httpConnector.setName("http");
            httpConnector.setPort(httpServerInfo.getHttpUri().getPort());
            httpConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            ConnectionStatistics connectionStats = new ConnectionStatistics();
            httpConnector.addBean((Object)connectionStats);
            this.httpConnectionStats = new ConnectionStats(connectionStats);
            if (channelListener != null) {
                httpConnector.addBean((Object)channelListener);
            }
            this.server.addConnector((Connector)httpConnector);
        }
        List<String> includedCipherSuites = config.getHttpsIncludedCipherSuites();
        List<String> excludedCipherSuites = config.getHttpsExcludedCipherSuites();
        if (config.isHttpsEnabled()) {
            HttpConfiguration httpsConfiguration = new HttpConfiguration(baseHttpConfiguration);
            httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            Optional<KeyStore> pemKeyStore = HttpServer.tryLoadPemKeyStore(config);
            if (pemKeyStore.isPresent()) {
                sslContextFactory.setKeyStore(pemKeyStore.get());
                sslContextFactory.setKeyStorePassword("");
            } else {
                sslContextFactory.setKeyStorePath(config.getKeystorePath());
                sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
                if (config.getKeyManagerPassword() != null) {
                    sslContextFactory.setKeyManagerPassword(config.getKeyManagerPassword());
                }
            }
            if (config.getTrustStorePath() != null) {
                Optional<KeyStore> pemTrustStore = HttpServer.tryLoadPemTrustStore(config);
                if (pemTrustStore.isPresent()) {
                    sslContextFactory.setTrustStore(pemTrustStore.get());
                    sslContextFactory.setTrustStorePassword("");
                } else {
                    sslContextFactory.setTrustStorePath(config.getTrustStorePath());
                    sslContextFactory.setTrustStorePassword(config.getTrustStorePassword());
                }
            }
            sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
            sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
            sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
            sslContextFactory.setWantClientAuth(true);
            sslContextFactory.setSslSessionTimeout((int)config.getSslSessionTimeout().getValue(TimeUnit.SECONDS));
            sslContextFactory.setSslSessionCacheSize(config.getSslSessionCacheSize());
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1");
            Integer acceptors = config.getHttpsAcceptorThreads();
            Integer selectors = config.getHttpsSelectorThreads();
            ServerConnector httpsConnector = HttpServer.createServerConnector(httpServerInfo.getHttpsChannel(), this.server, null, (Integer)MoreObjects.firstNonNull((Object)acceptors, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)selectors, (Object)-1), new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpsConfiguration)});
            httpsConnector.setName("https");
            httpsConnector.setPort(httpServerInfo.getHttpsUri().getPort());
            httpsConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpsConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpsConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            ConnectionStatistics connectionStats = new ConnectionStatistics();
            httpsConnector.addBean((Object)connectionStats);
            this.httpsConnectionStats = new ConnectionStats(connectionStats);
            if (channelListener != null) {
                httpsConnector.addBean((Object)channelListener);
            }
            this.server.addConnector((Connector)httpsConnector);
        }
        if (theAdminServlet != null && config.isAdminEnabled()) {
            ServerConnector adminConnector;
            HttpConfiguration adminConfiguration = new HttpConfiguration(baseHttpConfiguration);
            QueuedThreadPool adminThreadPool = new QueuedThreadPool(config.getAdminMaxThreads());
            adminThreadPool.setName("http-admin-worker");
            adminThreadPool.setMinThreads(config.getAdminMinThreads());
            adminThreadPool.setIdleTimeout(Ints.checkedCast((long)config.getThreadMaxIdleTime().toMillis()));
            if (config.isHttpsEnabled()) {
                adminConfiguration.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setKeyStorePath(config.getKeystorePath());
                sslContextFactory.setKeyStorePassword(config.getKeystorePassword());
                if (config.getKeyManagerPassword() != null) {
                    sslContextFactory.setKeyManagerPassword(config.getKeyManagerPassword());
                }
                sslContextFactory.setSecureRandomAlgorithm(config.getSecureRandomAlgorithm());
                sslContextFactory.setWantClientAuth(true);
                sslContextFactory.setIncludeCipherSuites(includedCipherSuites.toArray(new String[0]));
                sslContextFactory.setExcludeCipherSuites(excludedCipherSuites.toArray(new String[0]));
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory((SslContextFactory)sslContextFactory, "http/1.1");
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, 0, -1, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(adminConfiguration)});
            } else {
                HttpConnectionFactory http1 = new HttpConnectionFactory(adminConfiguration);
                HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(adminConfiguration);
                http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, -1, -1, new ConnectionFactory[]{http1, http2c});
            }
            adminConnector.setName("admin");
            adminConnector.setPort(httpServerInfo.getAdminUri().getPort());
            adminConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            adminConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            adminConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)adminConnector);
        }
        HandlerCollection handlers = new HandlerCollection();
        for (HttpServerBinder.HttpResourceBinding resource : resources) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler((Handler)new ClassPathResourceHandler(resource.getBaseUri(), resource.getClassPathResourceBase(), resource.getWelcomeFiles()));
            handlers.addHandler((Handler)gzipHandler);
        }
        handlers.addHandler((Handler)HttpServer.createServletContext(theServlet, parameters, filters, tokenManager, loginService, "http", "https"));
        RequestLogHandler statsRecorder = new RequestLogHandler();
        statsRecorder.setRequestLog((RequestLog)new StatsRecordingHandler(stats));
        handlers.addHandler((Handler)statsRecorder);
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)handlers);
        HandlerList rootHandlers = new HandlerList();
        if (theAdminServlet != null && config.isAdminEnabled()) {
            rootHandlers.addHandler((Handler)HttpServer.createServletContext(theAdminServlet, adminParameters, adminFilters, tokenManager, loginService, "admin"));
        }
        rootHandlers.addHandler((Handler)statsHandler);
        this.server.setHandler((Handler)rootHandlers);
        this.certificateExpiration = HttpServer.loadAllX509Certificates(config).stream().map(X509Certificate::getNotAfter).min(Comparator.naturalOrder()).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    private static ServletContextHandler createServletContext(Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, TraceTokenManager tokenManager, LoginService loginService, String ... connectorNames) {
        ServletContextHandler context = new ServletContextHandler(0);
        context.addFilter(new FilterHolder((Filter)new TimingFilter()), "/*", null);
        if (tokenManager != null) {
            context.addFilter(new FilterHolder((Filter)new TraceTokenFilter(tokenManager)), "/*", null);
        }
        if (loginService != null) {
            SecurityHandler securityHandler = HttpServer.createSecurityHandler(loginService);
            context.setSecurityHandler(securityHandler);
        }
        for (Filter filter : filters) {
            context.addFilter(new FilterHolder(filter), "/*", null);
        }
        context.setGzipHandler(new GzipHandler());
        ServletHolder servletHolder = new ServletHolder(theServlet);
        servletHolder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
        context.addServlet(servletHolder, "/*");
        String[] virtualHosts = new String[connectorNames.length];
        for (int i = 0; i < connectorNames.length; ++i) {
            virtualHosts[i] = "@" + connectorNames[i];
        }
        context.setVirtualHosts(virtualHosts);
        return context;
    }

    private static SecurityHandler createSecurityHandler(LoginService loginService) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(false);
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(constraint);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setConstraintMappings((List)ImmutableList.of((Object)constraintMapping));
        return securityHandler;
    }

    private static DelimitedRequestLog createDelimitedRequestLog(HttpServerConfig config, TraceTokenManager tokenManager, EventClient eventClient) throws IOException {
        File logFile = new File(config.getLogPath());
        if (logFile.exists() && !logFile.isFile()) {
            throw new IOException(String.format("Log path %s exists but is not a file", logFile.getAbsolutePath()));
        }
        File logPath = logFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            throw new IOException(String.format("Cannot create %s and path does not already exist", logPath.getAbsolutePath()));
        }
        return new DelimitedRequestLog(config.getLogPath(), config.getLogHistory(), config.getLogQueueSize(), config.getLogMaxFileSize().toBytes(), tokenManager, eventClient, config.isLogCompressionEnabled());
    }

    private static Optional<KeyStore> tryLoadPemKeyStore(HttpServerConfig config) {
        File keyStoreFile = new File(config.getKeystorePath());
        try {
            if (!PemReader.isPem((File)keyStoreFile)) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading key store file: " + keyStoreFile, e);
        }
        try {
            return Optional.of(PemReader.loadKeyStore((File)keyStoreFile, (File)keyStoreFile, Optional.ofNullable(config.getKeystorePassword())));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM key store: " + keyStoreFile, e);
        }
    }

    private static Optional<KeyStore> tryLoadPemTrustStore(HttpServerConfig config) {
        File trustStoreFile = new File(config.getTrustStorePath());
        try {
            if (!PemReader.isPem((File)trustStoreFile)) {
                return Optional.empty();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error reading trust store file: " + trustStoreFile, e);
        }
        try {
            if (PemReader.readCertificateChain((File)trustStoreFile).isEmpty()) {
                throw new IllegalArgumentException("PEM trust store file does not contain any certificates: " + trustStoreFile);
            }
            return Optional.of(PemReader.loadTrustStore((File)trustStoreFile));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Error loading PEM trust store: " + trustStoreFile, e);
        }
    }

    @Managed
    public Long getDaysUntilCertificateExpiration() {
        return this.certificateExpiration.map(date -> ZonedDateTime.now().until((Temporal)date, ChronoUnit.DAYS)).orElse(null);
    }

    @Managed
    @Nested
    public ConnectionStats getHttpConnectionStats() {
        return this.httpConnectionStats;
    }

    @Managed
    @Nested
    public ConnectionStats getHttpsConnectionStats() {
        return this.httpsConnectionStats;
    }

    @Managed
    public int getLoggerQueueSize() {
        if (this.requestLog == null) {
            return 0;
        }
        return this.requestLog.getQueueSize();
    }

    @PostConstruct
    public void start() throws Exception {
        this.server.start();
        if (!this.registerErrorHandler) {
            this.server.setErrorHandler(null);
        }
        Preconditions.checkState((boolean)this.server.isStarted(), (Object)"server is not started");
    }

    @PreDestroy
    public void stop() throws Exception {
        this.server.setStopTimeout(1L);
        try {
            this.server.stop();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @VisibleForTesting
    void join() throws InterruptedException {
        this.server.join();
    }

    private static Set<X509Certificate> loadAllX509Certificates(HttpServerConfig config) {
        ImmutableSet.Builder certificates = ImmutableSet.builder();
        if (config.isHttpsEnabled()) {
            try (FileInputStream keystoreInputStream = new FileInputStream(config.getKeystorePath());){
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(keystoreInputStream, config.getKeystorePassword().toCharArray());
                for (String alias : Collections.list(keystore.aliases())) {
                    try {
                        Certificate certificate = keystore.getCertificate(alias);
                        if (!(certificate instanceof X509Certificate)) continue;
                        certificates.add((Object)((X509Certificate)certificate));
                    }
                    catch (KeyStoreException keyStoreException) {}
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return certificates.build();
    }

    private static ServerConnector createServerConnector(ServerSocketChannel channel, Server server, Executor executor, int acceptors, int selectors, ConnectionFactory ... factories) throws IOException {
        ServerConnector connector = new ServerConnector(server, executor, null, null, acceptors, selectors, factories);
        connector.open(channel);
        return connector;
    }
}

