/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HttpsConfig {
    private int httpsPort = 8443;
    private String keystorePath;
    private String keystorePassword;
    private String keyManagerPassword;
    private String trustStorePath;
    private String trustStorePassword;
    private String secureRandomAlgorithm;
    private List<String> includedCipherSuites = ImmutableList.of();
    private Duration sslContextRefreshTime = new Duration(1.0, TimeUnit.MINUTES);
    private String automaticHttpsSharedSecret;
    private List<String> excludedCipherSuites = ImmutableList.copyOf((Object[])new SslContextFactory.Server().getExcludeCipherSuites());
    private Duration sslSessionTimeout = new Duration(4.0, TimeUnit.HOURS);
    private int sslSessionCacheSize = 10000;

    public int getHttpsPort() {
        return this.httpsPort;
    }

    @Config(value="http-server.https.port")
    public HttpsConfig setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
        return this;
    }

    @MinDuration(value="1s")
    public Duration getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    @Config(value="http-server.https.ssl-session-timeout")
    public HttpsConfig setSslSessionTimeout(Duration sslSessionTimeout) {
        this.sslSessionTimeout = sslSessionTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getSslSessionCacheSize() {
        return this.sslSessionCacheSize;
    }

    @Config(value="http-server.https.ssl-session-cache-size")
    public HttpsConfig setSslSessionCacheSize(int sslSessionCacheSize) {
        this.sslSessionCacheSize = sslSessionCacheSize;
        return this;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    @Config(value="http-server.https.keystore.path")
    public HttpsConfig setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Config(value="http-server.https.keystore.key")
    @ConfigSecuritySensitive
    public HttpsConfig setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    @AssertTrue(message="Keystore path or automatic HTTPS shared secret must be provided when HTTPS is enabled")
    public @AssertTrue(message="Keystore path or automatic HTTPS shared secret must be provided when HTTPS is enabled") boolean isHttpsConfigurationValid() {
        return this.getKeystorePath() != null || this.getAutomaticHttpsSharedSecret() != null;
    }

    public String getKeyManagerPassword() {
        return this.keyManagerPassword;
    }

    @Config(value="http-server.https.keymanager.password")
    @ConfigSecuritySensitive
    public HttpsConfig setKeyManagerPassword(String keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @Config(value="http-server.https.truststore.path")
    public HttpsConfig setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @Config(value="http-server.https.truststore.key")
    @ConfigSecuritySensitive
    public HttpsConfig setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public String getSecureRandomAlgorithm() {
        return this.secureRandomAlgorithm;
    }

    @Config(value="http-server.https.secure-random-algorithm")
    public HttpsConfig setSecureRandomAlgorithm(String secureRandomAlgorithm) {
        this.secureRandomAlgorithm = secureRandomAlgorithm;
        return this;
    }

    public List<String> getHttpsIncludedCipherSuites() {
        return this.includedCipherSuites;
    }

    @Config(value="http-server.https.included-cipher")
    public HttpsConfig setHttpsIncludedCipherSuites(String includedCipherSuites) {
        this.includedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(includedCipherSuites, "includedCipherSuites is null"));
        return this;
    }

    public List<String> getHttpsExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    @Config(value="http-server.https.excluded-cipher")
    @ConfigDescription(value="Setting this config property overwrites Jetty's default excluded cipher suites")
    public HttpsConfig setHttpsExcludedCipherSuites(String excludedCipherSuites) {
        this.excludedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(excludedCipherSuites, "excludedCipherSuites is null"));
        return this;
    }

    @MinDuration(value="1s")
    public Duration getSslContextRefreshTime() {
        return this.sslContextRefreshTime;
    }

    @Config(value="http-server.https.ssl-context.refresh-time")
    public HttpsConfig setSslContextRefreshTime(Duration sslContextRefreshTime) {
        this.sslContextRefreshTime = sslContextRefreshTime;
        return this;
    }

    public String getAutomaticHttpsSharedSecret() {
        return this.automaticHttpsSharedSecret;
    }

    @ConfigSecuritySensitive
    @Config(value="http-server.https.automatic-shared-secret")
    public HttpsConfig setAutomaticHttpsSharedSecret(String automaticHttpsSharedSecret) {
        this.automaticHttpsSharedSecret = automaticHttpsSharedSecret;
        return this;
    }
}

