/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.collect.ImmutableList;
import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.DoubleSummaryStats;
import jakarta.annotation.Nullable;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.EventsHandler;
import org.eclipse.jetty.util.NanoTime;

public class DelimitedRequestLogHandler
extends EventsHandler
implements RequestLog {
    public static final String REQUEST_BEGIN_TO_HANDLE_ATTRIBUTE = DelimitedRequestLogHandler.class.getName() + ".begin_to_handle";
    private static final String RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE = DelimitedRequestLogHandler.class.getName() + ".response_content_timestamps";
    private static final Object MARKER = new Object();
    private final DelimitedRequestLog logger;

    public DelimitedRequestLogHandler(DelimitedRequestLog logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    protected void onResponseWriteComplete(Request request, Throwable failure) {
        request.setAttribute(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE + "." + NanoTime.now(), MARKER);
    }

    protected void onBeforeHandling(Request request) {
        request.setAttribute(REQUEST_BEGIN_TO_HANDLE_ATTRIBUTE, (Object)NanoTime.since((long)request.getBeginNanoTime()));
    }

    public void log(Request request, Response response) {
        List<Long> contentTimestamps = this.getContentTimestamps(request);
        long firstToLastContentTimeInMillis = -1L;
        if (!contentTimestamps.isEmpty()) {
            firstToLastContentTimeInMillis = TimeUnit.NANOSECONDS.toMillis(contentTimestamps.get(contentTimestamps.size() - 1) - contentTimestamps.get(0));
        }
        long beginToHandleMillis = TimeUnit.NANOSECONDS.toMillis((Long)request.getAttribute(REQUEST_BEGIN_TO_HANDLE_ATTRIBUTE));
        long beginToEndMillis = TimeUnit.NANOSECONDS.toMillis(NanoTime.since((long)request.getBeginNanoTime()));
        this.logger.log(request, response, beginToHandleMillis, beginToEndMillis, firstToLastContentTimeInMillis, DelimitedRequestLogHandler.processContentTimestamps(contentTimestamps));
    }

    private List<Long> getContentTimestamps(Request request) {
        return (List)request.getAttributeNameSet().stream().filter(name -> name.startsWith(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE)).map(name -> name.substring(RESPONSE_CONTENT_TIMESTAMPS_ATTRIBUTE.length() + 1)).map(Long::valueOf).collect(ImmutableList.toImmutableList());
    }

    @Nullable
    private static DoubleSummaryStats processContentTimestamps(List<Long> contentTimestamps) {
        Objects.requireNonNull(contentTimestamps, "contentTimestamps is null");
        if (contentTimestamps.size() == 0 || contentTimestamps.size() == 1) {
            return null;
        }
        DoubleSummaryStatistics statistics = new DoubleSummaryStatistics();
        long previousTimestamp = contentTimestamps.get(0);
        for (int i = 1; i < contentTimestamps.size(); ++i) {
            long timestamp = contentTimestamps.get(i);
            statistics.accept(TimeUnit.NANOSECONDS.toMillis(timestamp - previousTimestamp));
            previousTimestamp = timestamp;
        }
        return new DoubleSummaryStats(statistics);
    }
}

