/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import io.airlift.http.server.DelimitedRequestLogHandler;
import io.airlift.http.server.DoubleSummaryStats;
import io.airlift.http.server.Inet4Networks;
import io.airlift.http.server.TimingFilter;
import io.airlift.http.server.jetty.RequestTiming;
import io.airlift.tracetoken.TraceTokenManager;
import java.security.Principal;
import java.time.Instant;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

@EventType(value="HttpRequest")
public class HttpRequestEvent {
    private final Instant timeStamp;
    private final String traceToken;
    private final String clientAddress;
    private final String protocol;
    private final String method;
    private final String requestUri;
    private final String user;
    private final String agent;
    private final String referrer;
    private final long requestSize;
    private final String requestContentType;
    private final long responseSize;
    private final int responseCode;
    private final String responseContentType;
    private final long timeToDispatch;
    private final Long timeToFirstByte;
    private final long timeToLastByte;
    private final long beginToDispatchMillis;
    private final long beginToEndMillis;
    private final long firstToLastContentTimeInMillis;
    private final DoubleSummaryStats responseContentInterarrivalStats;
    private final String protocolVersion;

    public static HttpRequestEvent createHttpRequestEvent(Request request, Response response, TraceTokenManager traceTokenManager, RequestTiming timing) {
        String protocol;
        String method;
        String token;
        Principal principal;
        String user = null;
        Request.AuthenticationState authenticationState = Request.getAuthenticationState((Request)request);
        if (authenticationState != null && (principal = authenticationState.getUserPrincipal()) != null) {
            user = principal.getName();
        }
        if ((token = request.getHeaders().get("X-Airlift-TraceToken")) == null && traceTokenManager != null) {
            token = traceTokenManager.getCurrentRequestToken();
        }
        long timeToDispatch = TimeUnit.NANOSECONDS.toMillis((Long)MoreObjects.firstNonNull((Object)request.getAttribute(DelimitedRequestLogHandler.REQUEST_BEGIN_TO_HANDLE_ATTRIBUTE), (Object)0L));
        Long timeToFirstByte = null;
        Object firstByteTime = request.getAttribute(TimingFilter.FIRST_BYTE_TIME);
        if (firstByteTime instanceof Long) {
            Long time = (Long)firstByteTime;
            timeToFirstByte = Math.max(time - Request.getTimeStamp((Request)request), 0L);
        }
        long timeToLastByte = Math.max(timing.currentTimeInMillis() - Request.getTimeStamp((Request)request), 0L);
        ImmutableList.Builder builder = ImmutableList.builder();
        if (Request.getRemoteAddr((Request)request) != null) {
            builder.add((Object)Request.getRemoteAddr((Request)request));
        }
        Enumeration e = request.getHeaders().getValues("X-FORWARDED-FOR");
        while (e != null && e.hasMoreElements()) {
            String forwardedFor = (String)e.nextElement();
            builder.addAll(Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)forwardedFor));
        }
        String clientAddress = null;
        ImmutableList clientAddresses = builder.build();
        for (String address : Lists.reverse((List)clientAddresses)) {
            try {
                if (Inet4Networks.isPrivateNetworkAddress(address)) continue;
                clientAddress = address;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (clientAddress == null) {
            clientAddress = Request.getRemoteAddr((Request)request);
        }
        Object requestUri = null;
        if (request.getHttpURI() != null) {
            requestUri = request.getHttpURI().getPath();
            String parameters = request.getHttpURI().getQuery();
            if (parameters != null) {
                requestUri = (String)requestUri + "?" + parameters;
            }
        }
        if ((method = request.getMethod()) != null) {
            method = method.toUpperCase();
        }
        if ((protocol = request.getHeaders().get("X-FORWARDED-PROTO")) == null) {
            protocol = request.getHttpURI().getScheme();
        }
        if (protocol != null) {
            protocol = protocol.toLowerCase();
        }
        return new HttpRequestEvent(Instant.ofEpochMilli(Request.getTimeStamp((Request)request)), token, clientAddress, protocol, method, (String)requestUri, user, request.getHeaders().get("User-Agent"), request.getHeaders().get("Referer"), Request.getContentBytesRead((Request)request), request.getHeaders().get("Content-Type"), Response.getContentBytesWritten((Response)response), response.getStatus(), response.getHeaders().get("Content-Type"), timeToDispatch, timeToFirstByte, timeToLastByte, timing.beginToHandleMillis(), timing.beginToEndMillis(), timing.firstToLastContentTimeInMillis(), timing.responseContentInterarrivalStats(), request.getConnectionMetaData().getHttpVersion().asString());
    }

    public HttpRequestEvent(Instant timeStamp, String traceToken, String clientAddress, String protocol, String method, String requestUri, String user, String agent, String referrer, long requestSize, String requestContentType, long responseSize, int responseCode, String responseContentType, long timeToDispatch, Long timeToFirstByte, long timeToLastByte, long beginToDispatchMillis, long beginToEndMillis, long firstToLastContentTimeInMillis, DoubleSummaryStats responseContentInterarrivalStats, String protocolVersion) {
        this.timeStamp = timeStamp;
        this.traceToken = traceToken;
        this.clientAddress = clientAddress;
        this.protocol = protocol;
        this.method = method;
        this.requestUri = requestUri;
        this.user = user;
        this.agent = agent;
        this.referrer = referrer;
        this.requestSize = requestSize;
        this.requestContentType = requestContentType;
        this.responseSize = responseSize;
        this.responseCode = responseCode;
        this.responseContentType = responseContentType;
        this.timeToDispatch = timeToDispatch;
        this.timeToFirstByte = timeToFirstByte;
        this.timeToLastByte = timeToLastByte;
        this.beginToDispatchMillis = beginToDispatchMillis;
        this.beginToEndMillis = beginToEndMillis;
        this.firstToLastContentTimeInMillis = firstToLastContentTimeInMillis;
        this.responseContentInterarrivalStats = responseContentInterarrivalStats;
        this.protocolVersion = protocolVersion;
    }

    @EventField(fieldMapping=EventField.EventFieldMapping.TIMESTAMP)
    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    @EventField
    public String getTraceToken() {
        return this.traceToken;
    }

    @EventField
    public String getClientAddress() {
        return this.clientAddress;
    }

    @EventField
    public String getProtocol() {
        return this.protocol;
    }

    @EventField
    public String getMethod() {
        return this.method;
    }

    @EventField
    public String getRequestUri() {
        return this.requestUri;
    }

    @EventField
    public String getUser() {
        return this.user;
    }

    @EventField
    public String getAgent() {
        return this.agent;
    }

    @EventField
    public String getReferrer() {
        return this.referrer;
    }

    @EventField
    public long getRequestSize() {
        return this.requestSize;
    }

    @EventField
    public String getRequestContentType() {
        return this.requestContentType;
    }

    @EventField
    public long getResponseSize() {
        return this.responseSize;
    }

    @EventField
    public int getResponseCode() {
        return this.responseCode;
    }

    @EventField
    public String getResponseContentType() {
        return this.responseContentType;
    }

    @EventField
    public long getTimeToDispatch() {
        return this.timeToDispatch;
    }

    @EventField
    public Long getTimeToFirstByte() {
        return this.timeToFirstByte;
    }

    @EventField
    public long getTimeToLastByte() {
        return this.timeToLastByte;
    }

    @EventField
    public long getBeginToDispatchMillis() {
        return this.beginToDispatchMillis;
    }

    @EventField
    public long getBeginToEndMillis() {
        return this.beginToEndMillis;
    }

    @EventField
    public long getFirstToLastContentTimeInMillis() {
        return this.firstToLastContentTimeInMillis;
    }

    @EventField
    public DoubleSummaryStats getResponseContentInterarrivalStats() {
        return this.responseContentInterarrivalStats;
    }

    @EventField
    public String getProtocolVersion() {
        return this.protocolVersion;
    }
}

