/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.concurrent.Threads;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.ClassPathResourceFilter;
import io.airlift.http.server.ConnectionStats;
import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.DelimitedRequestLogHandler;
import io.airlift.http.server.HttpServerBinder;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.http.server.HttpsConfig;
import io.airlift.http.server.ReloadableSslContextFactoryProvider;
import io.airlift.http.server.RequestLogCollection;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.StatsRecordingHandler;
import io.airlift.http.server.TimingFilter;
import io.airlift.http.server.TraceTokenFilter;
import io.airlift.http.server.jetty.MonitoredQueuedThreadPoolMBean;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.tracetoken.TraceTokenManager;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.eclipse.jetty.ee10.servlet.FilterHolder;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee10.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.VirtualThreads;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.MonitoredQueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HttpServer {
    private static final Logger log = Logger.get(HttpServer.class);
    private final Server server;
    private final MonitoredQueuedThreadPoolMBean monitoredQueuedThreadPoolMBean;
    private final MonitoredQueuedThreadPoolMBean monitoredAdminQueuedThreadPoolMBean;
    private final DelimitedRequestLog requestLog;
    private ConnectionStats httpConnectionStats;
    private ConnectionStats httpsConnectionStats;
    private ScheduledExecutorService scheduledExecutorService;
    private Optional<SslContextFactory.Server> sslContextFactory;

    public HttpServer(HttpServerInfo httpServerInfo, NodeInfo nodeInfo, HttpServerConfig config, Optional<HttpsConfig> maybeHttpsConfig, Servlet theServlet, Map<String, String> parameters, Set<Filter> filters, Set<HttpServerBinder.HttpResourceBinding> resources, Servlet theAdminServlet, Map<String, String> adminParameters, Set<Filter> adminFilters, boolean enableVirtualThreads, boolean enableLegacyUriCompliance, ClientCertificate clientCertificate, MBeanServer mbeanServer, LoginService loginService, TraceTokenManager tokenManager, RequestStats stats, EventClient eventClient, Optional<SslContextFactory.Server> maybeSslContextFactory) throws IOException {
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(maybeHttpsConfig, "httpsConfig is null");
        Objects.requireNonNull(theServlet, "theServlet is null");
        Objects.requireNonNull(maybeSslContextFactory, "maybeSslContextFactory is null");
        Objects.requireNonNull(clientCertificate, "clientCertificate is null");
        Preconditions.checkArgument((!config.isHttpsEnabled() || maybeHttpsConfig.isPresent() ? 1 : 0) != 0, (Object)"httpsConfig must be present when HTTPS is enabled");
        MonitoredQueuedThreadPool threadPool = new MonitoredQueuedThreadPool(config.getMaxThreads());
        threadPool.setMinThreads(config.getMinThreads());
        threadPool.setIdleTimeout(Math.toIntExact(config.getThreadMaxIdleTime().toMillis()));
        threadPool.setName("http-worker");
        threadPool.setDetailedDump(true);
        if (enableVirtualThreads) {
            Executor executor = VirtualThreads.getNamedVirtualThreadsExecutor((String)"http-worker#v");
            Verify.verify((executor != null ? 1 : 0) != 0, (String)"Could not create virtual threads executor", (Object[])new Object[0]);
            log.info("Virtual threads support is enabled");
            threadPool.setVirtualThreadsExecutor(executor);
        }
        this.server = new Server((ThreadPool)threadPool);
        this.monitoredQueuedThreadPoolMBean = new MonitoredQueuedThreadPoolMBean(threadPool);
        boolean showStackTrace = config.isShowStackTrace();
        this.sslContextFactory = maybeSslContextFactory;
        if (mbeanServer != null) {
            MBeanContainer mbeanContainer = new MBeanContainer(mbeanServer);
            this.server.addBean((Object)mbeanContainer);
        }
        HttpConfiguration baseHttpConfiguration = new HttpConfiguration();
        baseHttpConfiguration.setSendServerVersion(false);
        baseHttpConfiguration.setSendXPoweredBy(false);
        if (config.isProcessForwarded()) {
            baseHttpConfiguration.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
        }
        if (config.getMaxRequestHeaderSize() != null) {
            baseHttpConfiguration.setRequestHeaderSize(Math.toIntExact(config.getMaxRequestHeaderSize().toBytes()));
        }
        if (config.getMaxResponseHeaderSize() != null) {
            baseHttpConfiguration.setResponseHeaderSize(Math.toIntExact(config.getMaxResponseHeaderSize().toBytes()));
        }
        if (enableLegacyUriCompliance) {
            UriCompliance uriCompliance = UriCompliance.from(EnumSet.of(UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR, UriCompliance.Violation.AMBIGUOUS_PATH_ENCODING));
            baseHttpConfiguration.setUriCompliance(uriCompliance);
        }
        if (config.isHttpEnabled()) {
            HttpConfiguration httpConfiguration = new HttpConfiguration(baseHttpConfiguration);
            if (config.isHttpsEnabled()) {
                httpConfiguration.setSecureScheme("https");
                httpConfiguration.setSecurePort(httpServerInfo.getHttpsUri().getPort());
            }
            Integer acceptors = config.getHttpAcceptorThreads();
            Integer selectors = config.getHttpSelectorThreads();
            HttpConnectionFactory http1 = new HttpConnectionFactory(httpConfiguration);
            HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(httpConfiguration);
            http2c.setInitialSessionRecvWindow(Math.toIntExact(config.getHttp2InitialSessionReceiveWindowSize().toBytes()));
            http2c.setInitialStreamRecvWindow(Math.toIntExact(config.getHttp2InitialStreamReceiveWindowSize().toBytes()));
            http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
            http2c.setInputBufferSize(Math.toIntExact(config.getHttp2InputBufferSize().toBytes()));
            http2c.setStreamIdleTimeout(config.getHttp2StreamIdleTimeout().toMillis());
            ServerConnector httpConnector = HttpServer.createServerConnector(httpServerInfo.getHttpChannel(), this.server, null, (Integer)MoreObjects.firstNonNull((Object)acceptors, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)selectors, (Object)-1), new ConnectionFactory[]{http1, http2c});
            httpConnector.setName("http");
            httpConnector.setPort(httpServerInfo.getHttpUri().getPort());
            httpConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            ConnectionStatistics connectionStats = new ConnectionStatistics();
            httpConnector.addBean((Object)connectionStats);
            this.httpConnectionStats = new ConnectionStats(connectionStats);
            this.server.addConnector((Connector)httpConnector);
        }
        if (config.isHttpsEnabled()) {
            HttpConfiguration httpsConfiguration = new HttpConfiguration(baseHttpConfiguration);
            HttpServer.setSecureRequestCustomizer(httpsConfiguration);
            HttpsConfig httpsConfig = maybeHttpsConfig.orElseThrow();
            this.sslContextFactory = Optional.of(this.sslContextFactory.orElseGet(() -> this.createReloadingSslContextFactory(httpsConfig, clientCertificate, nodeInfo.getEnvironment())));
            SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(this.sslContextFactory.get(), "http/1.1");
            Integer acceptors = config.getHttpsAcceptorThreads();
            Integer selectors = config.getHttpsSelectorThreads();
            ServerConnector httpsConnector = HttpServer.createServerConnector(httpServerInfo.getHttpsChannel(), this.server, null, (Integer)MoreObjects.firstNonNull((Object)acceptors, (Object)-1), (Integer)MoreObjects.firstNonNull((Object)selectors, (Object)-1), new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(httpsConfiguration)});
            httpsConnector.setName("https");
            httpsConnector.setPort(httpServerInfo.getHttpsUri().getPort());
            httpsConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            httpsConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            httpsConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            ConnectionStatistics connectionStats = new ConnectionStatistics();
            httpsConnector.addBean((Object)connectionStats);
            this.httpsConnectionStats = new ConnectionStats(connectionStats);
            this.server.addConnector((Connector)httpsConnector);
        }
        if (theAdminServlet != null && config.isAdminEnabled()) {
            ServerConnector adminConnector;
            Executor executor;
            HttpConfiguration adminConfiguration = new HttpConfiguration(baseHttpConfiguration);
            MonitoredQueuedThreadPool adminThreadPool = new MonitoredQueuedThreadPool(config.getAdminMaxThreads());
            adminThreadPool.setName("http-admin-worker");
            adminThreadPool.setMinThreads(config.getAdminMinThreads());
            adminThreadPool.setIdleTimeout(Math.toIntExact(config.getThreadMaxIdleTime().toMillis()));
            if (enableVirtualThreads && (executor = VirtualThreads.getNamedVirtualThreadsExecutor((String)"http-admin-worker#v")) != null) {
                adminThreadPool.setVirtualThreadsExecutor(executor);
            }
            this.monitoredAdminQueuedThreadPoolMBean = new MonitoredQueuedThreadPoolMBean(adminThreadPool);
            if (config.isHttpsEnabled()) {
                HttpServer.setSecureRequestCustomizer(adminConfiguration);
                HttpsConfig httpsConfig = maybeHttpsConfig.orElseThrow();
                this.sslContextFactory = Optional.of(this.sslContextFactory.orElseGet(() -> this.createReloadingSslContextFactory(httpsConfig, clientCertificate, nodeInfo.getEnvironment())));
                SslConnectionFactory sslConnectionFactory = new SslConnectionFactory(this.sslContextFactory.get(), "http/1.1");
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, 0, -1, new ConnectionFactory[]{sslConnectionFactory, new HttpConnectionFactory(adminConfiguration)});
            } else {
                HttpConnectionFactory http1 = new HttpConnectionFactory(adminConfiguration);
                HTTP2CServerConnectionFactory http2c = new HTTP2CServerConnectionFactory(adminConfiguration);
                http2c.setMaxConcurrentStreams(config.getHttp2MaxConcurrentStreams());
                adminConnector = HttpServer.createServerConnector(httpServerInfo.getAdminChannel(), this.server, (Executor)adminThreadPool, -1, -1, new ConnectionFactory[]{http1, http2c});
            }
            adminConnector.setName("admin");
            adminConnector.setPort(httpServerInfo.getAdminUri().getPort());
            adminConnector.setIdleTimeout(config.getNetworkMaxIdleTime().toMillis());
            adminConnector.setHost(nodeInfo.getBindIp().getHostAddress());
            adminConnector.setAcceptQueueSize(config.getHttpAcceptQueueSize());
            this.server.addConnector((Connector)adminConnector);
        } else {
            this.monitoredAdminQueuedThreadPoolMBean = null;
        }
        StatisticsHandler statsHandler = new StatisticsHandler();
        statsHandler.setHandler((Handler)HttpServer.createServletContext(theServlet, resources, parameters, filters, tokenManager, loginService, Set.of("http", "https"), showStackTrace, enableLegacyUriCompliance));
        ContextHandlerCollection rootHandlers = new ContextHandlerCollection(new ContextHandler[0]);
        if (theAdminServlet != null && config.isAdminEnabled()) {
            rootHandlers.addHandler((Handler)HttpServer.createServletContext(theAdminServlet, resources, adminParameters, adminFilters, tokenManager, loginService, Set.of("admin"), showStackTrace, enableLegacyUriCompliance));
        }
        rootHandlers.addHandler((Handler)statsHandler);
        StatsRecordingHandler statsRecordingHandler = new StatsRecordingHandler(stats);
        if (config.isLogEnabled()) {
            this.requestLog = HttpServer.createDelimitedRequestLog(config, tokenManager, eventClient);
            DelimitedRequestLogHandler logHandler = new DelimitedRequestLogHandler(this.requestLog);
            this.server.setRequestLog((RequestLog)new RequestLogCollection(logHandler, statsRecordingHandler));
            logHandler.setHandler((Handler)rootHandlers);
            this.server.setHandler((Handler)logHandler);
        } else {
            this.requestLog = null;
            this.server.setRequestLog((RequestLog)statsRecordingHandler);
            this.server.setHandler((Handler)rootHandlers);
        }
        if (!showStackTrace) {
            ErrorHandler errorHandler = new ErrorHandler();
            errorHandler.setShowMessageInTitle(false);
            errorHandler.setShowStacks(false);
            this.server.setErrorHandler((Request.Handler)errorHandler);
        }
    }

    private static void setSecureRequestCustomizer(HttpConfiguration configuration) {
        configuration.setCustomizers((List)ImmutableList.builder().add((Object)new SecureRequestCustomizer(false)).addAll((Iterable)configuration.getCustomizers()).build());
    }

    private static ServletContextHandler createServletContext(Servlet theServlet, Set<HttpServerBinder.HttpResourceBinding> resources, Map<String, String> parameters, Set<Filter> filters, TraceTokenManager tokenManager, LoginService loginService, Set<String> connectorNames, boolean showStackTrace, boolean enableLegacyUriCompliance) {
        ServletContextHandler context = new ServletContextHandler(0);
        if (!showStackTrace) {
            ErrorHandler handler = new ErrorHandler();
            handler.setShowStacks(false);
            context.setErrorHandler((Request.Handler)handler);
        }
        if (enableLegacyUriCompliance) {
            context.getServletHandler().setDecodeAmbiguousURIs(true);
        }
        context.addFilter(new FilterHolder((Filter)new TimingFilter()), "/*", null);
        if (tokenManager != null) {
            context.addFilter(new FilterHolder((Filter)new TraceTokenFilter(tokenManager)), "/*", null);
        }
        if (loginService != null) {
            SecurityHandler securityHandler = HttpServer.createSecurityHandler(loginService);
            context.setSecurityHandler(securityHandler);
        }
        for (Filter filter : filters) {
            context.addFilter(new FilterHolder(filter), "/*", null);
        }
        for (HttpServerBinder.HttpResourceBinding resource : resources) {
            ClassPathResourceFilter servlet = new ClassPathResourceFilter(resource.getBaseUri(), resource.getClassPathResourceBase(), resource.getWelcomeFiles());
            context.addFilter(new FilterHolder((Filter)servlet), servlet.getBaseUri() + "/*", null);
        }
        context.insertHandler((Handler.Singleton)new GzipHandler());
        ServletHolder servletHolder = new ServletHolder(theServlet);
        servletHolder.setInitParameters((Map)ImmutableMap.copyOf(parameters));
        context.addServlet(servletHolder, "/*");
        List virtualHosts = (List)connectorNames.stream().map(connectorName -> "@" + connectorName).collect(ImmutableList.toImmutableList());
        context.setVirtualHosts(virtualHosts);
        return context;
    }

    private static SecurityHandler createSecurityHandler(LoginService loginService) {
        ConstraintMapping constraintMapping = new ConstraintMapping();
        constraintMapping.setConstraint(Constraint.ALLOWED);
        constraintMapping.setPathSpec("/*");
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.setConstraintMappings((List)ImmutableList.of((Object)constraintMapping));
        return securityHandler;
    }

    private static DelimitedRequestLog createDelimitedRequestLog(HttpServerConfig config, TraceTokenManager tokenManager, EventClient eventClient) throws IOException {
        File logFile = new File(config.getLogPath());
        if (logFile.exists() && !logFile.isFile()) {
            throw new IOException(String.format("Log path %s exists but is not a file", logFile.getAbsolutePath()));
        }
        File logPath = logFile.getParentFile();
        if (!logPath.mkdirs() && !logPath.exists()) {
            throw new IOException(String.format("Cannot create %s and path does not already exist", logPath.getAbsolutePath()));
        }
        return new DelimitedRequestLog(config.getLogPath(), config.getLogHistory(), config.getLogQueueSize(), config.getLogMaxFileSize().toBytes(), tokenManager, eventClient, config.isLogCompressionEnabled());
    }

    @VisibleForTesting
    Set<X509Certificate> getCertificates() {
        ImmutableSet.Builder certificates = ImmutableSet.builder();
        this.sslContextFactory.ifPresent(factory -> {
            try {
                KeyStore keystore = factory.getKeyStore();
                for (String alias : Collections.list(keystore.aliases())) {
                    Certificate certificate = keystore.getCertificate(alias);
                    if (!(certificate instanceof X509Certificate)) continue;
                    certificates.add((Object)((X509Certificate)certificate));
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error reading certificates");
            }
        });
        return certificates.build();
    }

    @Managed
    public Long getDaysUntilCertificateExpiration() {
        return this.getCertificates().stream().map(X509Certificate::getNotAfter).min(Comparator.naturalOrder()).map(date -> ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault())).map(date -> ZonedDateTime.now().until((Temporal)date, ChronoUnit.DAYS)).orElse(null);
    }

    @Managed
    @Nested
    public ConnectionStats getHttpConnectionStats() {
        return this.httpConnectionStats;
    }

    @Managed
    @Nested
    public ConnectionStats getHttpsConnectionStats() {
        return this.httpsConnectionStats;
    }

    @Managed
    @Nested
    public MonitoredQueuedThreadPoolMBean getServerThreadPool() {
        return this.monitoredQueuedThreadPoolMBean;
    }

    @Managed
    @Nested
    public MonitoredQueuedThreadPoolMBean getAdminServerThreadPool() {
        return this.monitoredAdminQueuedThreadPoolMBean;
    }

    @Managed
    public int getLoggerQueueSize() {
        if (this.requestLog == null) {
            return 0;
        }
        return this.requestLog.getQueueSize();
    }

    @PostConstruct
    public void start() throws Exception {
        this.server.start();
        Preconditions.checkState((boolean)this.server.isStarted(), (Object)"server is not started");
    }

    @PreDestroy
    public void stop() throws Exception {
        this.server.setStopTimeout(0L);
        this.server.stop();
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdown();
        }
        if (this.requestLog != null) {
            this.requestLog.stop();
        }
    }

    @VisibleForTesting
    void join() throws InterruptedException {
        this.server.join();
    }

    private SslContextFactory.Server createReloadingSslContextFactory(HttpsConfig config, ClientCertificate clientCertificate, String environment) {
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"HttpServerScheduler"));
        }
        return new ReloadableSslContextFactoryProvider(config, this.scheduledExecutorService, clientCertificate, environment).getSslContextFactory();
    }

    private static ServerConnector createServerConnector(ServerSocketChannel channel, Server server, Executor executor, int acceptors, int selectors, ConnectionFactory ... factories) throws IOException {
        ServerConnector connector = new ServerConnector(server, executor, null, null, acceptors, selectors, factories);
        connector.open(channel);
        return connector;
    }

    public static enum ClientCertificate {
        NONE,
        REQUESTED,
        REQUIRED;

    }
}

