/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.FileSize;
import com.google.common.math.LongMath;
import io.airlift.event.client.EventClient;
import io.airlift.http.server.HttpLogLayout;
import io.airlift.http.server.HttpRequestEvent;
import io.airlift.http.server.jetty.RequestTiming;
import io.airlift.log.Logger;
import io.airlift.tracetoken.TraceTokenManager;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

class DelimitedRequestLog {
    private static final Logger log = Logger.get(DelimitedRequestLog.class);
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final FileSize BUFFER_SIZE_IN_BYTES = new FileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
    private static final long FLUSH_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final TraceTokenManager traceTokenManager;
    private final EventClient eventClient;
    private final AsyncAppenderBase<HttpRequestEvent> asyncAppender;

    public DelimitedRequestLog(String filename, int maxHistory, int queueSize, long maxFileSizeInBytes, TraceTokenManager traceTokenManager, EventClient eventClient, boolean compressionEnabled) {
        this.traceTokenManager = traceTokenManager;
        this.eventClient = eventClient;
        ContextBase context = new ContextBase();
        HttpLogLayout httpLogLayout = new HttpLogLayout();
        DelimitedRequestLog.recoverTempFiles(filename);
        FlushingFileAppender fileAppender = new FlushingFileAppender();
        SizeAndTimeBasedFNATP triggeringPolicy = new SizeAndTimeBasedFNATP();
        TimeBasedRollingPolicy rollingPolicy = new TimeBasedRollingPolicy();
        rollingPolicy.setContext((Context)context);
        rollingPolicy.setMaxHistory(maxHistory);
        rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)triggeringPolicy);
        rollingPolicy.setParent(fileAppender);
        rollingPolicy.setFileNamePattern(filename + "-%d{yyyy-MM-dd}.%i.log");
        if (compressionEnabled) {
            rollingPolicy.setFileNamePattern(rollingPolicy.getFileNamePattern() + ".gz");
        }
        rollingPolicy.setTotalSizeCap(new FileSize(LongMath.saturatedMultiply((long)maxFileSizeInBytes, (long)maxHistory)));
        triggeringPolicy.setContext((Context)context);
        triggeringPolicy.setTimeBasedRollingPolicy(rollingPolicy);
        triggeringPolicy.setMaxFileSize(new FileSize(maxFileSizeInBytes));
        fileAppender.setContext((Context)context);
        fileAppender.setFile(filename);
        fileAppender.setAppend(true);
        fileAppender.setBufferSize(BUFFER_SIZE_IN_BYTES);
        fileAppender.setLayout((Layout)httpLogLayout);
        fileAppender.setRollingPolicy((RollingPolicy)rollingPolicy);
        fileAppender.setImmediateFlush(false);
        this.asyncAppender = new AsyncAppenderBase();
        this.asyncAppender.setContext((Context)context);
        this.asyncAppender.setQueueSize(queueSize);
        this.asyncAppender.addAppender(fileAppender);
        rollingPolicy.start();
        triggeringPolicy.start();
        fileAppender.start();
        this.asyncAppender.start();
    }

    public void log(Request request, Response response, RequestTiming timing) {
        HttpRequestEvent event = HttpRequestEvent.createHttpRequestEvent(request, response, this.traceTokenManager, timing);
        this.asyncAppender.doAppend((Object)event);
        this.eventClient.post((Object[])new HttpRequestEvent[]{event});
    }

    public void stop() {
        this.asyncAppender.stop();
    }

    public int getQueueSize() {
        return this.asyncAppender.getNumberOfElementsInQueue();
    }

    private static void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles((dir, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles != null) {
            for (File tempFile : tempFiles) {
                String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
                File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
                if (tempFile.renameTo(newFile)) {
                    log.info("Recovered temp file: %s", new Object[]{tempFile});
                    continue;
                }
                log.warn("Could not rename temp file [%s] to [%s]", new Object[]{tempFile, newFile});
            }
        }
    }

    private static class FlushingFileAppender<T>
    extends RollingFileAppender<T> {
        private final AtomicLong lastFlushed = new AtomicLong(System.nanoTime());

        private FlushingFileAppender() {
        }

        protected void subAppend(T event) {
            super.subAppend(event);
            long now = System.nanoTime();
            long last = this.lastFlushed.get();
            if (now - last > FLUSH_INTERVAL_NANOS && this.lastFlushed.compareAndSet(last, now)) {
                this.flush();
            }
        }

        private void flush() {
            try {
                this.streamWriteLock.lock();
                try {
                    this.getOutputStream().flush();
                }
                finally {
                    this.streamWriteLock.unlock();
                }
            }
            catch (IOException e) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)e));
            }
        }
    }
}

