/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.http.server.DelimitedRequestLog;
import io.airlift.http.server.RequestStats;
import io.airlift.http.server.RequestTimingEventHandler;
import io.airlift.http.server.jetty.RequestTiming;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;

public class DispatchingRequestLogHandler
implements RequestLog {
    private final DelimitedRequestLog logger;
    private final RequestStats stats;

    public DispatchingRequestLogHandler(@Nullable DelimitedRequestLog logger, RequestStats stats) {
        this.logger = logger;
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void log(Request request, Response response) {
        RequestTiming timings = RequestTimingEventHandler.timings(request);
        if (this.logger != null) {
            this.logger.log(request, response, timings);
        }
        this.stats.record(Request.getContentBytesRead((Request)request), Response.getContentBytesWritten((Response)response), timings.timeToCompletion());
    }
}

