/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server.jetty;

import com.google.common.base.Verify;
import io.airlift.http.server.DoubleSummaryStats;
import io.airlift.units.Duration;
import java.time.Instant;
import java.util.Objects;

public record RequestTiming(Instant requestStarted, Duration timeToDispatch, Duration timeToHandling, Duration timeToFirstByte, Duration timeToLastByte, Duration timeToCompletion, DoubleSummaryStats responseContentInterarrivalStats) {
    public RequestTiming(Instant requestStarted, Duration timeToDispatch, Duration timeToHandling, Duration timeToFirstByte, Duration timeToLastByte, Duration timeToCompletion, DoubleSummaryStats responseContentInterarrivalStats) {
        Objects.requireNonNull(requestStarted, "requestStarted is null");
        this.verifyTimeIncreasing("dispatch to handling", timeToDispatch, timeToHandling);
        this.verifyTimeIncreasing("handling to first byte", timeToHandling, timeToFirstByte);
        this.verifyTimeIncreasing("first byte to last byte", timeToFirstByte, timeToLastByte);
        this.verifyTimeIncreasing("dispatch to completion", timeToDispatch, timeToCompletion);
        this.requestStarted = requestStarted;
        this.timeToDispatch = timeToDispatch;
        this.timeToHandling = timeToHandling;
        this.timeToFirstByte = timeToFirstByte;
        this.timeToLastByte = timeToLastByte;
        this.timeToCompletion = timeToCompletion;
        this.responseContentInterarrivalStats = responseContentInterarrivalStats;
    }

    private void verifyTimeIncreasing(String description, Duration from, Duration to) {
        Verify.verify((from.compareTo(to) <= 0 ? 1 : 0) != 0, (String)"Expected time from %s to increase but got: %s to %s", (Object)description, (Object)from, (Object)to);
    }
}

