/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.airlift.event.client.EventType;
import io.airlift.http.server.DoubleSummaryStats;
import io.airlift.http.server.Inet4Networks;
import io.airlift.http.server.jetty.RequestTiming;
import java.security.Principal;
import java.time.Instant;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;

@EventType(value="HttpRequest")
public record HttpRequestEvent(Instant timeStamp, String clientAddress, String protocol, String method, String requestUri, String user, String agent, String referrer, long requestSize, String requestContentType, long responseSize, int responseCode, String responseContentType, long timeToDispatch, long timeToHandle, long timeToFirstByte, long timeToLastByte, long timeToCompletion, long timeFromFirstToLastContent, DoubleSummaryStats responseContentInterarrivalStats, String protocolVersion) {
    public static HttpRequestEvent createHttpRequestEvent(Request request, Response response, RequestTiming timing) {
        String protocol;
        String method;
        Principal principal;
        String user = null;
        Request.AuthenticationState authenticationState = Request.getAuthenticationState((Request)request);
        if (authenticationState != null && (principal = authenticationState.getUserPrincipal()) != null) {
            user = principal.getName();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (Request.getRemoteAddr((Request)request) != null) {
            builder.add((Object)Request.getRemoteAddr((Request)request));
        }
        Enumeration e = request.getHeaders().getValues("X-FORWARDED-FOR");
        while (e != null && e.hasMoreElements()) {
            String forwardedFor = (String)e.nextElement();
            builder.addAll(Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)forwardedFor));
        }
        String clientAddress = null;
        ImmutableList clientAddresses = builder.build();
        for (String address : Lists.reverse((List)clientAddresses)) {
            try {
                if (Inet4Networks.isPrivateNetworkAddress(address)) continue;
                clientAddress = address;
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (clientAddress == null) {
            clientAddress = Request.getRemoteAddr((Request)request);
        }
        Object requestUri = null;
        if (request.getHttpURI() != null) {
            requestUri = request.getHttpURI().getPath();
            String parameters = request.getHttpURI().getQuery();
            if (parameters != null) {
                requestUri = (String)requestUri + "?" + parameters;
            }
        }
        if ((method = request.getMethod()) != null) {
            method = method.toUpperCase();
        }
        if ((protocol = request.getHeaders().get("X-FORWARDED-PROTO")) == null) {
            protocol = request.getHttpURI().getScheme();
        }
        if (protocol != null) {
            protocol = protocol.toLowerCase();
        }
        return new HttpRequestEvent(timing.requestStarted(), clientAddress, protocol, method, (String)requestUri, user, request.getHeaders().get("User-Agent"), request.getHeaders().get("Referer"), Request.getContentBytesRead((Request)request), request.getHeaders().get("Content-Type"), Response.getContentBytesWritten((Response)response), response.getStatus(), response.getHeaders().get("Content-Type"), timing.timeToDispatch().toMillis(), timing.timeToHandling().toMillis(), timing.timeToFirstByte().toMillis(), timing.timeToLastByte().toMillis(), timing.timeToCompletion().toMillis(), timing.timeToLastByte().toMillis() - timing.timeToFirstByte().toMillis(), timing.responseContentInterarrivalStats(), request.getConnectionMetaData().getHttpVersion().asString());
    }
}

