/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.util.FileSize;
import com.google.common.math.LongMath;
import io.airlift.log.Logger;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.security.Principal;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.component.ContainerLifeCycle;

public class JettyRequestLog
extends ContainerLifeCycle
implements RequestLog {
    private static final DateTimeFormatter ISO_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final Logger log = Logger.get(JettyRequestLog.class);
    private static final String TEMP_FILE_EXTENSION = ".tmp";
    private static final String LOG_FILE_EXTENSION = ".log";
    private static final FileSize BUFFER_SIZE_IN_BYTES = new FileSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes());
    private static final long FLUSH_INTERVAL_NANOS = TimeUnit.SECONDS.toNanos(10L);
    private final AsyncAppenderBase<String> asyncAppender;
    private final FlushingFileAppender<String> fileAppender;
    private final SizeAndTimeBasedFileNamingAndTriggeringPolicy<String> triggeringPolicy;
    private final TimeBasedRollingPolicy<String> rollingPolicy;

    public JettyRequestLog(String filename, int maxHistory, int queueSize, long maxFileSizeInBytes, boolean compressionEnabled, boolean immediateFlush) {
        ContextBase context = new ContextBase();
        JettyRequestLog.recoverTempFiles(filename);
        this.fileAppender = new FlushingFileAppender();
        this.triggeringPolicy = new SizeAndTimeBasedFileNamingAndTriggeringPolicy();
        this.rollingPolicy = new TimeBasedRollingPolicy();
        this.rollingPolicy.setContext((Context)context);
        this.rollingPolicy.setMaxHistory(maxHistory);
        this.rollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy(this.triggeringPolicy);
        this.rollingPolicy.setParent(this.fileAppender);
        this.rollingPolicy.setFileNamePattern(filename + "-%d{yyyy-MM-dd}.%i.log");
        if (compressionEnabled) {
            this.rollingPolicy.setFileNamePattern(this.rollingPolicy.getFileNamePattern() + ".gz");
        }
        this.rollingPolicy.setTotalSizeCap(new FileSize(LongMath.saturatedMultiply((long)maxFileSizeInBytes, (long)maxHistory)));
        this.triggeringPolicy.setContext((Context)context);
        this.triggeringPolicy.setTimeBasedRollingPolicy(this.rollingPolicy);
        this.triggeringPolicy.setMaxFileSize(new FileSize(maxFileSizeInBytes));
        this.fileAppender.setContext((Context)context);
        this.fileAppender.setFile(filename);
        this.fileAppender.setAppend(true);
        this.fileAppender.setBufferSize(BUFFER_SIZE_IN_BYTES);
        this.fileAppender.setLayout((Layout)new EchoLayout());
        this.fileAppender.setRollingPolicy((RollingPolicy)this.rollingPolicy);
        this.fileAppender.setImmediateFlush(immediateFlush);
        this.asyncAppender = new AsyncAppenderBase();
        this.asyncAppender.setContext((Context)context);
        this.asyncAppender.setQueueSize(queueSize);
        this.asyncAppender.addAppender(this.fileAppender);
    }

    public void log(Request request, Response response) {
        Principal principal;
        String user = null;
        Request.AuthenticationState authenticationState = Request.getAuthenticationState((Request)request);
        if (authenticationState != null && (principal = authenticationState.getUserPrincipal()) != null) {
            user = principal.getName();
        }
        Object requestUri = null;
        if (request.getHttpURI() != null) {
            requestUri = request.getHttpURI().getPath();
            String parameters = request.getHttpURI().getQuery();
            if (parameters != null) {
                requestUri = (String)requestUri + "?" + parameters;
            }
        }
        String line = String.join((CharSequence)"\t", new CharSequence[]{ISO_FORMATTER.format(Instant.ofEpochMilli(Request.getTimeStamp((Request)request))), Request.getRemoteAddr((Request)request), request.getMethod(), requestUri, user, request.getHeaders().get("User-Agent"), Integer.toString(response.getStatus()), Long.toString(Request.getContentBytesRead((Request)request)), Long.toString(Response.getContentBytesWritten((Response)response)), JettyRequestLog.formatLatency(NanoTime.since((long)request.getBeginNanoTime())), request.getConnectionMetaData().getProtocol(), JettyRequestLog.formatLatency(request.getHeadersNanoTime() - request.getBeginNanoTime()), JettyRequestLog.formatLatency(NanoTime.since((long)request.getHeadersNanoTime()))});
        this.asyncAppender.doAppend((Object)line);
    }

    protected void doStart() {
        this.rollingPolicy.start();
        this.triggeringPolicy.start();
        this.fileAppender.start();
        this.asyncAppender.start();
    }

    protected void doStop() {
        this.rollingPolicy.stop();
        this.triggeringPolicy.stop();
        this.fileAppender.stop();
        this.asyncAppender.stop();
    }

    public int getQueueSize() {
        return this.asyncAppender.getNumberOfElementsInQueue();
    }

    private static void recoverTempFiles(String logPath) {
        File logPathFile = new File(logPath).getParentFile();
        File[] tempFiles = logPathFile.listFiles((dir, name) -> name.endsWith(TEMP_FILE_EXTENSION));
        if (tempFiles != null) {
            for (File tempFile : tempFiles) {
                String newName = tempFile.getName().substring(0, tempFile.getName().length() - TEMP_FILE_EXTENSION.length());
                File newFile = new File(tempFile.getParent(), newName + LOG_FILE_EXTENSION);
                if (tempFile.renameTo(newFile)) {
                    log.info("Recovered temp file: %s", new Object[]{tempFile});
                    continue;
                }
                log.warn("Could not rename temp file [%s] to [%s]", new Object[]{tempFile, newFile});
            }
        }
    }

    private static String formatLatency(long nanoTime) {
        return Long.toString(TimeUnit.NANOSECONDS.toMillis(nanoTime));
    }

    private static class FlushingFileAppender<T>
    extends RollingFileAppender<T> {
        private final AtomicLong lastFlushed = new AtomicLong(System.nanoTime());

        private FlushingFileAppender() {
        }

        protected void subAppend(T event) {
            super.subAppend(event);
            long now = System.nanoTime();
            long last = this.lastFlushed.get();
            if (now - last > FLUSH_INTERVAL_NANOS && this.lastFlushed.compareAndSet(last, now)) {
                this.flush();
            }
        }

        private void flush() {
            try {
                this.streamWriteLock.lock();
                try {
                    this.getOutputStream().flush();
                }
                finally {
                    this.streamWriteLock.unlock();
                }
            }
            catch (IOException e) {
                this.started = false;
                this.addStatus((Status)new ErrorStatus("IO failure in appender", (Object)this, (Throwable)e));
            }
        }
    }
}

