/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.server;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigHidden;
import io.airlift.configuration.DefunctConfig;
import io.airlift.memory.jetty.UnsafeArrayByteBufferPool;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"jetty.http.enabled", "jetty.http.port", "jetty.https.enabled", "jetty.https.port", "jetty.https.keystore.path", "jetty.https.keystore.password", "jetty.log.path", "jetty.log.retain-days", "jetty.threads.min", "jetty.threads.max", "jetty.threads.max-idle-time-ms", "jetty.net.max-idle-time-ms", "jetty.auth.users-file", "http-server.https.keystore.password", "http-server.log.retention-time", "http-server.admin.enabled", "http-server.admin.port", "http-server.admin.threads.min", "http-server.admin.threads.max", "http-server.auth.users-file"})
public class HttpServerConfig {
    private boolean httpEnabled = true;
    private int httpPort = 8080;
    private int httpAcceptQueueSize = 8000;
    private boolean httpsEnabled;
    private String logPath = "var/log/http-request.log";
    private boolean logEnabled = true;
    private int logHistory = 15;
    private int logQueueSize = 10000;
    private DataSize logMaxFileSize = DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean logCompressionEnabled = true;
    private boolean logImmediateFlush;
    private ProcessForwardedMode processForwarded = ProcessForwardedMode.REJECT;
    private Integer httpAcceptorThreads;
    private Integer httpSelectorThreads;
    private Integer httpsAcceptorThreads;
    private Integer httpsSelectorThreads;
    private int minThreads = 2;
    private int maxThreads = 200;
    private Duration threadMaxIdleTime = new Duration(1.0, TimeUnit.MINUTES);
    private Duration networkMaxIdleTime = new Duration(200.0, TimeUnit.SECONDS);
    private DataSize maxRequestHeaderSize;
    private DataSize maxResponseHeaderSize;
    private DataSize outputBufferSize;
    private int http2MaxConcurrentStreams = 16384;
    private DataSize http2InitialSessionReceiveWindowSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize http2InitialStreamReceiveWindowSize = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize http2InputBufferSize = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private Duration http2StreamIdleTimeout = new Duration(15.0, TimeUnit.SECONDS);
    private boolean showStackTrace = true;
    private boolean compressionEnabled = true;
    private Optional<DataSize> maxHeapMemory = Optional.empty();
    private Optional<DataSize> maxDirectMemory = Optional.empty();
    private HttpBufferPoolType httpBufferPoolType = HttpBufferPoolType.DEFAULT;

    public boolean isHttpEnabled() {
        return this.httpEnabled;
    }

    @Config(value="http-server.http.enabled")
    public HttpServerConfig setHttpEnabled(boolean httpEnabled) {
        this.httpEnabled = httpEnabled;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    @Config(value="http-server.accept-queue-size")
    public HttpServerConfig setHttpAcceptQueueSize(int httpAcceptQueueSize) {
        this.httpAcceptQueueSize = httpAcceptQueueSize;
        return this;
    }

    public int getHttpAcceptQueueSize() {
        return this.httpAcceptQueueSize;
    }

    @Config(value="http-server.http.port")
    public HttpServerConfig setHttpPort(int httpPort) {
        this.httpPort = httpPort;
        return this;
    }

    public boolean isHttpsEnabled() {
        return this.httpsEnabled;
    }

    @Config(value="http-server.https.enabled")
    public HttpServerConfig setHttpsEnabled(boolean httpsEnabled) {
        this.httpsEnabled = httpsEnabled;
        return this;
    }

    public String getLogPath() {
        return this.logPath;
    }

    @Config(value="http-server.log.path")
    public HttpServerConfig setLogPath(String logPath) {
        this.logPath = logPath;
        return this;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Config(value="http-server.log.enabled")
    public HttpServerConfig setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
        return this;
    }

    public DataSize getLogMaxFileSize() {
        return this.logMaxFileSize;
    }

    @Config(value="http-server.log.max-size")
    public HttpServerConfig setLogMaxFileSize(DataSize logMaxFileSize) {
        this.logMaxFileSize = logMaxFileSize;
        return this;
    }

    public ProcessForwardedMode getProcessForwarded() {
        return this.processForwarded;
    }

    @Config(value="http-server.process-forwarded")
    @ConfigDescription(value="Process Forwarded and X-Forwarded headers (for proxied environments)")
    public HttpServerConfig setProcessForwarded(ProcessForwardedMode processForwarded) {
        this.processForwarded = processForwarded;
        return this;
    }

    @Deprecated
    public HttpServerConfig setProcessForwarded(boolean processForwareded) {
        return this.setProcessForwarded(processForwareded ? ProcessForwardedMode.ACCEPT : ProcessForwardedMode.REJECT);
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpAcceptorThreads() {
        return this.httpAcceptorThreads;
    }

    @Config(value="http-server.http.acceptor-threads")
    public HttpServerConfig setHttpAcceptorThreads(Integer httpAcceptorThreads) {
        this.httpAcceptorThreads = httpAcceptorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpSelectorThreads() {
        return this.httpSelectorThreads;
    }

    @Config(value="http-server.http.selector-threads")
    public HttpServerConfig setHttpSelectorThreads(Integer httpSelectorThreads) {
        this.httpSelectorThreads = httpSelectorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpsAcceptorThreads() {
        return this.httpsAcceptorThreads;
    }

    @Config(value="http-server.https.acceptor-threads")
    public HttpServerConfig setHttpsAcceptorThreads(Integer httpsAcceptorThreads) {
        this.httpsAcceptorThreads = httpsAcceptorThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) Integer getHttpsSelectorThreads() {
        return this.httpsSelectorThreads;
    }

    @Config(value="http-server.https.selector-threads")
    public HttpServerConfig setHttpsSelectorThreads(Integer httpsSelectorThreads) {
        this.httpsSelectorThreads = httpsSelectorThreads;
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    @Config(value="http-server.threads.max")
    public HttpServerConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public int getMinThreads() {
        return this.minThreads;
    }

    @Config(value="http-server.threads.min")
    public HttpServerConfig setMinThreads(int minThreads) {
        this.minThreads = minThreads;
        return this;
    }

    public Duration getThreadMaxIdleTime() {
        return this.threadMaxIdleTime;
    }

    @Config(value="http-server.threads.max-idle-time")
    public HttpServerConfig setThreadMaxIdleTime(Duration threadMaxIdleTime) {
        this.threadMaxIdleTime = threadMaxIdleTime;
        return this;
    }

    public int getLogHistory() {
        return this.logHistory;
    }

    @Config(value="http-server.log.max-history")
    public HttpServerConfig setLogHistory(int logHistory) {
        this.logHistory = logHistory;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getLogQueueSize() {
        return this.logQueueSize;
    }

    @Config(value="http-server.log.queue-size")
    public HttpServerConfig setLogQueueSize(int logQueueSize) {
        this.logQueueSize = logQueueSize;
        return this;
    }

    public boolean isLogCompressionEnabled() {
        return this.logCompressionEnabled;
    }

    @Config(value="http-server.log.compression.enabled")
    public HttpServerConfig setLogCompressionEnabled(boolean logCompressionEnabled) {
        this.logCompressionEnabled = logCompressionEnabled;
        return this;
    }

    public boolean isLogImmediateFlush() {
        return this.logImmediateFlush;
    }

    @Config(value="http-server.log.immediate-flush")
    public HttpServerConfig setLogImmediateFlush(boolean logImmediateFlush) {
        this.logImmediateFlush = logImmediateFlush;
        return this;
    }

    public Duration getNetworkMaxIdleTime() {
        return this.networkMaxIdleTime;
    }

    @Config(value="http-server.net.max-idle-time")
    public HttpServerConfig setNetworkMaxIdleTime(Duration networkMaxIdleTime) {
        this.networkMaxIdleTime = networkMaxIdleTime;
        return this;
    }

    public DataSize getMaxRequestHeaderSize() {
        return this.maxRequestHeaderSize;
    }

    @Config(value="http-server.max-request-header-size")
    public HttpServerConfig setMaxRequestHeaderSize(DataSize maxRequestHeaderSize) {
        this.maxRequestHeaderSize = maxRequestHeaderSize;
        return this;
    }

    public DataSize getMaxResponseHeaderSize() {
        return this.maxResponseHeaderSize;
    }

    @Config(value="http-server.max-response-header-size")
    public HttpServerConfig setMaxResponseHeaderSize(DataSize maxResponseHeaderSize) {
        this.maxResponseHeaderSize = maxResponseHeaderSize;
        return this;
    }

    public DataSize getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Config(value="http-server.output-buffer-size")
    public HttpServerConfig setOutputBufferSize(DataSize outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getHttp2MaxConcurrentStreams() {
        return this.http2MaxConcurrentStreams;
    }

    @Config(value="http-server.http2.max-concurrent-streams")
    @ConfigDescription(value="Maximum concurrent streams per connection for HTTP/2")
    public HttpServerConfig setHttp2MaxConcurrentStreams(int http2MaxConcurrentStreams) {
        this.http2MaxConcurrentStreams = http2MaxConcurrentStreams;
        return this;
    }

    public boolean isShowStackTrace() {
        return this.showStackTrace;
    }

    @Config(value="http-server.show-stack-trace")
    @ConfigDescription(value="Show the stack trace when generating an error response")
    public HttpServerConfig setShowStackTrace(boolean showStackTrace) {
        this.showStackTrace = showStackTrace;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public @NotNull @MinDataSize(value="1kB") @MaxDataSize(value="1GB") DataSize getHttp2InitialSessionReceiveWindowSize() {
        return this.http2InitialSessionReceiveWindowSize;
    }

    @Config(value="http-server.http2.session-receive-window-size")
    @ConfigDescription(value="Initial size of session's flow control receive window for HTTP/2")
    public HttpServerConfig setHttp2InitialSessionReceiveWindowSize(DataSize http2InitialSessionReceiveWindowSize) {
        this.http2InitialSessionReceiveWindowSize = http2InitialSessionReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="1GB")
    public @NotNull @MinDataSize(value="1kB") @MaxDataSize(value="1GB") DataSize getHttp2InitialStreamReceiveWindowSize() {
        return this.http2InitialStreamReceiveWindowSize;
    }

    @Config(value="http-server.http2.stream-receive-window-size")
    @ConfigDescription(value="Initial size of stream's flow control receive window for HTTP/2")
    public HttpServerConfig setHttp2InitialStreamReceiveWindowSize(DataSize http2InitialStreamReceiveWindowSize) {
        this.http2InitialStreamReceiveWindowSize = http2InitialStreamReceiveWindowSize;
        return this;
    }

    @NotNull
    @MinDataSize(value="1kB")
    @MaxDataSize(value="32MB")
    public @NotNull @MinDataSize(value="1kB") @MaxDataSize(value="32MB") DataSize getHttp2InputBufferSize() {
        return this.http2InputBufferSize;
    }

    @Config(value="http-server.http2.input-buffer-size")
    @ConfigDescription(value="Size of the buffer used to read from the network for HTTP/2")
    public HttpServerConfig setHttp2InputBufferSize(DataSize http2InputBufferSize) {
        this.http2InputBufferSize = http2InputBufferSize;
        return this;
    }

    public Duration getHttp2StreamIdleTimeout() {
        return this.http2StreamIdleTimeout;
    }

    @Config(value="http-server.http2.stream-idle-timeout")
    public HttpServerConfig setHttp2StreamIdleTimeout(Duration http2StreamIdleTimeout) {
        this.http2StreamIdleTimeout = http2StreamIdleTimeout;
        return this;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Config(value="http-server.compression.enabled")
    public HttpServerConfig setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public Optional<@MinDataSize(value="8MB") DataSize> getMaxHeapMemory() {
        return this.maxHeapMemory;
    }

    @Config(value="http-server.max-heap-memory")
    @ConfigHidden
    public HttpServerConfig setMaxHeapMemory(DataSize maxHeapMemory) {
        this.maxHeapMemory = Optional.ofNullable(maxHeapMemory);
        return this;
    }

    public Optional<@MinDataSize(value="8MB") DataSize> getMaxDirectMemory() {
        return this.maxDirectMemory;
    }

    @Config(value="http-server.max-direct-memory")
    @ConfigHidden
    public HttpServerConfig setMaxDirectMemory(DataSize maxDirectMemory) {
        this.maxDirectMemory = Optional.ofNullable(maxDirectMemory);
        return this;
    }

    public HttpBufferPoolType getHttpBufferPoolType() {
        return this.httpBufferPoolType;
    }

    @Config(value="http-server.buffer-pool-type")
    public HttpServerConfig setHttpBufferPoolType(HttpBufferPoolType httpBufferPoolType) {
        this.httpBufferPoolType = httpBufferPoolType;
        return this;
    }

    @AssertTrue(message="either both http-server.max-heap-memory and http-server.max-direct-memory are set or none of them")
    public @AssertTrue(message="either both http-server.max-heap-memory and http-server.max-direct-memory are set or none of them") boolean eitherBothMemorySettingsAreSetOrNone() {
        return this.maxHeapMemory.isPresent() == this.maxDirectMemory.isPresent();
    }

    @AssertTrue(message="http-server.buffer-pool-type=UNSAFE requires sun.misc.Unsafe to be available")
    public @AssertTrue(message="http-server.buffer-pool-type=UNSAFE requires sun.misc.Unsafe to be available") boolean isUnsafeAllowedWhenUsingUnsafeBufferPool() {
        if (this.httpBufferPoolType == HttpBufferPoolType.UNSAFE) {
            return UnsafeArrayByteBufferPool.isUnsafeAvailable();
        }
        return true;
    }

    public static enum ProcessForwardedMode {
        ACCEPT,
        REJECT,
        IGNORE;


        public static ProcessForwardedMode fromString(String value) {
            return switch (value.toUpperCase(Locale.ENGLISH)) {
                case "TRUE" -> ACCEPT;
                case "FALSE" -> REJECT;
                default -> ProcessForwardedMode.valueOf(value.toUpperCase(Locale.ENGLISH));
            };
        }
    }

    public static enum HttpBufferPoolType {
        DEFAULT,
        UNSAFE,
        FFM;

    }
}

