/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.testing;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MoreCollectors;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.ByteBufferBodyGenerator;
import io.airlift.http.client.FileBodyGenerator;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StreamingBodyGenerator;
import io.airlift.http.client.testing.TestingHttpClient;
import io.airlift.http.client.testing.TestingResponse;
import io.airlift.log.Logger;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.test.DeploymentContext;
import org.glassfish.jersey.test.inmemory.InMemoryTestContainerFactory;
import org.glassfish.jersey.test.spi.TestContainer;

public class JaxrsTestingHttpProcessor
implements TestingHttpClient.Processor {
    private static final Logger log = Logger.get(JaxrsTestingHttpProcessor.class);
    private final Client client;
    private boolean trace;

    public JaxrsTestingHttpProcessor(URI baseUri, Object ... jaxRsSingletons) {
        ImmutableSet jaxRsSingletonsSet = ImmutableSet.copyOf((Object[])jaxRsSingletons);
        Application application = new Application(this, (Set)jaxRsSingletonsSet){
            final /* synthetic */ Set val$jaxRsSingletonsSet;
            {
                this.val$jaxRsSingletonsSet = set;
            }

            public Set<Object> getSingletons() {
                return this.val$jaxRsSingletonsSet;
            }
        };
        TestContainer testContainer = new InMemoryTestContainerFactory().create(baseUri, DeploymentContext.newInstance((Application)application));
        ClientConfig clientConfig = testContainer.getClientConfig();
        this.client = JerseyClientBuilder.createClient((Configuration)clientConfig);
    }

    public JaxrsTestingHttpProcessor setTrace(boolean enabled) {
        this.trace = enabled;
        return this;
    }

    public Response handle(Request request) throws Exception {
        jakarta.ws.rs.core.Response result;
        Invocation invocation;
        MultivaluedHashMap requestHeaders = new MultivaluedHashMap();
        for (Map.Entry entry : request.getHeaders().entries()) {
            requestHeaders.add((Object)((String)entry.getKey()), entry.getValue());
        }
        Invocation.Builder invocationBuilder = this.client.target(request.getUri()).request().headers((MultivaluedMap)requestHeaders);
        if (request.getBodyGenerator() == null) {
            invocation = invocationBuilder.build(request.getMethod());
        } else {
            byte[] byArray;
            BodyGenerator bodyGenerator = request.getBodyGenerator();
            Objects.requireNonNull(bodyGenerator);
            BodyGenerator bodyGenerator2 = bodyGenerator;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StaticBodyGenerator.class, ByteBufferBodyGenerator.class, FileBodyGenerator.class, StreamingBodyGenerator.class}, (Object)bodyGenerator2, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    byte[] byArray2;
                    StaticBodyGenerator generator = (StaticBodyGenerator)bodyGenerator2;
                    byArray = byArray2 = generator.getBody();
                    break;
                }
                case 1: {
                    byte[] byArray2;
                    ByteBufferBodyGenerator generator = (ByteBufferBodyGenerator)bodyGenerator2;
                    byArray = byArray2 = JaxrsTestingHttpProcessor.getBytes(generator.getByteBuffers());
                    break;
                }
                case 2: {
                    byte[] byArray2;
                    FileBodyGenerator generator = (FileBodyGenerator)bodyGenerator2;
                    byArray = byArray2 = Files.readAllBytes(generator.getPath());
                    break;
                }
                case 3: {
                    byte[] byArray2;
                    StreamingBodyGenerator generator = (StreamingBodyGenerator)bodyGenerator2;
                    try (InputStream stream = generator.source();){
                        byArray2 = stream.readAllBytes();
                        byArray = byArray2;
                        break;
                    }
                }
            }
            byte[] bytes = byArray;
            Entity entity = Entity.entity((Object)bytes, (String)((String)((List)requestHeaders.get((Object)"Content-Type")).stream().collect(MoreCollectors.onlyElement())));
            invocation = invocationBuilder.build(request.getMethod(), entity);
        }
        try {
            result = (jakarta.ws.rs.core.Response)invocation.invoke(jakarta.ws.rs.core.Response.class);
        }
        catch (ProcessingException exception) {
            if (this.trace) {
                log.warn(exception.getCause(), "%-8s %s -> Exception", new Object[]{request.getMethod(), request.getUri()});
            }
            if (exception.getCause() instanceof Exception) {
                throw (Exception)exception.getCause();
            }
            throw exception;
        }
        catch (Throwable throwable) {
            if (this.trace) {
                log.warn(throwable, "%-8s %s -> Fail", new Object[]{request.getMethod(), request.getUri()});
            }
            throw throwable;
        }
        ImmutableListMultimap.Builder responseHeaders = ImmutableListMultimap.builder();
        for (Map.Entry headerEntry : result.getStringHeaders().entrySet()) {
            for (String value : (List)headerEntry.getValue()) {
                responseHeaders.put((Object)((String)headerEntry.getKey()), (Object)value);
            }
        }
        if (this.trace) {
            log.warn("%-8s %s -> OK", new Object[]{request.getMethod(), request.getUri()});
        }
        return new TestingResponse(HttpStatus.fromStatusCode((int)result.getStatus()), (ListMultimap)responseHeaders.build(), (byte[])result.readEntity(byte[].class));
    }

    private static byte[] getBytes(ByteBuffer[] byteBuffers) throws Exception {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (ByteBuffer byteBuffer : byteBuffers) {
                int savedPosition = byteBuffer.position();
                while (byteBuffer.hasRemaining()) {
                    out.write(byteBuffer.get());
                }
                byteBuffer.position(savedPosition);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }
}

