/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.http.server.TheServlet;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsResource;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.ParsingExceptionMapper;
import io.airlift.jaxrs.SmileMapper;
import io.airlift.jaxrs.tracing.JaxrsTracingModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.Servlet;
import javax.ws.rs.core.Application;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.glassfish.jersey.servlet.ServletContainer;

public class JaxrsModule
extends AbstractConfigurationAwareModule {
    public JaxrsModule() {
    }

    @Deprecated
    public JaxrsModule(boolean requireExplicitBindings) {
        Preconditions.checkArgument((boolean)requireExplicitBindings, (Object)"non-explicit bindings are no longer supported");
    }

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(Application.class).to(JaxRsApplication.class).in(Scopes.SINGLETON);
        binder.bind(Servlet.class).annotatedWith(TheServlet.class).to(Key.get(ServletContainer.class));
        JaxrsBinder.jaxrsBinder(binder).bind(JsonMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(SmileMapper.class);
        JaxrsBinder.jaxrsBinder(binder).bind(ParsingExceptionMapper.class);
        Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
        if (this.getProperty("tracing.enabled").map(Boolean::parseBoolean).orElse(false).booleanValue()) {
            this.install(new JaxrsTracingModule());
        }
    }

    @Provides
    public static ServletContainer createServletContainer(ResourceConfig resourceConfig) {
        return new ServletContainer(resourceConfig);
    }

    @Provides
    public static ResourceConfig createResourceConfig(Application application, @JaxrsResource Set<Object> jaxRsSingletons) {
        ResourceConfig resourceConfig = ResourceConfig.forApplication((Application)application);
        jaxRsSingletons.stream().flatMap(o -> JaxrsModule.asProgrammaticResource(o).stream()).forEach(xva$0 -> resourceConfig.registerResources(new Resource[]{xva$0}));
        return resourceConfig;
    }

    @Provides
    @TheServlet
    public static Map<String, String> createTheServletParams() {
        return new HashMap<String, String>();
    }

    private static Optional<Resource> asProgrammaticResource(Object o) {
        if (o instanceof Resource) {
            return Optional.of((Resource)o);
        }
        return Optional.empty();
    }

    public static class JaxRsApplication
    extends Application {
        private final Set<Object> jaxRsSingletons;

        @Inject
        public JaxRsApplication(@JaxrsResource Set<Object> jaxRsSingletons) {
            this.jaxRsSingletons = (Set)jaxRsSingletons.stream().filter(o -> JaxrsModule.asProgrammaticResource(o).isEmpty()).collect(ImmutableSet.toImmutableSet());
        }

        public Set<Object> getSingletons() {
            return this.jaxRsSingletons;
        }
    }
}

