/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.tracing;

import com.google.common.base.Strings;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import org.glassfish.jersey.server.ContainerRequest;

@Priority(value=0)
public final class TracingFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    static final String REMOTE_ADDRESS = "airlift.remote-address";
    static final String REQUEST_SCOPE = "airlift.trace-scope";
    static final String REQUEST_SPAN = "airlift.trace-span";
    private final TextMapPropagator propagator;
    private final Tracer tracer;
    private final String className;
    private final String methodName;

    public TracingFilter(OpenTelemetry openTelemetry, Tracer tracer, String className, String methodName) {
        this.propagator = openTelemetry.getPropagators().getTextMapPropagator();
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
        this.className = Objects.requireNonNull(className, "className is null");
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
    }

    public void filter(ContainerRequestContext requestContext) {
        String userAgent;
        String remoteAddress;
        int port;
        Context parent = this.propagator.extract(Context.root(), (Object)requestContext, (TextMapGetter)JaxrsTextMapGetter.INSTANCE);
        ContainerRequest request = (ContainerRequest)requestContext.getRequest();
        String method = request.getMethod().toUpperCase(Locale.ENGLISH);
        URI uri = request.getRequestUri();
        String route = request.getUriInfo().getMatchedTemplates().stream().map(template -> TracingFilter.normalizePath(template.getTemplate())).reduce((first, second) -> second + first).orElseThrow();
        SpanBuilder spanBuilder = this.tracer.spanBuilder(method + " " + route).setParent(parent).setSpanKind(SpanKind.SERVER).setAttribute(SemanticAttributes.HTTP_METHOD, (Object)method).setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)route).setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)uri.getScheme()).setAttribute(SemanticAttributes.NET_HOST_NAME, (Object)uri.getHost()).setAttribute(SemanticAttributes.CODE_NAMESPACE, (Object)this.className).setAttribute(SemanticAttributes.CODE_FUNCTION, (Object)this.methodName);
        String target = TracingFilter.getTarget(uri);
        if (!Strings.isNullOrEmpty((String)target)) {
            spanBuilder.setAttribute(SemanticAttributes.HTTP_TARGET, (Object)target);
        }
        if ((port = TracingFilter.getPort(uri)) > 0) {
            spanBuilder.setAttribute(SemanticAttributes.NET_HOST_PORT, (Object)port);
        }
        if (!Strings.isNullOrEmpty((String)(remoteAddress = (String)request.getProperty(REMOTE_ADDRESS)))) {
            spanBuilder.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)remoteAddress);
        }
        if (!Strings.isNullOrEmpty((String)(userAgent = request.getHeaderString("User-Agent")))) {
            spanBuilder.setAttribute(SemanticAttributes.USER_AGENT_ORIGINAL, (Object)userAgent);
        }
        if (request.hasEntity() && request.getLength() >= 0) {
            spanBuilder.setAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)request.getLength());
        }
        Span span = spanBuilder.startSpan();
        requestContext.setProperty(REQUEST_SPAN, (Object)span);
        requestContext.setProperty(REQUEST_SCOPE, (Object)span.makeCurrent());
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        Scope scope = (Scope)request.getProperty(REQUEST_SCOPE);
        Span span = (Span)request.getProperty(REQUEST_SPAN);
        try (Scope scope2 = scope;){
            if (response.getStatus() != -1) {
                span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, response.getStatus());
            }
            if (response.hasEntity() && response.getLength() != -1) {
                span.setAttribute(SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, response.getLength());
            }
        }
        span.end();
    }

    private static String normalizePath(String path) {
        if (Strings.isNullOrEmpty((String)path) || ((String)path).equals("/")) {
            return "";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }

    private static String getTarget(URI uri) {
        Object target = Strings.nullToEmpty((String)uri.getRawPath());
        if (uri.getRawQuery() != null) {
            target = (String)target + "?" + uri.getRawQuery();
        }
        return target;
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port > 0) {
            return port;
        }
        return switch (Strings.nullToEmpty((String)uri.getScheme()).toLowerCase(Locale.ENGLISH)) {
            case "http" -> 80;
            case "https" -> 443;
            default -> -1;
        };
    }

    private static class JaxrsTextMapGetter
    implements TextMapGetter<ContainerRequestContext> {
        public static final JaxrsTextMapGetter INSTANCE = new JaxrsTextMapGetter();

        private JaxrsTextMapGetter() {
        }

        public Iterable<String> keys(ContainerRequestContext request) {
            return request.getHeaders().keySet();
        }

        public String get(ContainerRequestContext request, String key) {
            return (String)Objects.requireNonNull(request).getHeaders().getFirst((Object)key);
        }
    }
}

