/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.airlift.jaxrs.JsonMapperParsingException;
import io.airlift.log.Logger;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

abstract class AbstractJacksonMapper
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Set<Class<?>> IO_CLASSES = ImmutableSet.builder().add(InputStream.class).add(OutputStream.class).add(Reader.class).add(Writer.class).add(byte[].class).add(char[].class).add(StreamingOutput.class).add(Response.class).build();
    protected final Logger log = Logger.get(this.getClass());
    protected final ObjectMapper objectMapper;

    protected AbstractJacksonMapper(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper is null");
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return AbstractJacksonMapper.canReadOrWrite(type);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return AbstractJacksonMapper.canReadOrWrite(type);
    }

    private static boolean canReadOrWrite(Class<?> type) {
        if (IO_CLASSES.contains(type)) {
            return false;
        }
        for (Class<?> ioClass : IO_CLASSES) {
            if (!ioClass.isAssignableFrom(type)) continue;
            return false;
        }
        return true;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream inputStream) throws IOException {
        try {
            JsonParser jsonParser = this.getReaderJsonFactory().createParser(inputStream);
            jsonParser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            return this.objectMapper.readValue(jsonParser, this.objectMapper.getTypeFactory().constructType(genericType));
        }
        catch (Exception e) {
            if (e instanceof IOException && !(e instanceof JsonProcessingException) && !(e instanceof EOFException)) {
                throw e;
            }
            this.log.debug((Throwable)e, "Invalid JSON for Java type: %s", new Object[]{type});
            throw new JsonMapperParsingException(type, (Throwable)e);
        }
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    protected abstract JsonFactory getReaderJsonFactory();

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream outputStream) throws IOException {
        JavaType rootType = null;
        if (genericType != null && value != null && genericType.getClass() != Class.class && (rootType = this.objectMapper.getTypeFactory().constructType(genericType)).getRawClass() == Object.class) {
            rootType = null;
        }
        this.write(value, Optional.ofNullable(rootType), httpHeaders, outputStream);
    }

    protected abstract void write(Object var1, Optional<JavaType> var2, MultivaluedMap<String, Object> var3, OutputStream var4) throws IOException;
}

