/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs.tracing;

import com.google.common.base.Strings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.semconv.HttpAttributes;
import io.opentelemetry.semconv.incubating.CodeIncubatingAttributes;
import jakarta.annotation.Priority;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import java.util.Objects;
import org.glassfish.jersey.server.ContainerRequest;

@Priority(value=0)
public final class TracingFilter
implements ContainerRequestFilter {
    static final String REQUEST_SPAN = "airlift.trace-span";
    private final String className;
    private final String methodName;

    public TracingFilter(String className, String methodName) {
        this.className = Objects.requireNonNull(className, "className is null");
        this.methodName = Objects.requireNonNull(methodName, "methodName is null");
    }

    public void filter(ContainerRequestContext requestContext) {
        ContainerRequest request = (ContainerRequest)requestContext.getRequest();
        if (request == null) {
            return;
        }
        String route = request.getUriInfo().getMatchedTemplates().stream().map(template -> TracingFilter.normalizePath(template.getTemplate())).reduce((first, second) -> second + first).orElseThrow();
        Object object = requestContext.getProperty(REQUEST_SPAN);
        if (object instanceof Span) {
            Span span = (Span)object;
            span.updateName(requestContext.getMethod() + " " + route);
            span.setAttribute(HttpAttributes.HTTP_ROUTE, (Object)route);
            span.setAttribute(CodeIncubatingAttributes.CODE_FUNCTION_NAME, (Object)(this.className + "." + this.methodName));
        }
    }

    private static String normalizePath(String path) {
        if (Strings.isNullOrEmpty((String)path) || ((String)path).equals("/")) {
            return "";
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        return path;
    }
}

