/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.jaxrs.JaxrsResource;
import io.airlift.jaxrs.JsonParsingFeature;
import java.util.Objects;

public class JaxrsBinder {
    private final Multibinder<Object> resourceBinder;
    private final Binder binder;

    private JaxrsBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.resourceBinder = Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
    }

    public static JaxrsBinder jaxrsBinder(Binder binder) {
        return new JaxrsBinder(binder);
    }

    public void bind(Class<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public void bind(TypeLiteral<?> implementation) {
        this.binder.bind(implementation).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public void bind(Key<?> targetKey) {
        this.binder.bind(targetKey).in(Scopes.SINGLETON);
        this.resourceBinder.addBinding().to(targetKey).in(Scopes.SINGLETON);
    }

    public JaxrsBinder disableJsonExceptionMapper() {
        OptionalBinder.newOptionalBinder((Binder)this.binder, JsonParsingFeature.MappingEnabled.class).setBinding().toInstance((Object)JsonParsingFeature.MappingEnabled.DISABLED);
        return this;
    }

    public void bindInstance(Object instance) {
        this.resourceBinder.addBinding().toInstance(instance);
    }
}

