/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsResource;
import io.airlift.jaxrs.JaxrsResourceConfig;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.JsonParsingFeature;
import io.airlift.jaxrs.tracing.JaxrsTracingModule;
import jakarta.servlet.Servlet;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;

public class JaxrsModule
extends AbstractConfigurationAwareModule {
    public JaxrsModule() {
    }

    @Deprecated
    public JaxrsModule(boolean requireExplicitBindings) {
        Preconditions.checkArgument((boolean)requireExplicitBindings, (Object)"non-explicit bindings are no longer supported");
    }

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(Servlet.class).to(Key.get(ServletContainer.class));
        Multibinder.newSetBinder((Binder)binder, Object.class, JaxrsResource.class).permitDuplicates();
        JaxrsBinder jaxrsBinder = JaxrsBinder.jaxrsBinder(binder);
        jaxrsBinder.bind(JsonMapper.class);
        jaxrsBinder.bind(JsonParsingFeature.class);
        OptionalBinder.newOptionalBinder((Binder)binder, JsonParsingFeature.MappingEnabled.class).setDefault().toInstance((Object)JsonParsingFeature.MappingEnabled.ENABLED);
        if (this.getProperty("tracing.enabled").map(Boolean::parseBoolean).orElse(false).booleanValue()) {
            this.install(new JaxrsTracingModule());
        }
    }

    @Provides
    public static ServletContainer createServletContainer(ResourceConfig resourceConfig) {
        return new ServletContainer(resourceConfig);
    }

    @Provides
    public static ResourceConfig createResourceConfig(@JaxrsResource Set<Object> jaxRsSingletons) {
        return new JaxrsResourceConfig(jaxRsSingletons).setProperties((Map)ImmutableMap.of((Object)"jersey.config.server.response.setStatusOverSendError", (Object)"true"));
    }
}

