/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.base.CharMatcher;
import com.google.common.base.Verify;
import io.airlift.json.JsonCodec;
import java.util.Objects;

public record JsonError(String code, String message) {
    private static final CharMatcher MATCHER = CharMatcher.inRange((char)'A', (char)'Z').or(CharMatcher.is((char)'_')).precomputed();

    public JsonError {
        Verify.verify((boolean)MATCHER.matchesAllOf((CharSequence)code), (String)"Error code must only contain uppercase letters and underscores: %s", (Object)code);
        Objects.requireNonNull(code, "code is null");
        Objects.requireNonNull(message, "message is null");
    }

    public static JsonCodec<JsonError> codec() {
        return JsonCodec.jsonCodec(JsonError.class);
    }
}

