/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.jaxrs.BinderUtils;
import io.airlift.jaxrs.JsonParsingFeature;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.Optional;

public class JaxrsBinder {
    private final Multibinder<Object> resourceBinder;
    private final Optional<Class<? extends Annotation>> qualifier;
    private final Binder binder;

    private JaxrsBinder(Binder binder, Optional<Class<? extends Annotation>> qualifier) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.qualifier = Objects.requireNonNull(qualifier, "qualifier is null");
        this.resourceBinder = Multibinder.newSetBinder((Binder)binder, BinderUtils.qualifiedKey(qualifier, Object.class)).permitDuplicates();
    }

    public static JaxrsBinder jaxrsBinder(Binder binder) {
        return JaxrsBinder.jaxrsBinder(binder, Optional.empty());
    }

    public static JaxrsBinder jaxrsBinder(Binder binder, Class<? extends Annotation> qualifier) {
        return JaxrsBinder.jaxrsBinder(binder, Optional.ofNullable(qualifier));
    }

    static JaxrsBinder jaxrsBinder(Binder binder, Optional<Class<? extends Annotation>> qualifier) {
        return new JaxrsBinder(binder, qualifier);
    }

    public <T> void bind(Class<T> implementation) {
        if (this.qualifier.isPresent()) {
            this.binder.bind(implementation).annotatedWith(this.qualifier.get()).to(implementation).in(Scopes.SINGLETON);
        } else {
            this.binder.bind(implementation).in(Scopes.SINGLETON);
        }
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public <T> void bind(Class<T> implementation, Provider<T> provider) {
        if (this.qualifier.isPresent()) {
            this.binder.bind(implementation).annotatedWith(this.qualifier.get()).toProvider(provider).in(Scopes.SINGLETON);
        } else {
            this.binder.bind(implementation).toProvider(provider).in(Scopes.SINGLETON);
        }
        this.resourceBinder.addBinding().toProvider(provider).in(Scopes.SINGLETON);
    }

    public <T> void bind(TypeLiteral<T> implementation) {
        OptionalBinder.newOptionalBinder((Binder)this.binder, implementation).setBinding().to(implementation);
        this.resourceBinder.addBinding().to(implementation).in(Scopes.SINGLETON);
    }

    public void bindInstance(Object instance) {
        this.resourceBinder.addBinding().toInstance(instance);
    }

    public JaxrsBinder disableJsonExceptionMapper() {
        OptionalBinder.newOptionalBinder((Binder)this.binder, BinderUtils.qualifiedKey(this.qualifier, JsonParsingFeature.MappingEnabled.class)).setBinding().toInstance((Object)JsonParsingFeature.MappingEnabled.DISABLED);
        return this;
    }
}

