/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.jaxrs.BinderUtils;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.jaxrs.JaxrsResourceConfigProvider;
import io.airlift.jaxrs.JaxrsServletProvider;
import io.airlift.jaxrs.JsonMapper;
import io.airlift.jaxrs.JsonParsingFeature;
import io.airlift.jaxrs.tracing.TracingDynamicFeature;
import jakarta.annotation.Nullable;
import jakarta.servlet.Servlet;
import java.lang.annotation.Annotation;
import java.util.Optional;
import org.glassfish.jersey.server.ResourceConfig;

public class JaxrsModule
extends AbstractConfigurationAwareModule {
    private final Optional<Class<? extends Annotation>> qualifier;

    public JaxrsModule() {
        this(null);
    }

    public JaxrsModule(@Nullable Class<? extends Annotation> qualifier) {
        this.qualifier = Optional.ofNullable(qualifier);
    }

    protected void setup(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(BinderUtils.qualifiedKey(this.qualifier, Servlet.class)).toProvider((Provider)new JaxrsServletProvider(this.qualifier));
        binder.bind(BinderUtils.qualifiedKey(this.qualifier, ResourceConfig.class)).toProvider((Provider)new JaxrsResourceConfigProvider(this.qualifier));
        Multibinder.newSetBinder((Binder)binder, BinderUtils.qualifiedKey(this.qualifier, Object.class)).permitDuplicates();
        JaxrsBinder jaxrsBinder = JaxrsBinder.jaxrsBinder(binder, this.qualifier);
        jaxrsBinder.bind(JsonMapper.class);
        jaxrsBinder.bind(JsonParsingFeature.class, new JsonParsingFeature.Provider(this.qualifier));
        OptionalBinder.newOptionalBinder((Binder)binder, BinderUtils.qualifiedKey(this.qualifier, JsonParsingFeature.MappingEnabled.class)).setDefault().toInstance((Object)JsonParsingFeature.MappingEnabled.ENABLED);
        if (this.getProperty("tracing.enabled").map(Boolean::parseBoolean).orElse(false).booleanValue()) {
            jaxrsBinder.bind(TracingDynamicFeature.class);
        }
    }
}

