/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;
import org.glassfish.jersey.inject.hk2.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;

public class JaxrsResourceConfig
extends ResourceConfig {
    public JaxrsResourceConfig(Set<Object> singletons) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Object singleton : singletons) {
            Class<?> clazz = singleton.getClass();
            if (singleton instanceof Class) {
                Class clazzInstance = (Class)singleton;
                this.register(clazzInstance);
                continue;
            }
            if (Providers.isProvider(clazz) || Binder.class.isAssignableFrom(clazz)) {
                this.register(singleton);
                continue;
            }
            if (singleton instanceof Resource) {
                Resource resource = (Resource)singleton;
                this.registerResources(new Resource[]{resource});
                continue;
            }
            builder.put(clazz, singleton);
        }
        ImmutableMap classToInstance = builder.buildOrThrow();
        this.registerClasses(classToInstance.keySet());
        this.register((Object)new SingletonsBinderBridge((Map<Class<?>, Object>)classToInstance));
    }

    private static class SingletonsBinderBridge
    extends AbstractBinder {
        private final Map<Class<?>, Object> singletons;

        public SingletonsBinderBridge(Map<Class<?>, Object> singletons) {
            this.singletons = ImmutableMap.copyOf(singletons);
        }

        public void configure() {
            for (Map.Entry<Class<?>, Object> singleton : this.singletons.entrySet()) {
                this.bind(singleton.getValue()).to((Type)singleton.getKey());
            }
        }
    }
}

