/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jaxrs;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import io.airlift.jaxrs.BinderUtils;
import io.airlift.jaxrs.JaxrsResourceConfig;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.glassfish.jersey.server.ResourceConfig;

public class JaxrsResourceConfigProvider
implements Provider<ResourceConfig> {
    private final Optional<Class<? extends Annotation>> qualifier;
    private Injector injector;

    public JaxrsResourceConfigProvider(Optional<Class<? extends Annotation>> qualifier) {
        this.qualifier = Objects.requireNonNull(qualifier, "resourcesQualifier is null");
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = Objects.requireNonNull(injector, "injector is null");
    }

    public ResourceConfig get() {
        Set singletons = (Set)this.injector.getInstance(BinderUtils.qualifiedKey(this.qualifier, new TypeLiteral<Set<Object>>(this){}));
        return new JaxrsResourceConfig(singletons).setProperties((Map)ImmutableMap.of((Object)"jersey.config.server.response.setStatusOverSendError", (Object)"true", (Object)"jersey.config.contentLength.buffer", (Object)"0"));
    }
}

