/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.memory.jetty;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.function.IntUnaryOperator;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import sun.misc.Unsafe;

public class UnsafeArrayByteBufferPool
extends ArrayByteBufferPool {
    private static final Unsafe UNSAFE;
    private static final MethodHandle INVOKE_CLEANER;

    public static boolean isUnsafeAvailable() {
        return INVOKE_CLEANER != null;
    }

    public UnsafeArrayByteBufferPool(int minCapacity, int factor, int maxCapacity, int maxBucketSize, long maxHeapMemory, long maxDirectMemory, IntUnaryOperator bucketIndexFor, IntUnaryOperator bucketCapacity) {
        super(minCapacity, factor, maxCapacity, maxBucketSize, maxHeapMemory, maxDirectMemory, bucketIndexFor, bucketCapacity);
    }

    public boolean removeAndRelease(RetainableByteBuffer buffer) {
        boolean released = super.removeAndRelease(buffer);
        RetainableByteBuffer actual = buffer;
        while (actual instanceof RetainableByteBuffer.Wrapper) {
            RetainableByteBuffer.Wrapper wrapper = (RetainableByteBuffer.Wrapper)actual;
            actual = wrapper.getWrapped();
        }
        if (actual.isDirect()) {
            try {
                INVOKE_CLEANER.invoke(UNSAFE, actual.getByteBuffer());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return released;
    }

    static {
        MethodHandle invokeCleaner;
        Unsafe unsafeInstance;
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafeInstance = (Unsafe)field.get(null);
            if (unsafeInstance == null) {
                throw new IllegalAccessException("Unsafe access not available");
            }
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodType methodType = MethodType.methodType(Void.TYPE, ByteBuffer.class);
            invokeCleaner = lookup.findVirtual(unsafeInstance.getClass(), "invokeCleaner", methodType);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException ignored) {
            invokeCleaner = null;
            unsafeInstance = null;
        }
        INVOKE_CLEANER = invokeCleaner;
        UNSAFE = unsafeInstance;
    }

    public static class Quadratic
    extends UnsafeArrayByteBufferPool {
        public Quadratic() {
            this(0, -1, Integer.MAX_VALUE);
        }

        public Quadratic(int minCapacity, int maxCapacity, int maxBucketSize) {
            this(minCapacity, maxCapacity, maxBucketSize, -1L, -1L);
        }

        public Quadratic(int minCapacity, int maxCapacity, int maxBucketSize, long maxHeapMemory, long maxDirectMemory) {
            super(minCapacity, -1, maxCapacity, maxBucketSize, maxHeapMemory, maxDirectMemory, c -> 32 - Integer.numberOfLeadingZeros(c - 1), i -> 1 << i);
        }
    }
}

