/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import io.airlift.jmx.JmxAgent;
import io.airlift.jmx.JmxConfig;
import io.airlift.jmx.NetUtils;
import io.airlift.log.Logger;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.Properties;
import javax.inject.Inject;
import javax.management.remote.JMXServiceURL;

class JmxAgent9
implements JmxAgent {
    private static final Logger log = Logger.get(JmxAgent.class);
    private final JMXServiceURL url;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public JmxAgent9(JmxConfig config) throws IOException {
        HostAndPort address;
        int registryPort = config.getRmiRegistryPort() == null ? NetUtils.findUnusedPort() : config.getRmiRegistryPort();
        int serverPort = 0;
        if (config.getRmiServerPort() != null) {
            serverPort = config.getRmiServerPort();
        }
        try {
            VirtualMachine virtualMachine = VirtualMachine.attach(Long.toString(JmxAgent9.getProcessId()));
            try {
                virtualMachine.startLocalManagementAgent();
                Properties properties = new Properties();
                properties.setProperty("com.sun.management.jmxremote.port", Integer.toString(registryPort));
                properties.setProperty("com.sun.management.jmxremote.rmi.port", Integer.toString(serverPort));
                properties.setProperty("com.sun.management.jmxremote.authenticate", "false");
                properties.setProperty("com.sun.management.jmxremote.ssl", "false");
                virtualMachine.startManagementAgent(properties);
            }
            finally {
                virtualMachine.detach();
            }
        }
        catch (AttachNotSupportedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", null, registryPort);
            address = HostAndPort.fromParts((String)url.getHost(), (int)url.getPort());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
        log.info("JMX agent started and listening on %s", new Object[]{address});
        this.url = new JMXServiceURL(String.format("service:jmx:rmi:///jndi/rmi://%s:%s/jmxrmi", address.getHostText(), address.getPort()));
    }

    @Override
    public JMXServiceURL getUrl() {
        return this.url;
    }

    private static long getProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf(64);
        if (index < 1) {
            throw new AssertionError((Object)"Cannot get process PID");
        }
        try {
            return Long.parseLong(name.substring(0, index));
        }
        catch (NumberFormatException e) {
            throw new AssertionError((Object)"Cannot get process PID");
        }
    }

    public static void main(String[] args) throws IOException {
        new JmxAgent9(new JmxConfig());
        new JmxAgent9(new JmxConfig());
    }
}

