/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.jmx;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Injector;
import io.airlift.jmx.GuiceInjectorIterator;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.inject.Inject;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import org.weakref.jmx.Managed;

public class JmxInspector
implements Iterable<InspectorRecord> {
    private final ImmutableSortedSet<InspectorRecord> inspectorRecords;

    @Inject
    public JmxInspector(Injector injector) throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectInstance> instances = mBeanServer.queryMBeans(null, null);
        ArrayListMultimap nameMap = ArrayListMultimap.create();
        for (ObjectInstance i : instances) {
            nameMap.put((Object)i.getClassName(), (Object)i.getObjectName().getCanonicalName());
        }
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        GuiceInjectorIterator injectorIterator = new GuiceInjectorIterator(injector);
        for (Class<?> clazz : injectorIterator) {
            this.addConfig((Multimap<String, String>)nameMap, clazz, (ImmutableSortedSet.Builder<InspectorRecord>)builder);
        }
        this.inspectorRecords = builder.build();
    }

    @Override
    public Iterator<InspectorRecord> iterator() {
        return Iterators.unmodifiableIterator((UnmodifiableIterator)this.inspectorRecords.iterator());
    }

    private void addConfig(Multimap<String, String> nameMap, Class<?> clazz, ImmutableSortedSet.Builder<InspectorRecord> builder) throws InvocationTargetException, IllegalAccessException {
        Collection thisNameList = nameMap.get((Object)clazz.getName());
        if (thisNameList != null) {
            for (Method method : clazz.getMethods()) {
                Managed configAnnotation = method.getAnnotation(Managed.class);
                if (configAnnotation == null) continue;
                for (String thisName : thisNameList) {
                    builder.add((Object)new InspectorRecord(thisName, method.getName(), configAnnotation.description(), this.getType(method)));
                }
            }
        }
    }

    private Types getType(Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return Types.ACTION;
        }
        if (method.getParameterTypes().length > 0) {
            return Types.ACTION;
        }
        return Types.ATTRIBUTE;
    }

    public static class InspectorRecord
    implements Comparable<InspectorRecord> {
        public final String className;
        public final String objectName;
        public final String description;
        public final Types type;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InspectorRecord that = (InspectorRecord)o;
            if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
                return false;
            }
            return !(this.objectName != null ? !this.objectName.equals(that.objectName) : that.objectName != null);
        }

        public int hashCode() {
            return this.className.hashCode();
        }

        @Override
        public int compareTo(InspectorRecord rhs) {
            int diff = this.objectName.compareTo(rhs.objectName);
            return diff != 0 ? diff : this.className.compareTo(rhs.className);
        }

        private InspectorRecord(String className, String objectName, String description, Types type) {
            this.className = className;
            this.objectName = objectName;
            this.description = description;
            this.type = type;
        }
    }

    public static enum Types {
        ATTRIBUTE,
        ACTION;

    }
}

