/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.log.JsonRecord;
import io.airlift.log.Level;
import io.opentelemetry.context.Context;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class JsonFormatter
extends Formatter {
    private static final JsonCodec<JsonRecord> CODEC = new JsonCodecFactory((Provider)new ObjectMapperProvider()).jsonCodec(JsonRecord.class);
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final Map<String, String> logAnnotations;

    public JsonFormatter(Map<String, String> logAnnotations) {
        this.logAnnotations = ImmutableMap.copyOf(Objects.requireNonNull(logAnnotations, "logAnnotations is null"));
    }

    @Override
    public String format(LogRecord record) {
        JsonRecord jsonRecord = new JsonRecord(record.getInstant(), Level.fromJulLevel(record.getLevel()), Thread.currentThread().getName(), record.getLoggerName(), record.getMessage(), record.getThrown(), Context.current(), this.logAnnotations);
        try {
            return JsonFormatter.toString(jsonRecord);
        }
        catch (IllegalArgumentException outer) {
            try {
                return JsonFormatter.toString(new JsonRecord(record.getInstant(), Level.fromJulLevel(record.getLevel()), Thread.currentThread().getName(), record.getLoggerName(), outer.getMessage(), outer, Context.current(), this.logAnnotations));
            }
            catch (IllegalArgumentException inner) {
                inner.addSuppressed(outer);
                return this.minimalJsonErrorLogLine(jsonRecord, inner);
            }
        }
    }

    @VisibleForTesting
    String minimalJsonErrorLogLine(JsonRecord jsonRecord, Exception exception) {
        StringWriter stringWriter = new StringWriter();
        try (JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);){
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("timestamp", jsonRecord.getTimestamp().toString());
            jsonGenerator.writeStringField("message", exception.getMessage());
            jsonGenerator.writeStringField("level", Level.ERROR.name());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            e.addSuppressed(exception);
            throw new RuntimeException("Unable to generate json logs", e);
        }
        return stringWriter.append("\n").toString();
    }

    private static String toString(JsonRecord jsonRecord) {
        return CODEC.toJson((Object)jsonRecord) + "\n";
    }
}

