/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.log;

import io.airlift.log.Level;
import java.io.Console;
import java.io.PrintWriter;

public class TerminalColors {
    private static final boolean isColorSupported = TerminalColors.isColorSupported();
    private static final String ANSI_RESET = "\u001b[0m";
    private final boolean interactive;

    public TerminalColors(boolean interactive) {
        this.interactive = interactive;
    }

    public String colored(String text, Color color) {
        if (!isColorSupported) {
            return text;
        }
        if (!this.interactive) {
            return text;
        }
        return color.getCode() + text + ANSI_RESET;
    }

    public String colored(String text, Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case Level.OFF -> text;
            case Level.TRACE -> this.colored(text, Color.WHITE);
            case Level.DEBUG -> this.colored(text, Color.BLUE);
            case Level.INFO -> this.colored(text, Color.GREEN);
            case Level.WARN -> this.colored(text, Color.YELLOW);
            case Level.ERROR -> this.colored(text, Color.RED);
        };
    }

    public static PrintWriter coloredWriter(final PrintWriter writer, final Color color) {
        return new PrintWriter(writer){

            @Override
            public void write(char[] buffer, int off, int len) {
                writer.write(color.getCode());
                writer.write(buffer, off, len);
                writer.write(TerminalColors.ANSI_RESET);
            }

            @Override
            public void flush() {
                writer.flush();
            }

            @Override
            public void close() {
                writer.close();
            }
        };
    }

    private static boolean isColorSupported() {
        Console console = System.console();
        if (console == null && Runtime.version().feature() < 25) {
            return false;
        }
        String term = System.getenv("TERM");
        if (term == null) {
            return false;
        }
        if (term.equalsIgnoreCase("dumb")) {
            return false;
        }
        return System.getenv("NO_COLOR") == null;
    }

    public static enum Color {
        WHITE("\u001b[37m"),
        RED("\u001b[31m"),
        GREEN("\u001b[32m"),
        YELLOW("\u001b[33m"),
        BLUE("\u001b[34m"),
        PURPLE("\u001b[35m"),
        CYAN("\u001b[36m"),
        BRIGHT_BLACK("\u001b[90m");

        private final String code;

        private Color(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

