/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node;

import com.google.common.net.InetAddresses;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Optional;

public final class AddressToHostname {
    private static final String IP_ENCODED_SUFFIX = ".ip";

    private AddressToHostname() {
    }

    public static String encodeAddressAsHostname(InetAddress inetAddress) {
        Object ipString = InetAddresses.toAddrString((InetAddress)inetAddress);
        ipString = inetAddress instanceof Inet4Address ? ((String)ipString).replace('.', '-') : "x" + ((String)ipString).replace(':', '-');
        return (String)ipString + IP_ENCODED_SUFFIX;
    }

    public static Optional<InetAddress> tryDecodeHostnameToAddress(String hostname) {
        if (!hostname.endsWith(IP_ENCODED_SUFFIX)) {
            return Optional.empty();
        }
        String ipString = hostname.substring(0, hostname.length() - IP_ENCODED_SUFFIX.length());
        ipString = ipString.startsWith("x") ? ipString.substring(1).replace('-', ':') : ipString.replace('-', '.');
        byte[] address = InetAddresses.forString((String)ipString).getAddress();
        try {
            return Optional.of(InetAddress.getByAddress(hostname, address));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

