/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.node.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import io.airlift.node.NodeConfig;
import io.airlift.node.NodeInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.guice.ExportBinder;

public class TestingNodeModule
implements Module {
    private static final AtomicLong nextId = new AtomicLong(ThreadLocalRandom.current().nextInt(1000000));
    private final String environment;
    private final Optional<String> pool;
    private final boolean bindAll;

    public TestingNodeModule() {
        this(Optional.empty());
    }

    public TestingNodeModule(Optional<String> environment) {
        this(environment, false);
    }

    public TestingNodeModule(Optional<String> environment, boolean bindAll) {
        this(environment.orElse("test" + nextId.getAndIncrement()), bindAll);
    }

    public TestingNodeModule(String environment, boolean bindAll) {
        this(environment, Optional.empty(), bindAll);
    }

    public TestingNodeModule(String environment) {
        this(environment, Optional.empty());
    }

    public TestingNodeModule(String environment, Optional<String> pool) {
        this(environment, pool, false);
    }

    public TestingNodeModule(String environment, Optional<String> pool, boolean bindAll) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)environment) ? 1 : 0) != 0, (Object)"environment is null or empty");
        this.environment = environment;
        this.pool = Objects.requireNonNull(pool, "pool is null");
        this.bindAll = bindAll;
    }

    public TestingNodeModule(String environment, String pool) {
        this(environment, Optional.of(Objects.requireNonNull(pool, "pool is null")));
    }

    public void configure(Binder binder) {
        binder.bind(NodeInfo.class).in(Scopes.SINGLETON);
        NodeConfig nodeConfig = new NodeConfig().setEnvironment(this.environment).setNodeInternalAddress(InetAddresses.toAddrString((InetAddress)TestingNodeModule.getLocalhostBindIp(false))).setNodeBindIp(TestingNodeModule.getLocalhostBindIp(this.bindAll));
        if (this.pool.isPresent()) {
            nodeConfig.setPool(this.pool.get());
        }
        binder.bind(NodeConfig.class).toInstance((Object)nodeConfig);
        ExportBinder.newExporter((Binder)binder).export(NodeInfo.class).withGeneratedName();
    }

    private static InetAddress getLocalhostBindIp(boolean bindAll) {
        try {
            if (bindAll) {
                return InetAddress.getByName("0.0.0.0");
            }
            return InetAddress.getByAddress("localhost", new byte[]{127, 0, 0, 1});
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)"Could not create localhost address");
        }
    }
}

