/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics.types;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.openmetrics.types.Gauge;
import io.airlift.openmetrics.types.Metric;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;

public record CompositeMetric(String metricName, Map<String, String> labels, String help, List<Metric> subMetrics) implements Metric
{
    private static final Splitter SPLITTER = Splitter.on((char)'\n').omitEmptyStrings().trimResults().limit(3);

    public static CompositeMetric from(String metricName, Object value, Map<String, String> labels, String help) {
        Objects.requireNonNull(value, "value is null");
        ImmutableList.Builder subMetrics = ImmutableList.builder();
        CompositeMetric.extractMetrics(value, metricName, labels, help, (ImmutableList.Builder<Metric>)subMetrics);
        return new CompositeMetric(metricName, labels, help, (List<Metric>)subMetrics.build());
    }

    private static void extractMetrics(Object value, String prefix, Map<String, String> labels, String help, ImmutableList.Builder<Metric> metrics) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, Boolean.class, CompositeData.class, TabularData.class}, (Object)object2, n)) {
                case 0: {
                    Number number = (Number)object2;
                    metrics.add((Object)new Gauge(prefix, number.doubleValue(), labels, help));
                    break block6;
                }
                case 1: {
                    Boolean bool = (Boolean)object2;
                    metrics.add((Object)new Gauge(prefix, bool != false ? 1.0 : 0.0, labels, help));
                    break block6;
                }
                case 2: {
                    CompositeData compositeData = (CompositeData)object2;
                    CompositeType compositeType = compositeData.getCompositeType();
                    for (String itemName : compositeType.keySet()) {
                        CompositeMetric.extractMetrics(compositeData.get(itemName), prefix + "_" + itemName, labels, help, metrics);
                    }
                    break block6;
                }
                case 3: {
                    TabularData tabularData = (TabularData)object2;
                    if (tabularData.isEmpty()) {
                        n = 4;
                        continue block6;
                    }
                    TabularType tabularType = tabularData.getTabularType();
                    ImmutableSet indexNames = ImmutableSet.copyOf(tabularType.getIndexNames());
                    for (Object entry : tabularData.values()) {
                        if (!(entry instanceof CompositeData)) continue;
                        CompositeData compositeData = (CompositeData)entry;
                        HashMap<String, String> rowLabels = new HashMap<String, String>(labels);
                        for (String indexName : indexNames) {
                            if (!compositeData.containsKey(indexName)) continue;
                            rowLabels.put(indexName, compositeData.get(indexName).toString());
                        }
                        for (String itemName : Sets.difference(compositeData.getCompositeType().keySet(), (Set)indexNames)) {
                            CompositeMetric.extractMetrics(compositeData.get(itemName), prefix + "_" + itemName, rowLabels, help, metrics);
                        }
                    }
                    break block6;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(value));
                }
            }
            break;
        }
    }

    @Override
    public String getMetricExposition() {
        if (this.subMetrics.isEmpty()) {
            return "";
        }
        Map<String, List<Metric>> metricsByName = this.subMetrics.stream().collect(Collectors.groupingBy(Metric::metricName));
        StringBuilder exposition = new StringBuilder();
        for (Map.Entry<String, List<Metric>> entry : metricsByName.entrySet()) {
            List<Metric> metrics = entry.getValue();
            if (metrics.isEmpty()) continue;
            String typeLine = null;
            String helpLine = null;
            for (String line : SPLITTER.split((CharSequence)metrics.getFirst().getMetricExposition())) {
                if (line.startsWith("# TYPE")) {
                    typeLine = line;
                    continue;
                }
                if (!line.startsWith("# HELP")) continue;
                helpLine = line;
            }
            if (typeLine != null) {
                exposition.append(typeLine).append('\n');
            }
            if (helpLine != null) {
                exposition.append(helpLine).append('\n');
            }
            for (Metric metric : metrics) {
                for (String line : SPLITTER.split((CharSequence)metric.getMetricExposition())) {
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    exposition.append(line).append('\n');
                }
            }
        }
        return exposition.toString();
    }
}

