/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.openmetrics.types;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.stream.Collectors;

public interface Metric {
    public static final String HELP_LINE_FORMAT = "# HELP %s %s\n";
    public static final String TYPE_LINE_FORMAT = "# TYPE %s %s\n";
    public static final String NAME_WITH_LABELS_LINE_FORMAT = "%s{%s}";
    public static final String VALUE_LINE_FORMAT = "%s %s\n";

    public String metricName();

    public String getMetricExposition();

    public static String formatSingleValuedMetric(String name, String type, String help, Map<String, String> labels, String value) {
        return TYPE_LINE_FORMAT.formatted(name, type) + (Strings.isNullOrEmpty((String)help) ? "" : HELP_LINE_FORMAT.formatted(name, help)) + VALUE_LINE_FORMAT.formatted(Metric.formatNameWithLabels(name, labels), value);
    }

    public static String formatNameWithLabels(String name, Map<String, String> labels) {
        if (labels.isEmpty()) {
            return name;
        }
        return NAME_WITH_LABELS_LINE_FORMAT.formatted(name, labels.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> "%s=\"%s\"".formatted(e.getKey(), e.getValue())).collect(Collectors.joining(",")));
    }
}

