/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.opentelemetry;

import io.airlift.configuration.Config;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.concurrent.TimeUnit;

public class OpenTelemetryExporterConfig {
    private String endpoint = "http://localhost:4317";
    private Protocol protocol = Protocol.GRPC;
    private Duration interval = new Duration(1.0, TimeUnit.MINUTES);

    @NotNull
    @Pattern(regexp="^(http|https)://.*$", message="must start with http:// or https://")
    public @NotNull @Pattern(regexp="^(http|https)://.*$", message="must start with http:// or https://") String getEndpoint() {
        return this.endpoint;
    }

    @Config(value="otel.exporter.endpoint")
    @LegacyConfig(value={"tracing.exporter.endpoint"})
    public OpenTelemetryExporterConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @NotNull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Config(value="otel.exporter.protocol")
    @LegacyConfig(value={"tracing.exporter.protocol"})
    public OpenTelemetryExporterConfig setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getInterval() {
        return this.interval;
    }

    @Config(value="otel.exporter.interval")
    public OpenTelemetryExporterConfig setInterval(Duration interval) {
        this.interval = interval;
        return this;
    }

    public static enum Protocol {
        GRPC,
        HTTP_PROTOBUF;


        public static Protocol fromString(String protocol) {
            return switch (protocol) {
                case "grpc" -> GRPC;
                case "http/protobuf" -> HTTP_PROTOBUF;
                default -> throw new IllegalArgumentException("Invalid protocol: " + protocol);
            };
        }
    }
}

