/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.secrets.keystore;

import com.google.inject.Inject;
import io.airlift.secrets.keystore.KeystoreSecretProviderConfig;
import io.airlift.spi.secrets.SecretProvider;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class KeystoreSecretProvider
implements SecretProvider {
    private final KeyStore keyStore;
    private final char[] keystorePassword;

    @Inject
    public KeystoreSecretProvider(KeystoreSecretProviderConfig config) throws GeneralSecurityException, IOException {
        this.keystorePassword = config.getKeyStorePassword().toCharArray();
        this.keyStore = KeyStore.getInstance(config.getKeyStoreType());
        this.keyStore.load(new FileInputStream(config.getKeyStoreFilePath()), this.keystorePassword);
    }

    public String resolveSecretValue(String key) {
        try {
            KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)this.keyStore.getEntry(key, new KeyStore.PasswordProtection(this.keystorePassword));
            if (secretKeyEntry == null) {
                throw new RuntimeException("Key not found in keystore: " + key);
            }
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBE");
            PBEKeySpec keySpec = (PBEKeySpec)factory.getKeySpec(secretKeyEntry.getSecretKey(), PBEKeySpec.class);
            return new String(keySpec.getPassword());
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

