/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.security.cert;

import com.google.common.base.Preconditions;
import io.airlift.security.der.DerUtils;
import java.io.ByteArrayInputStream;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CertificateBuilder {
    private static final byte[] SHA_256_WITH_RSA_ENCRYPTION_OID = DerUtils.encodeOid("1.2.840.113549.1.1.11");
    private static final byte[] SUBJECT_KEY_IDENTIFIER_OID = DerUtils.encodeOid("2.5.29.14");
    private static final byte[] AUTHORITY_KEY_IDENTIFIER_OID = DerUtils.encodeOid("2.5.29.35");
    private static final byte[] BASIC_CONSTRAINTS_OID = DerUtils.encodeOid("2.5.29.19");
    private static final byte[] SUBJECT_ALT_NAME_OID = DerUtils.encodeOid("2.5.29.17");
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private long serialNumber;
    private X500Principal issuer;
    private Instant notBefore;
    private Instant notAfter;
    private X500Principal subject;
    private final List<String> sanDnsNames = new ArrayList<String>();
    private final List<InetAddress> sanIpAddresses = new ArrayList<InetAddress>();

    private CertificateBuilder() {
    }

    public static CertificateBuilder certificateBuilder() {
        return new CertificateBuilder();
    }

    public CertificateBuilder setKeyPair(KeyPair keyPair) {
        Objects.requireNonNull(keyPair, "keyPair is null");
        Preconditions.checkArgument((boolean)(keyPair.getPublic() instanceof RSAPublicKey), (String)"not an RSA key: %s", (Object)keyPair.getPublic());
        Preconditions.checkArgument((boolean)(keyPair.getPrivate() instanceof RSAPrivateKey), (String)"not an RSA key: %s", (Object)keyPair.getPrivate());
        this.setPublicKey((RSAPublicKey)keyPair.getPublic());
        this.setPrivateKey((RSAPrivateKey)keyPair.getPrivate());
        return this;
    }

    public CertificateBuilder setPublicKey(RSAPublicKey publicKey) {
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey is null");
        return this;
    }

    public CertificateBuilder setPrivateKey(RSAPrivateKey privateKey) {
        this.privateKey = Objects.requireNonNull(privateKey, "privateKey is null");
        return this;
    }

    public CertificateBuilder setSerialNumber(long serialNumber) {
        Preconditions.checkArgument((serialNumber >= 0L ? 1 : 0) != 0, (Object)"serialNumber is negative");
        this.serialNumber = serialNumber;
        return this;
    }

    public CertificateBuilder setIssuer(X500Principal issuer) {
        this.issuer = Objects.requireNonNull(issuer, "issuer is null");
        return this;
    }

    public CertificateBuilder setNotBefore(Instant notBefore) {
        this.notBefore = Objects.requireNonNull(notBefore, "notBefore is null");
        return this;
    }

    public CertificateBuilder setNotBefore(LocalDate notBefore) {
        Objects.requireNonNull(notBefore, "notBefore is null");
        this.notBefore = notBefore.atStartOfDay().toInstant(ZoneOffset.UTC);
        return this;
    }

    public CertificateBuilder setNotAfter(Instant notAfter) {
        this.notAfter = Objects.requireNonNull(notAfter, "notAfter is null");
        return this;
    }

    public CertificateBuilder setNotAfter(LocalDate notAfter) {
        Objects.requireNonNull(notAfter, "notAfter is null");
        this.notAfter = notAfter.atTime(23, 59, 59).toInstant(ZoneOffset.UTC);
        return this;
    }

    public CertificateBuilder setSubject(X500Principal subject) {
        this.subject = Objects.requireNonNull(subject, "subject is null");
        return this;
    }

    public CertificateBuilder addSanIpAddress(InetAddress address) {
        this.sanIpAddresses.add(Objects.requireNonNull(address, "address is null"));
        return this;
    }

    public CertificateBuilder addSanIpAddresses(List<InetAddress> addresses) {
        Objects.requireNonNull(addresses, "addresses is null");
        addresses.forEach(this::addSanIpAddress);
        return this;
    }

    public CertificateBuilder addSanDnsName(String dnsName) {
        this.sanDnsNames.add(Objects.requireNonNull(dnsName, "dnsName is null"));
        return this;
    }

    public CertificateBuilder addSanDnsNamees(List<String> dnsNames) {
        Objects.requireNonNull(dnsNames, "dnsNames is null");
        dnsNames.forEach(this::addSanDnsName);
        return this;
    }

    public X509Certificate buildSelfSigned() throws GeneralSecurityException {
        Preconditions.checkState((this.publicKey != null ? 1 : 0) != 0, (Object)"publicKey is not set");
        Preconditions.checkState((this.privateKey != null ? 1 : 0) != 0, (Object)"privateKey is not set");
        Preconditions.checkState((this.issuer != null ? 1 : 0) != 0, (Object)"issuer is not set");
        Preconditions.checkState((this.notBefore != null ? 1 : 0) != 0, (Object)"notBefore is not set");
        Preconditions.checkState((this.notAfter != null ? 1 : 0) != 0, (Object)"notAfter is not set");
        Preconditions.checkState((!this.notBefore.isAfter(this.notAfter) ? 1 : 0) != 0, (Object)"notAfter is before notBefore");
        Preconditions.checkState((this.subject != null ? 1 : 0) != 0, (Object)"subject is not set");
        byte[] publicKeyHash = this.hashPublicKey();
        ArrayList sans = new ArrayList();
        this.sanDnsNames.stream().map(address -> DerUtils.encodeContextSpecificTag(2, address.getBytes(StandardCharsets.UTF_8))).forEach(sans::add);
        this.sanIpAddresses.stream().map(InetAddress::getAddress).map(address -> DerUtils.encodeContextSpecificTag(7, address)).forEach(sans::add);
        byte[] rawCertificate = DerUtils.encodeSequence(DerUtils.encodeContextSpecificSequence(0, new byte[][]{DerUtils.encodeInteger(2L)}), DerUtils.encodeInteger(this.serialNumber), DerUtils.encodeSequence(SHA_256_WITH_RSA_ENCRYPTION_OID, DerUtils.encodeNull()), this.issuer.getEncoded(), DerUtils.encodeSequence(DerUtils.encodeUtcTime(this.notBefore), DerUtils.encodeUtcTime(this.notAfter)), this.subject.getEncoded(), this.publicKey.getEncoded(), DerUtils.encodeContextSpecificSequence(3, new byte[][]{DerUtils.encodeSequence(DerUtils.encodeSequence(SUBJECT_KEY_IDENTIFIER_OID, DerUtils.encodeOctetString(DerUtils.encodeOctetString(publicKeyHash))), DerUtils.encodeSequence(AUTHORITY_KEY_IDENTIFIER_OID, DerUtils.encodeOctetString(DerUtils.encodeSequence(new byte[][]{DerUtils.encodeContextSpecificTag(0, publicKeyHash)}))), DerUtils.encodeSequence(BASIC_CONSTRAINTS_OID, DerUtils.encodeBooleanTrue(), DerUtils.encodeOctetString(DerUtils.encodeSequence(new byte[][]{DerUtils.encodeBooleanTrue()}))), DerUtils.encodeSequence(SUBJECT_ALT_NAME_OID, DerUtils.encodeOctetString(DerUtils.encodeSequence((byte[][])sans.toArray((T[])new byte[0][])))))}));
        byte[] signature = this.signCertificate(rawCertificate);
        byte[] encodedCertificate = DerUtils.encodeSequence(rawCertificate, DerUtils.encodeSequence(SHA_256_WITH_RSA_ENCRYPTION_OID, DerUtils.encodeNull()), DerUtils.encodeBitString(0, signature));
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(encodedCertificate));
    }

    private byte[] signCertificate(byte[] rawCertificate) throws GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(this.privateKey);
        signature.update(rawCertificate);
        byte[] digitalSignature = signature.sign();
        return digitalSignature;
    }

    private byte[] hashPublicKey() throws NoSuchAlgorithmException {
        byte[] rawKey = DerUtils.encodeSequence(DerUtils.encodeInteger(this.publicKey.getModulus()), DerUtils.encodeInteger(this.publicKey.getPublicExponent()));
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        return digest.digest(rawKey);
    }
}

